/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlAddWmlEventHandletEvent;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlCreateNextElementHandletEvent;
import com.aligo.modules.wml.interfaces.WmlEventHookPosition;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventHookDescriptor;
import com.aligo.util.wml.TextUtils;
import com.aligo.wml.WmlCard;
import com.aligo.wml.WmlGo;
import com.aligo.wml.WmlTimer;
import com.aligo.wml.exceptions.WmlAttributeCannotBeAddedException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlRefreshHandlet
extends WmlAmlStylePathHandlet {
    private static final String PAGE_REFRESH = "page-refresh";
    private static final String REFRESH = "refresh";
    private static final String CONTENT_SEPARATOR = "; ";
    private static final String URL = "URL";
    private static final String EQUALS = "=";
    private static final String ON_ENTER_FORWARD = "onenterforward";
    private static final String ON_TIMER = "ontimer";
    private static final String EMPTY = "";
    private AxmlElement oAmlElement;
    private WmlElement oWmlElement;
    private String sRefresh;
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    private Hashtable oRefreshed = new Hashtable();
    private boolean bWmlRefresh = false;

    public Vector getEvents() {
        Vector<WmlEventHookDescriptor> events = new Vector<WmlEventHookDescriptor>();
        WmlEventHookDescriptor eventHookDescriptor = new WmlEventHookDescriptor("WmlAmlCreateNextElementHandletEvent", WmlEventHookPosition.POSITION_BEFORE);
        events.addElement(eventHookDescriptor);
        return events;
    }

    private boolean isPresent(AmlPathInterface amlPath) {
        boolean present = false;
        int realm = amlPath.getRealm();
        Integer inRealm = new Integer(realm);
        if (this.oRefreshed.get(inRealm) != null) {
            present = true;
        }
        return present;
    }

    private void setPresent(AmlPathInterface amlPath) {
        int realm = amlPath.getRealm();
        Integer inRealm = new Integer(realm);
        this.oRefreshed.put(inRealm, inRealm);
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlCreateNextElementHandletEvent) {
            WmlAmlCreateNextElementHandletEvent createNextElementEvent = (WmlAmlCreateNextElementHandletEvent)this.oCurrentEvent;
            this.oCurrentAmlPath = createNextElementEvent.getAmlPath();
            try {
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlPage) {
                    this.oStyleXmlElement = createNextElementEvent.getXmlElement();
                    WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                    if (wmlElement instanceof WmlCard) {
                        String refresh;
                        AxmlElement refreshAmlElement = null;
                        String refreshName = null;
                        String wmlRefresh = amlElement.getAxmlAttributeValue("wml_refresh");
                        this.bWmlRefresh = false;
                        if (wmlRefresh == null) {
                            AxmlElement parentAmlElement;
                            AmlPathInterface parentPath;
                            if (!this.isPresent(this.oCurrentAmlPath) && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath)) != null && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath)) instanceof AxmlDocument) {
                                refreshAmlElement = parentAmlElement;
                                refreshName = REFRESH;
                            }
                        } else {
                            this.bWmlRefresh = true;
                            refreshAmlElement = amlElement;
                            refreshName = "wml_refresh";
                        }
                        if (refreshAmlElement != null && (refresh = refreshAmlElement.getAxmlAttributeValue(refreshName)) != null) {
                            this.oAmlElement = refreshAmlElement;
                            this.oWmlElement = wmlElement;
                            this.sRefresh = refresh;
                            currentWmlAmlStylePathRelevance = 20L;
                        }
                    }
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlCreateNextElementHandletEvent) {
            try {
                AmlPathInterface amlPath = this.oCurrentAmlPath;
                this.sRefresh = TextUtils.transformAttr("href", this.sRefresh);
                WmlGo wmlGo = new WmlGo();
                wmlGo.addWmlAttribute("href", this.sRefresh);
                this.addWmlEvent(amlPath, ON_TIMER, wmlGo);
                int timeout = 0;
                try {
                    String strTimeout;
                    String attrName = "refresh_timeout";
                    if (this.bWmlRefresh) {
                        attrName = "wml_refresh_timeout";
                    }
                    if ((strTimeout = this.oAmlElement.getAxmlAttributeValue(attrName)) != null) {
                        timeout = new Integer(strTimeout);
                    }
                }
                catch (NumberFormatException ne) {
                    this.oHandlerLogger.logError(ne);
                }
                timeout = timeout == 0 ? 1 : (timeout *= 10);
                WmlTimer wmlTimer = new WmlTimer();
                String setTimeout = EMPTY + timeout;
                wmlTimer.addWmlAttribute("value", setTimeout);
                this.addWmlEvent(amlPath, EMPTY, wmlTimer);
                if (!this.bWmlRefresh) {
                    this.setPresent(amlPath);
                }
                this.bWmlRefresh = false;
            }
            catch (WmlAttributeCannotBeAddedException ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
    }

    private void addWmlEvent(AmlPathInterface amlPath, String wmlEventName, WmlElement wmlElement) throws HandlerError {
        WmlAmlAddWmlEventHandletEvent addWmlEventEvent = new WmlAmlAddWmlEventHandletEvent(amlPath, PAGE_REFRESH, wmlEventName, wmlElement);
        this.oHandlerManager.postEventNow(addWmlEventEvent);
    }
}

