/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlSetFormInputNameEvent;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlInput;
import com.aligo.wml.WmlSelect;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlInputViewHandlet
extends WmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    WmlElement wmlElement;
    private static final String VIEW = "view";
    private static final String HIDDEN = "hidden";
    private static final String NONE = "none";
    private static final String SHOW = "show";

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            WmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) {
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                try {
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(VIEW)) {
                        AligoEventInterface event = this.oCurrentEvent;
                        this.wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                        this.oCurrentEvent = event;
                        if (this.wmlElement instanceof WmlInput || this.wmlElement instanceof WmlSelect) {
                            currentWmlAmlStylePathRelevance = 20L;
                        }
                    }
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (this.wmlElement instanceof WmlInput || this.wmlElement instanceof WmlSelect)) {
                    String inputValue;
                    String inputName;
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    Object previousWmlElement = null;
                    AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                    if (this.wmlElement instanceof WmlInput) {
                        inputName = axmlElement.getAxmlAttributeValue("name");
                        inputValue = ((WmlInput)this.wmlElement).getWmlAttributeValue("value");
                    } else {
                        inputName = axmlElement.getAxmlAttributeValue("name");
                        inputValue = ((WmlSelect)this.wmlElement).getWmlAttributeValue("ivalue");
                    }
                    if (amlAttributeName.toLowerCase().equals(VIEW)) {
                        if (amlAttributeValue.toLowerCase().equals(HIDDEN)) {
                            WmlElement topWmlElement = WmlAmlElementUtils.getTopWmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                            topWmlElement.removeAll();
                            if (inputName != null && !inputName.equals("")) {
                                WmlAmlSetFormInputNameEvent setFormInputNameEvent = new WmlAmlSetFormInputNameEvent();
                                setFormInputNameEvent.setInputName(inputName);
                                setFormInputNameEvent.setInputValue(inputValue);
                                setFormInputNameEvent.setAmlPath(this.oCurrentAmlPath);
                                this.oHandlerManager.postEventNow(setFormInputNameEvent);
                            }
                        } else if (amlAttributeValue.toLowerCase().indexOf(NONE) != -1) {
                            WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement.getWmlParentElement(), this.wmlElement);
                        } else if (amlAttributeValue.toLowerCase().indexOf(SHOW) != -1 && inputName != null && !inputName.equals("")) {
                            WmlAmlSetFormInputNameEvent setFormInputNameEvent = new WmlAmlSetFormInputNameEvent();
                            setFormInputNameEvent.setInputName(inputName);
                            setFormInputNameEvent.setAmlPath(this.oCurrentAmlPath);
                            this.oHandlerManager.postEventNow(setFormInputNameEvent);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof WmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                WmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new WmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                WmlAmlAddNextAttributeHandletEvent wmlAmlAddNextAttributeHandletEvent = new WmlAmlAddNextAttributeHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(wmlAmlAddNextAttributeHandletEvent);
            }
        }
    }
}

