/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlInput;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlInputFormatHandlet
extends WmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    WmlElement wmlElement;
    private static final String FORMAT = "format";
    private static final String JAPANESE_ENCODING = "SHIFT_JIS";
    public static final String FORMAT_NUMERIC = "*N";
    public static final String FORMAT_JAPANESE_ALPHABETIC = "*M";
    public static final String FORMAT_ENGLISH_ALPHABETIC = "*m";
    public static final String FORMAT_ALPHA_NUMERIC_UPPER_CASE = "*X";
    public static final String FORMAT_ALPHA_NUMERIC_LOWER_CASE = "*x";
    public static final String FORMAT_ALPHA_ONLY_UPPER_CASE = "*A";
    public static final String FORMAT_ALPHA_ONLY_LOWER_CASE = "*a";
    private AmlPathInterface saCurrentAmlPath;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            WmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) {
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(FORMAT)) {
                    try {
                        AligoEventInterface event = this.oCurrentEvent;
                        this.wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                        this.oCurrentEvent = event;
                        if (this.wmlElement instanceof WmlInput) {
                            currentWmlAmlStylePathRelevance = 20L;
                        }
                    }
                    catch (Exception ex) {
                        this.oHandlerLogger.logError(ex);
                    }
                }
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.wmlElement instanceof WmlInput) {
                    AxmlElement axmlElement;
                    String amlAttributeValue;
                    this.saCurrentAmlPath = ((WmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getAmlPath();
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    if (amlAttributeName.toLowerCase().equals(FORMAT) && (amlAttributeValue = (axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath)).getAxmlAttributeValue(amlAttributeName)) != null) {
                        AxmlElement amlDocument = AmlPathUtils.getRootAmlElement(this.oHandlerManager);
                        String encoding = amlDocument.getAxmlAttributeValue("encoding");
                        if (amlAttributeValue.equals("numeric")) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_NUMERIC);
                        } else if (amlAttributeValue.equals("localizedalphanumeric")) {
                            if (encoding != null && encoding.toUpperCase().indexOf(JAPANESE_ENCODING) != -1) {
                                WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_JAPANESE_ALPHABETIC);
                            } else {
                                WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_ENGLISH_ALPHABETIC);
                            }
                        } else if (amlAttributeValue.equals("alphanumeric")) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_ENGLISH_ALPHABETIC);
                        } else if (amlAttributeValue.equals("alphanumericuppercase")) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_ALPHA_NUMERIC_UPPER_CASE);
                        } else if (amlAttributeValue.equals("alphanumericlowercase")) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_ALPHA_NUMERIC_LOWER_CASE);
                        } else if (amlAttributeValue.equals("alphaonlyuppercase")) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_ALPHA_ONLY_UPPER_CASE);
                        } else if (amlAttributeValue.equals("alphaonlylowercase")) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, FORMAT_ALPHA_ONLY_LOWER_CASE);
                        } else {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.wmlElement, FORMAT, amlAttributeValue);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof WmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                WmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new WmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                WmlAmlAddNextAttributeHandletEvent wmlAmlAddNextAttributeHandletEvent = new WmlAmlAddNextAttributeHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(wmlAmlAddNextAttributeHandletEvent);
            }
        }
    }
}

