/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml;

import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.wml.WmlAmlPathHandler;
import com.aligo.modules.wml.errors.WmlAmlHandlerError;
import com.aligo.modules.wml.events.WmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlAddCreatedIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlCompactElementHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetCreatedIndicesHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetNextChildIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlIsAncestorPersistentHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlRemoveCreatedIndexHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlNextIndexNotFoundPersistException;
import com.aligo.modules.wml.exceptions.WmlAmlPreviousIndexNotFoundPersistException;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlAmlMemoryUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlPersistChildHandler
extends WmlAmlPathHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    public static final String HEADER_TRUE = "true";
    private Hashtable oPathIndices = new Hashtable();
    private Hashtable oIsPersistent = new Hashtable();
    private Hashtable oCompactIndices = new Hashtable();
    private Hashtable oCreatedIndices = new Hashtable();

    public Hashtable getPathIndices(AmlPathInterface amlPath) {
        String strAmlPath = amlPath.toString();
        Hashtable indices = (Hashtable)this.oPathIndices.get(strAmlPath);
        if (indices == null) {
            indices = new Hashtable();
            this.oPathIndices.put(strAmlPath, indices);
        }
        return indices;
    }

    private int getCompactIndex(AmlPathInterface amlPath) {
        String strAmlPath = amlPath.toString();
        int compactIndex = 0;
        Integer ICompactIndex = (Integer)this.oCompactIndices.get(strAmlPath);
        if (ICompactIndex != null) {
            compactIndex = ICompactIndex;
        }
        return compactIndex;
    }

    private void setCompactIndex(AmlPathInterface amlPath, int compactIndex) {
        String strAmlPath = amlPath.toString();
        this.oCompactIndices.put(strAmlPath, new Integer(compactIndex));
    }

    private void addCreatedIndex(AmlPathInterface amlPath, int index) {
        Vector indices = this.getCreatedIndices(amlPath);
        indices.addElement(new Integer(index));
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug(" amlPath = " + amlPath + " index " + index);
        }
    }

    private void removeCreatedIndex(AmlPathInterface amlPath, int index) {
        Vector indices = this.getCreatedIndices(amlPath, false);
        indices.remove(new Integer(index));
    }

    private Vector getCreatedIndices(AmlPathInterface parentPath) {
        return this.getCreatedIndices(parentPath, true);
    }

    private Vector getCreatedIndices(AmlPathInterface amlPath, boolean create) {
        String strAmlPath = amlPath.toString();
        Vector indices = (Vector)this.oCreatedIndices.get(strAmlPath);
        if (indices == null && create) {
            indices = new Vector();
            this.oCreatedIndices.put(strAmlPath, indices);
        }
        return indices;
    }

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlGetNextChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetPreviousChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlIsAncestorPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlCompactElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddCreatedIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlRemoveCreatedIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetCreatedIndicesHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlPathRelevance() {
        long currentWmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlGetNextChildIndexHandlerEvent) {
            WmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = (WmlAmlGetNextChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getNextChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null) {
                int currentIndex = getNextChildIndexEvent.getCurrentIndex();
                boolean relevant = false;
                relevant = currentIndex == -1 ? true : this.isRelevant(parentAmlPath);
                if (relevant) {
                    currentWmlAmlPathRelevance = 30L;
                }
            }
        } else if (this.oCurrentEvent instanceof WmlAmlGetPreviousChildIndexHandlerEvent) {
            boolean relevant;
            WmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = (WmlAmlGetPreviousChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getPreviousChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null && (relevant = this.isRelevant(parentAmlPath))) {
                currentWmlAmlPathRelevance = 30L;
            }
        } else if (this.oCurrentEvent instanceof WmlAmlAddChildContainerHandlerEvent) {
            WmlAmlAddChildContainerHandlerEvent addChildContainerEvent = (WmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addChildContainerEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null && this.isRelevant(parentAmlPath)) {
                try {
                    AxmlElement childAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (!this.isPersistentElement(childAmlElement)) {
                        currentWmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            }
        } else if (this.oCurrentEvent instanceof WmlAmlIsAncestorPersistentHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlCompactElementHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlAddCreatedIndexHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlRemoveCreatedIndexHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetCreatedIndicesHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        }
        return currentWmlAmlPathRelevance;
    }

    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlGetNextChildIndexHandlerEvent) {
            WmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = (WmlAmlGetNextChildIndexHandlerEvent)this.oCurrentEvent;
            int currentIndex = getNextChildIndexEvent.getCurrentIndex();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int nextIndex = 0;
            if (currentIndex == -1) {
                this.prepareIndices(parentAmlPath);
            }
            nextIndex = this.getNextChildIndex(parentAmlPath, currentIndex);
            getNextChildIndexEvent.setNextIndex(nextIndex);
        } else if (this.oCurrentEvent instanceof WmlAmlGetPreviousChildIndexHandlerEvent) {
            WmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = (WmlAmlGetPreviousChildIndexHandlerEvent)this.oCurrentEvent;
            int currentIndex = getPreviousChildIndexEvent.getCurrentIndex();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int previousIndex = this.getPreviousChildIndex(parentAmlPath, currentIndex);
            getPreviousChildIndexEvent.setPreviousIndex(previousIndex);
        } else if (this.oCurrentEvent instanceof WmlAmlAddChildContainerHandlerEvent) {
            WmlAmlAddChildContainerHandlerEvent addChildContainerEvent = (WmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = this.oCurrentAmlPath;
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            int originalIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            int childIndex = this.getAddChildIndex(currentAmlPath);
            WmlElement wmlElement = WmlAmlElementUtils.getChildContainerWmlElement(this.oHandlerManager, parentAmlPath);
            WmlElement childWmlElement = addChildContainerEvent.getWmlElement();
            int childSubIndex = addChildContainerEvent.getChildIndex();
            if (childSubIndex == -1) {
                childSubIndex = 0;
            }
            WmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = new WmlAmlControlMenuOffsetHandlerEvent(currentAmlPath, childIndex);
            this.oHandlerManager.postEventNow(controlMenuOffsetEvent);
            int cmOffsetChildIndex = controlMenuOffsetEvent.getOffsetChildIndex();
            childIndex = cmOffsetChildIndex != -1 ? cmOffsetChildIndex + childSubIndex : (childIndex += childSubIndex);
            int compactIndex = this.getCompactIndex(parentAmlPath);
            childIndex -= compactIndex;
            try {
                AxmlElement trElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                if (trElement instanceof AxmlTableRow) {
                    int trChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
                    AxmlElement tElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                    int numHeaders = 0;
                    int i = 0;
                    while (i < trChildIndex) {
                        String value;
                        AxmlElement itTrElement = tElement.axmlElementAt(i);
                        if (itTrElement instanceof AxmlTableRow && (value = itTrElement.getAxmlAttributeValue("header")) != null && value.equals(HEADER_TRUE)) {
                            ++numHeaders;
                        }
                        ++i;
                    }
                    if ((childIndex -= numHeaders) < 0) {
                        childIndex = -1;
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, parentAmlPath, wmlElement, childWmlElement, childIndex);
            if (parentAmlPath != null) {
                this.addCreatedIndex(parentAmlPath, originalIndex);
            }
        } else if (this.oCurrentEvent instanceof WmlAmlIsAncestorPersistentHandlerEvent) {
            WmlAmlIsAncestorPersistentHandlerEvent isAncestorPersistentEvent = (WmlAmlIsAncestorPersistentHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = isAncestorPersistentEvent.getAmlPath();
            boolean persistent = this.isAncestorPersistent(amlPath);
            isAncestorPersistentEvent.setPersistent(persistent);
        } else if (this.oCurrentEvent instanceof WmlAmlCompactElementHandlerEvent) {
            int compactIndex = this.getCompactIndex(this.oCurrentAmlPath);
            this.setCompactIndex(this.oCurrentAmlPath, ++compactIndex);
        } else if (this.oCurrentEvent instanceof WmlAmlAddCreatedIndexHandlerEvent) {
            WmlAmlAddCreatedIndexHandlerEvent addCreatedIndexEvent = (WmlAmlAddCreatedIndexHandlerEvent)this.oCurrentEvent;
            int index = addCreatedIndexEvent.getIndex();
            if (this.oCurrentAmlPath != null) {
                this.addCreatedIndex(this.oCurrentAmlPath, index);
            }
        } else if (this.oCurrentEvent instanceof WmlAmlRemoveCreatedIndexHandlerEvent) {
            WmlAmlRemoveCreatedIndexHandlerEvent removeCreatedIndexEvent = (WmlAmlRemoveCreatedIndexHandlerEvent)this.oCurrentEvent;
            int index = removeCreatedIndexEvent.getIndex();
            try {
                this.removeCreatedIndex(this.oCurrentAmlPath, index);
            }
            catch (Exception ex) {
                throw new WmlAmlHandlerError(ex);
            }
        } else if (this.oCurrentEvent instanceof WmlAmlGetCreatedIndicesHandlerEvent) {
            WmlAmlGetCreatedIndicesHandlerEvent getCreatedIndicesEvent = (WmlAmlGetCreatedIndicesHandlerEvent)this.oCurrentEvent;
            Vector indices = this.getCreatedIndices(this.oCurrentAmlPath);
            getCreatedIndicesEvent.setIndices(indices);
        }
    }

    private int getAddChildIndex(AmlPathInterface currentAmlPath) throws HandlerError {
        int addChildIndex = -1;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        AmlPathInterface lastWorkingPath = WmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        if (lastWorkingPath == null) {
            addChildIndex = childIndex;
        } else {
            int currentNumberElements = currentAmlPath.getNumberAmlPathComponents();
            int numberElements = lastWorkingPath.getNumberAmlPathComponents();
            try {
                boolean memoryCache = false;
                AmlPathInterface amlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                AmlPathInterface parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath);
                if (this.arePathsConcurrent(amlPath, parentLastWorkingPath)) {
                    memoryCache = true;
                }
                if (!memoryCache) {
                    addChildIndex = childIndex;
                } else if (numberElements < currentNumberElements) {
                    addChildIndex = childIndex;
                } else {
                    AmlPathComponentInterface pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1);
                    int lastChildIndex = pathComponent.getPathIndex();
                    if (childIndex >= lastChildIndex) {
                        addChildIndex = this.getNumberPersistElements(amlPath, lastChildIndex);
                        addChildIndex += childIndex - lastChildIndex;
                    }
                }
            }
            catch (AmlPathIndexOutOfBoundsException ae) {
                // empty catch block
            }
        }
        return addChildIndex;
    }

    private int getNumberPersistElements(AmlPathInterface parentPath, int lastChildIndex) {
        int numberPersistElements = 0;
        if (parentPath != null) {
            try {
                AxmlElement parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath);
                int numberChildren = parentAmlElement.getNumberElements();
                if (lastChildIndex > numberChildren) {
                    lastChildIndex = numberChildren;
                }
                try {
                    int i = 0;
                    while (i < lastChildIndex) {
                        AxmlElement childAmlElement = parentAmlElement.axmlElementAt(i);
                        if (this.isPersistentElement(childAmlElement)) {
                            ++numberPersistElements;
                        }
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {}
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return numberPersistElements;
    }

    private boolean isRelevant(AmlPathInterface amlPath) {
        String strAmlPath;
        Boolean boPersistent;
        boolean relevant = false;
        AmlPathInterface lastWorkingPath = null;
        try {
            lastWorkingPath = WmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        if (lastWorkingPath != null) {
            relevant = true;
        }
        if (!relevant && (boPersistent = (Boolean)this.oIsPersistent.get(strAmlPath = amlPath.toString())) != null) {
            relevant = boPersistent;
        }
        return relevant;
    }

    private boolean arePathsConcurrent(AmlPathInterface path1, AmlPathInterface path2) {
        boolean concurrent = false;
        if (path1 != null && path2 != null) {
            int path2Elements;
            int path1Elements = path1.getNumberAmlPathComponents();
            if (path1Elements <= (path2Elements = path2.getNumberAmlPathComponents())) {
                try {
                    boolean equal = true;
                    int i = 0;
                    while (i < path1Elements && equal) {
                        AmlPathComponentInterface memoryComponent;
                        int memoryPathIndex;
                        AmlPathComponentInterface component = path1.getAmlPathComponentAt(i);
                        int pathIndex = component.getPathIndex();
                        if (pathIndex != (memoryPathIndex = (memoryComponent = path2.getAmlPathComponentAt(i)).getPathIndex())) {
                            equal = false;
                        }
                        ++i;
                    }
                    if (equal) {
                        concurrent = true;
                    }
                }
                catch (AmlPathIndexOutOfBoundsException ae) {}
            }
        } else if (path1 == null && path2 == null) {
            concurrent = true;
        }
        return concurrent;
    }

    private int getNextTableIndex(AmlPathInterface amlPath, int currentIndex) throws Exception {
        int nextIndex = currentIndex;
        Hashtable indices = this.getPathIndices(amlPath);
        boolean error = false;
        if (indices != null) {
            Integer nextIIndex = (Integer)indices.get(new Integer(currentIndex));
            if (nextIIndex != null) {
                nextIndex = nextIIndex;
            } else {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new WmlAmlNextIndexNotFoundPersistException(amlPath, currentIndex);
        }
        return nextIndex;
    }

    private int getPreviousTableIndex(AmlPathInterface amlPath, int currentIndex) throws Exception {
        int previousIndex = currentIndex;
        Hashtable indices = this.getPathIndices(amlPath);
        boolean error = false;
        boolean found = false;
        if (indices != null) {
            Enumeration keys = indices.keys();
            Integer IcurrentIndex = new Integer(currentIndex);
            while (keys.hasMoreElements() && !found) {
                Integer key = (Integer)keys.nextElement();
                Integer value = (Integer)indices.get(key);
                if (value == null || !IcurrentIndex.equals(value)) continue;
                previousIndex = key;
                found = true;
            }
            if (!found) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new WmlAmlPreviousIndexNotFoundPersistException(amlPath, currentIndex);
        }
        return previousIndex;
    }

    private int getNextChildIndex(AmlPathInterface amlPath, int currentIndex) throws HandlerError {
        AmlPathInterface lastWorkingPath = WmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        return this.getNextChildIndex(amlPath, currentIndex, lastWorkingPath);
    }

    private int getPreviousChildIndex(AmlPathInterface amlPath, int currentIndex) throws HandlerError {
        AmlPathInterface lastWorkingPath = WmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        return this.getPreviousChildIndex(amlPath, currentIndex, lastWorkingPath);
    }

    private int getNextChildIndex(AmlPathInterface amlPath, int currentIndex, AmlPathInterface lastWorkingPath) throws HandlerError {
        try {
            int nextIndex = this.getNextTableIndex(amlPath, currentIndex);
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            try {
                if (nextIndex < numberChildren) {
                    AmlPathInterface parentLastWorkingPath;
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, nextIndex);
                    boolean persistent = this.isAncestorPersistent(childAmlPath);
                    boolean memoryCache = false;
                    if (lastWorkingPath != null && this.arePathsConcurrent(amlPath, parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath))) {
                        memoryCache = true;
                    }
                    if (!persistent && memoryCache) {
                        AmlPathComponentInterface pathComponent;
                        int lastChildIndex;
                        int currentNumberElements = amlPath.getNumberAmlPathComponents() + 1;
                        int numberElements = lastWorkingPath.getNumberAmlPathComponents();
                        if (currentNumberElements != 0 && numberElements >= currentNumberElements && nextIndex < (lastChildIndex = (pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1)).getPathIndex())) {
                            nextIndex = this.getNextChildIndex(amlPath, nextIndex, lastWorkingPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                throw new WmlAmlHandlerError(ex);
            }
            return nextIndex;
        }
        catch (Exception ex) {
            throw new WmlAmlHandlerError(ex);
        }
    }

    private int getPreviousChildIndex(AmlPathInterface amlPath, int currentIndex, AmlPathInterface lastWorkingPath) throws HandlerError {
        try {
            int previousIndex = this.getPreviousTableIndex(amlPath, currentIndex);
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            try {
                if (previousIndex >= 0) {
                    AmlPathInterface parentLastWorkingPath;
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, previousIndex);
                    boolean persistent = this.isAncestorPersistent(childAmlPath);
                    boolean memoryCache = false;
                    if (lastWorkingPath != null && this.arePathsConcurrent(amlPath, parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath))) {
                        memoryCache = true;
                    }
                    if (!persistent && memoryCache) {
                        AmlPathComponentInterface pathComponent;
                        int lastChildIndex;
                        int currentNumberElements = amlPath.getNumberAmlPathComponents() + 1;
                        int numberElements = lastWorkingPath.getNumberAmlPathComponents();
                        if (currentNumberElements != 0 && numberElements >= currentNumberElements && previousIndex < (lastChildIndex = (pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1)).getPathIndex())) {
                            previousIndex = this.getPreviousChildIndex(amlPath, previousIndex, lastWorkingPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new WmlAmlHandlerError(ex);
            }
            return previousIndex;
        }
        catch (Exception ex) {
            throw new WmlAmlHandlerError(ex);
        }
    }

    private boolean isAncestorPersistent(AmlPathInterface amlPath) {
        boolean persistent = false;
        AmlPathInterface rPath = amlPath;
        boolean done = false;
        try {
            while (rPath != null && !done) {
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, rPath);
                if (this.isPersistentElement(amlElement)) {
                    persistent = true;
                    done = true;
                }
                rPath = AmlPathUtils.getParentPath(this.oHandlerManager, rPath);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return persistent;
    }

    private boolean isPersistentElement(AxmlElement amlElement) {
        boolean persistentElement = false;
        if (amlElement instanceof AxmlControlMenu) {
            persistentElement = true;
        } else {
            String value;
            if (amlElement instanceof AxmlTableRow && (value = amlElement.getAxmlAttributeValue("header")) != null && value.equals(HEADER_TRUE)) {
                persistentElement = true;
            }
            if (!persistentElement && (amlElement instanceof AxmlInput || amlElement instanceof AxmlTextArea || amlElement instanceof AxmlChoice) && (value = amlElement.getAxmlAttributeValue("view")) != null && value.equals("hidden")) {
                persistentElement = true;
            }
            if (!persistentElement && (value = amlElement.getAxmlAttributeValue(PERSIST)) != null && !value.equals(PERSIST_FALSE)) {
                persistentElement = true;
            }
        }
        return persistentElement;
    }

    private void prepareIndices(AmlPathInterface amlPath) {
        try {
            boolean isPersistent = false;
            Hashtable indices = this.getPathIndices(amlPath);
            String strAmlPath = amlPath.toString();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            Vector<Integer> persistIndices = new Vector<Integer>();
            Vector<Integer> normalIndices = new Vector<Integer>();
            int i = 0;
            while (i < numberChildren) {
                try {
                    AxmlElement childAmlElement = amlElement.axmlElementAt(i);
                    if (this.isPersistentElement(childAmlElement)) {
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("persist i= " + i);
                        }
                        if (!isPersistent) {
                            this.oIsPersistent.put(strAmlPath, new Boolean(true));
                            isPersistent = true;
                        }
                        persistIndices.addElement(new Integer(i));
                    } else {
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("normal i= " + i);
                        }
                        normalIndices.addElement(new Integer(i));
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                ++i;
            }
            Integer lpin = new Integer(-1);
            int psize = persistIndices.size();
            int i2 = 0;
            while (i2 < psize) {
                Integer pin = (Integer)persistIndices.elementAt(i2);
                indices.put(lpin, pin);
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug(" lpin = " + lpin + " pin " + pin);
                }
                lpin = pin;
                ++i2;
            }
            int nsize = normalIndices.size();
            int i3 = 0;
            while (i3 < nsize) {
                Integer nin = (Integer)normalIndices.elementAt(i3);
                indices.put(lpin, nin);
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug(" lpin = " + lpin + " pin " + nin);
                }
                lpin = nin;
                ++i3;
            }
            indices.put(lpin, new Integer(numberChildren));
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }
}

