/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.wml.WmlAmlPathHandler;
import com.aligo.modules.wml.events.WmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlAddCreatedIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.modules.wml.util.exceptions.WmlAmlGetRootElementFailedException;
import com.aligo.wml.WmlContainer;
import com.aligo.wml.WmlP;
import com.aligo.wml.exceptions.WmlTextCannotBeSetException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlAddChildContainerHandler
extends WmlAmlPathHandler {
    private static final String SPACE = "&nbsp;";
    private Hashtable oControlMenuPresentTable = new Hashtable();
    private Hashtable oControlMenuContainerTable = new Hashtable();

    private boolean isControlMenuPresent(AmlPathInterface currentAmlPath) {
        boolean present = false;
        String pathString = currentAmlPath.toString();
        Boolean bPresent = (Boolean)this.oControlMenuPresentTable.get(pathString);
        if (bPresent != null) {
            present = bPresent;
        }
        return present;
    }

    private void setControlMenuPresent(AmlPathInterface currentAmlPath, boolean present) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuPresentTable.put(pathString, new Boolean(present));
    }

    private WmlElement getControlMenuContainer(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        WmlElement wmlElement = (WmlElement)this.oControlMenuContainerTable.get(pathString);
        return wmlElement;
    }

    private void setControlMenuContainer(AmlPathInterface currentAmlPath, WmlElement wmlElement) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuContainerTable.put(pathString, wmlElement);
    }

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddControlMenuElementHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlPathRelevance() {
        long currentWmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddChildContainerHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlControlMenuOffsetHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlAddControlMenuElementHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        }
        return currentWmlAmlPathRelevance;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws WmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        AmlPathInterface parentAmlPath;
        AxmlElement amlElement;
        int numberChildren;
        int numberMenus = 0;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        if (childIndex > (numberChildren = (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))).getNumberElements()) - 1) {
            childIndex = numberChildren - 1;
        }
        int i = 0;
        while (i < childIndex) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private void createControlMenuContainer(AmlPathInterface amlPath, WmlElement wmlElement) throws HandlerError {
        WmlP wmlP = new WmlP();
        try {
            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, amlPath, wmlElement, wmlP, 0);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        this.setControlMenuPresent(amlPath, true);
        this.setControlMenuContainer(amlPath, wmlP);
    }

    private WmlElement composeSpace() {
        WmlContainer wmlContainer = new WmlContainer();
        try {
            wmlContainer.setText(SPACE);
        }
        catch (WmlTextCannotBeSetException wmlTextCannotBeSetException) {
            // empty catch block
        }
        return wmlContainer;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof WmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlAddChildContainerHandlerEvent) {
            WmlAmlAddChildContainerHandlerEvent wmlAmlAddChildContainerHandlerEvent = (WmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            WmlElement childWmlElement = wmlAmlAddChildContainerHandlerEvent.getWmlElement();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int originalIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
            WmlElement wmlElement = WmlAmlElementUtils.getChildContainerWmlElement(this.oHandlerManager, parentAmlPath);
            int childIndex = wmlAmlAddChildContainerHandlerEvent.getChildIndex();
            AmlPathInterface elementContainerPath = null;
            elementContainerPath = parentAmlPath == null ? this.oCurrentAmlPath : parentAmlPath;
            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, elementContainerPath, wmlElement, childWmlElement, childIndex);
            WmlAmlAddCreatedIndexHandlerEvent addCreatedIndexEvent = new WmlAmlAddCreatedIndexHandlerEvent(parentAmlPath, originalIndex);
            this.oHandlerManager.postEventNow(addCreatedIndexEvent);
        } else if (this.oCurrentEvent instanceof WmlAmlControlMenuOffsetHandlerEvent) {
            int childIndex;
            WmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (WmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int offsetChildIndex = childIndex = controlMenuOffsetEvent.getChildIndex();
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
        } else if (this.oCurrentEvent instanceof WmlAmlAddControlMenuElementHandlerEvent) {
            WmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = (WmlAmlAddControlMenuElementHandlerEvent)this.oCurrentEvent;
            WmlElement childWmlElement = addControlMenuElementEvent.getWmlElement();
            WmlElement wmlElement = WmlAmlElementUtils.getChildContainerWmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            try {
                WmlAmlElementUtils.addWmlElement(this.oHandlerManager, this.oCurrentAmlPath, wmlElement, childWmlElement, 0);
            }
            catch (HandlerError he) {
                this.checkThrow(he);
            }
        }
    }
}

