/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.xhtml;

import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;
import com.aligo.xhtml.exceptions.XHtmlElementNotFoundException;
import com.aligo.xhtml.interfaces.XHtmlElement;

public class XHtmlTreeUtils {
    public static XHtmlElement getXHtmlElement(XHtmlElement xhtmlElement, PathInterface path) throws PathInvalidException {
        XHtmlElement currentElement = xhtmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getXHtmlParentElement() : currentElement.xhtmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getXHtmlPath(XHtmlElement topElement, XHtmlElement xhtmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            XHtmlElement xhtmlParentElement = xhtmlElement.getXHtmlParentElement();
            if (xhtmlParentElement != null) {
                int xhtmlIndex = 0;
                try {
                    xhtmlIndex = xhtmlParentElement.xhtmlElementIndex(xhtmlElement);
                }
                catch (XHtmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(xhtmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (xhtmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                xhtmlElement = xhtmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

