/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.html;

import com.aligo.html.exceptions.HtmlElementNotFoundException;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;

public class HtmlTreeUtils {
    public static HtmlElement getHtmlElement(HtmlElement htmlElement, PathInterface path) throws PathInvalidException {
        HtmlElement currentElement = htmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getHtmlParentElement() : currentElement.htmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getHtmlPath(HtmlElement topElement, HtmlElement htmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            HtmlElement htmlParentElement = htmlElement.getHtmlParentElement();
            if (htmlParentElement != null) {
                int htmlIndex = 0;
                try {
                    htmlIndex = htmlParentElement.htmlElementIndex(htmlElement);
                }
                catch (HtmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(htmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (htmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                htmlElement = htmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

