/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.styles;

import com.aligo.modules.styles.AmlElement;
import com.aligo.modules.styles.XmlAmlAttribute;
import com.aligo.modules.styles.XmlAmlHandlerAttribute;
import com.aligo.modules.styles.XmlAmlSimpleAttribute;
import com.aligo.modules.styles.XmlContainer;
import com.aligo.modules.styles.XmlContainerAttribute;
import com.aligo.modules.styles.XmlHandlerAttribute;
import com.aligo.modules.styles.XmlSimpleAttribute;
import com.aligo.modules.styles.XmlText;
import com.aligo.modules.styles.exceptions.XmlAttributeIndexOutOfBoundsException;
import com.aligo.modules.styles.exceptions.XmlAttributeNotFoundException;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.exceptions.XmlElementNotFoundException;
import com.aligo.modules.styles.interfaces.XmlAmlAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAmlSimpleAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.styles.interfaces.XmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlSimpleAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlTextInterface;
import com.aligo.modules.styles.paths.AmlAttributePath;
import com.aligo.modules.styles.paths.AmlAttributePathComponent;
import com.aligo.modules.styles.paths.exceptions.AmlAttributePathIndexOutOfBoundsException;
import com.aligo.modules.styles.paths.interfaces.AmlAttributePathInterface;
import com.aligo.parsing.XMLTextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElement
implements XmlElementInterface {
    String sName;
    Vector oChildren = new Vector();
    Vector oAttributes = new Vector();
    XmlTextInterface oXmlText;
    XmlElementInterface oParentXmlElement = null;
    private static final String REPRESENTATION = "Representation";
    private static final String CONTAINER = "Container";
    private static final String CHILD_CONTAINER = "child-container";
    private static final String AML_EMPTY_STR = "aml:empty_str";
    private static final String AML_CHILD = "aml:child";
    private static final String AML_HANDLER = "aml:handler";
    private static final String XML_HANDLER = "xml:handler";
    private static final String AML_COLON = "Aml";
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String CAMA = ",";
    private static final String EQUAL = "=";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String END_LT = "</";
    private static final String END_GT = "/>";
    private static final String SLASH = "/";

    public void setXmlElementName(String name) {
        this.sName = name;
    }

    public String getXmlElementName() {
        return this.sName;
    }

    public void addXmlElement(XmlElementInterface xmlElement) {
        this.oChildren.addElement(xmlElement);
        xmlElement.setParentXmlElement(this);
    }

    public void removeXmlElement(XmlElementInterface xmlElement) {
        xmlElement.setParentXmlElement(null);
        this.oChildren.remove(xmlElement);
    }

    public int getNumberXmlElements() {
        return this.oChildren.size();
    }

    public XmlElementInterface getXmlElement(int index) throws XmlElementIndexOutOfBoundsException {
        try {
            return (XmlElementInterface)this.oChildren.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new XmlElementIndexOutOfBoundsException(ae.toString());
        }
    }

    public int getXmlElementIndex(XmlElementInterface xmlElement) throws XmlElementNotFoundException {
        int index = -1;
        try {
            int size = this.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < size && !done) {
                XmlElementInterface iXmlElement = this.getXmlElement(i);
                if (iXmlElement.equals(xmlElement)) {
                    index = i;
                    done = true;
                }
                ++i;
            }
        }
        catch (XmlElementIndexOutOfBoundsException xe) {
            throw new XmlElementNotFoundException(xe.toString());
        }
        if (index == -1) {
            throw new XmlElementNotFoundException();
        }
        return index;
    }

    public void addXmlAttribute(XmlAttributeInterface xmlAttribute) {
        this.oAttributes.addElement(xmlAttribute);
    }

    public void removeXmlAttribute(XmlAttributeInterface xmlAttribute) {
        this.oAttributes.remove(xmlAttribute);
    }

    public XmlAttributeInterface getXmlAttribute(int index) throws XmlAttributeIndexOutOfBoundsException {
        try {
            return (XmlAttributeInterface)this.oAttributes.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new XmlAttributeIndexOutOfBoundsException(ae.toString());
        }
    }

    public int getXmlAttributeIndex(XmlAttributeInterface xmlAttribute) throws XmlAttributeNotFoundException {
        int index = -1;
        try {
            int size = this.getNumberXmlAttributes();
            boolean done = false;
            int i = 0;
            while (i < size && !done) {
                XmlAttributeInterface iXmlAttribute = this.getXmlAttribute(i);
                if (iXmlAttribute.equals(xmlAttribute)) {
                    index = i;
                    done = true;
                }
                ++i;
            }
        }
        catch (XmlAttributeIndexOutOfBoundsException xe) {
            throw new XmlAttributeNotFoundException(xe.toString());
        }
        if (index == -1) {
            throw new XmlAttributeNotFoundException();
        }
        return index;
    }

    public int getNumberXmlAttributes() {
        return this.oAttributes.size();
    }

    public void setXmlText(XmlTextInterface xmlText) {
        this.oXmlText = xmlText;
    }

    public XmlTextInterface getXmlText() {
        return this.oXmlText;
    }

    public void setParentXmlElement(XmlElementInterface xmlElement) {
        this.oParentXmlElement = xmlElement;
    }

    public XmlElementInterface getParentXmlElement() {
        return this.oParentXmlElement;
    }

    public void fromXml(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 3: {
                if (!node.getNodeValue().trim().equals("")) {
                    XmlText xmlText = new XmlText();
                    xmlText.fromXml(node);
                    this.setXmlText(xmlText);
                }
            }
            case 1: {
                this.setXmlElementName(node.getNodeName());
                Attr[] attrs = XMLTextUtils.getAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    String attrName = attr.getName();
                    String attrValues = attr.getValue();
                    StringTokenizer st = new StringTokenizer(attrValues, CAMA);
                    while (st.hasMoreTokens()) {
                        String originalAttrValue;
                        String attrValue = st.nextToken();
                        if (attrName.equals(CHILD_CONTAINER) && attrValue.equals(AML_CHILD)) {
                            XmlContainerAttribute xmlContainerAttribute = new XmlContainerAttribute();
                            this.addXmlAttribute(xmlContainerAttribute);
                            continue;
                        }
                        if (attrValue.equals(AML_HANDLER)) {
                            XmlAmlHandlerAttribute xmlAmlHandlerAttribute = new XmlAmlHandlerAttribute();
                            xmlAmlHandlerAttribute.setAmlAttributeName(attrName);
                            this.addXmlAttribute(xmlAmlHandlerAttribute);
                            continue;
                        }
                        if (attrValue.equals(XML_HANDLER)) {
                            XmlHandlerAttribute xmlHandlerAttribute = new XmlHandlerAttribute();
                            xmlHandlerAttribute.setXmlAttributeName(attrName);
                            this.addXmlAttribute(xmlHandlerAttribute);
                            continue;
                        }
                        if (attrValue.indexOf(AML_COLON) != -1) {
                            XmlAmlSimpleAttribute xmlAmlSimpleAttribute = new XmlAmlSimpleAttribute();
                            xmlAmlSimpleAttribute.setAmlAttributeName(attrName);
                            originalAttrValue = attrValue.substring(attrValue.indexOf(COLON) + 1);
                            xmlAmlSimpleAttribute.setAmlAttributeValue(originalAttrValue);
                            this.addXmlAttribute(xmlAmlSimpleAttribute);
                            continue;
                        }
                        if (this.startsWithReservedString(attrValue)) {
                            XmlAmlAttribute xmlAmlAttribute = new XmlAmlAttribute();
                            xmlAmlAttribute.setXmlAttributeName(attrName);
                            originalAttrValue = attrValue.substring(attrValue.indexOf(COLON) + 1);
                            xmlAmlAttribute.setAmlAttributeName(originalAttrValue);
                            AmlAttributePath amlAttributePath = new AmlAttributePath();
                            String amlAttributePathComponents = attrValue.substring(0, attrValue.indexOf(COLON));
                            StringTokenizer stoken = new StringTokenizer(amlAttributePathComponents, SLASH);
                            while (stoken.hasMoreTokens()) {
                                String pathName = stoken.nextToken();
                                AmlAttributePathComponent amlAttributePathComponent = new AmlAttributePathComponent();
                                amlAttributePathComponent.setPathName(pathName);
                                amlAttributePath.addAmlAttributePathComponent(amlAttributePathComponent);
                            }
                            xmlAmlAttribute.setAmlAttributePath(amlAttributePath);
                            this.addXmlAttribute(xmlAmlAttribute);
                            continue;
                        }
                        if (attrValue.equals(AML_EMPTY_STR)) {
                            attrValue = "";
                        }
                        XmlSimpleAttribute xmlSimpleAttribute = new XmlSimpleAttribute();
                        xmlSimpleAttribute.setXmlAttributeName(attrName);
                        xmlSimpleAttribute.setXmlAttributeValue(attrValue);
                        this.addXmlAttribute(xmlSimpleAttribute);
                    }
                    ++i;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int length = children.getLength();
                int i2 = 0;
                while (i2 < length) {
                    Node childNode = children.item(i2);
                    XmlElement xmlElement = null;
                    if (childNode.getNodeType() != 3) {
                        String nodeName = childNode.getNodeName();
                        if (nodeName != null) {
                            if (nodeName.equals(CONTAINER)) {
                                xmlElement = new XmlContainer();
                            } else if (nodeName.startsWith(AML_COLON)) {
                                xmlElement = new AmlElement();
                                String amlNodeName = nodeName.substring(AML_COLON.length());
                                ((AmlElement)xmlElement).setAmlElementName(amlNodeName);
                            } else {
                                xmlElement = new XmlElement();
                            }
                            xmlElement.setXmlElementName(nodeName);
                        }
                        if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeType() == 3 && !childNode.getFirstChild().getNodeValue().trim().equals("")) {
                            XmlText xmlText = new XmlText();
                            xmlText.fromXml(childNode.getFirstChild());
                            xmlElement.setXmlText(xmlText);
                        }
                        xmlElement.fromXml(childNode);
                        if (xmlElement != null) {
                            this.addXmlElement(xmlElement);
                        }
                    }
                    ++i2;
                }
                break;
            }
        }
    }

    public String toXml() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        StringBuffer xml = new StringBuffer();
        if (this instanceof XmlContainer) {
            xml.append(LT);
            xml.append(CONTAINER);
        } else {
            xml.append(LT);
            xml.append(this.getXmlElementName());
        }
        int noOfAttributes = this.getNumberXmlAttributes();
        int i = 0;
        while (i < noOfAttributes) {
            block37: {
                try {
                    String xmlAttributeName;
                    Object obj;
                    Object obj2;
                    XmlAttributeInterface xmlAttributeInterface = this.getXmlAttribute(i);
                    if (xmlAttributeInterface instanceof XmlContainerAttribute) {
                        if (!hash.containsKey(CHILD_CONTAINER)) {
                            hash.put(CHILD_CONTAINER, AML_CHILD);
                        } else {
                            Object obj3 = hash.get(CHILD_CONTAINER);
                            hash.remove(CHILD_CONTAINER);
                            hash.put(CHILD_CONTAINER, obj3.toString() + CAMA + AML_CHILD);
                        }
                        break block37;
                    }
                    if (xmlAttributeInterface instanceof XmlAmlHandlerAttribute) {
                        XmlAmlHandlerAttributeInterface xmlAmlHandlerAttributeInterface = (XmlAmlHandlerAttributeInterface)xmlAttributeInterface;
                        String amlHandlerattribute = xmlAmlHandlerAttributeInterface.getAmlAttributeName();
                        if (!hash.containsKey(amlHandlerattribute)) {
                            hash.put(amlHandlerattribute, AML_HANDLER);
                        } else {
                            obj2 = hash.get(amlHandlerattribute);
                            hash.remove(amlHandlerattribute);
                            hash.put(amlHandlerattribute, obj2.toString() + CAMA + AML_HANDLER);
                        }
                        break block37;
                    }
                    if (xmlAttributeInterface instanceof XmlHandlerAttribute) {
                        XmlHandlerAttributeInterface xmlHandlerAttributeInterface = (XmlHandlerAttributeInterface)xmlAttributeInterface;
                        String xmlHandlerattribute = xmlHandlerAttributeInterface.getXmlAttributeName();
                        if (!hash.containsKey(xmlHandlerattribute)) {
                            hash.put(xmlHandlerattribute, XML_HANDLER);
                        } else {
                            obj2 = hash.get(xmlHandlerattribute);
                            hash.remove(xmlHandlerattribute);
                            hash.put(xmlHandlerattribute, obj2.toString() + CAMA + XML_HANDLER);
                        }
                        break block37;
                    }
                    if (xmlAttributeInterface instanceof XmlAmlSimpleAttribute) {
                        XmlAmlSimpleAttributeInterface xmlAmlSimpleAttributeInterface = (XmlAmlSimpleAttributeInterface)xmlAttributeInterface;
                        String xmlAmlAttributeName = xmlAmlSimpleAttributeInterface.getAmlAttributeName();
                        String xmlAmlAttributeValue = xmlAmlSimpleAttributeInterface.getAmlAttributeValue();
                        if (!hash.containsKey(xmlAmlAttributeName)) {
                            hash.put(xmlAmlAttributeName, AML_COLON + xmlAmlAttributeValue);
                        } else {
                            obj = hash.get(xmlAmlAttributeName);
                            hash.remove(xmlAmlAttributeName);
                            hash.put(xmlAmlAttributeName, obj.toString() + CAMA + xmlAmlAttributeValue);
                        }
                        break block37;
                    }
                    if (xmlAttributeInterface instanceof XmlAmlAttribute) {
                        XmlAmlAttributeInterface xmlAmlAttributeInterface = (XmlAmlAttributeInterface)xmlAttributeInterface;
                        xmlAttributeName = xmlAmlAttributeInterface.getXmlAttributeName();
                        String pathName = "";
                        AmlAttributePathInterface amlAttributePathInterface = xmlAmlAttributeInterface.getAmlAttributePath();
                        if (amlAttributePathInterface != null) {
                            int noOfAmlAttributePathComponents = amlAttributePathInterface.getNumberAmlAttributePathComponents();
                            int j = 0;
                            while (j < noOfAmlAttributePathComponents) {
                                try {
                                    AmlAttributePathComponent amlAttributePathComponent = (AmlAttributePathComponent)amlAttributePathInterface.getAmlAttributePathComponentAt(j);
                                    pathName = pathName + amlAttributePathComponent.getPathName() + SLASH;
                                }
                                catch (AmlAttributePathIndexOutOfBoundsException ae) {
                                    System.out.println(ae.toString());
                                }
                                ++j;
                            }
                            pathName = pathName.substring(0, pathName.length() - 1);
                        }
                        String amlAttributeName = pathName + COLON + xmlAmlAttributeInterface.getAmlAttributeName();
                        if (!hash.containsKey(xmlAttributeName)) {
                            hash.put(xmlAttributeName, amlAttributeName);
                        } else {
                            Object obj4 = hash.get(xmlAttributeName);
                            hash.remove(xmlAttributeName);
                            hash.put(xmlAttributeName, obj4.toString() + CAMA + amlAttributeName);
                        }
                        break block37;
                    }
                    if (xmlAttributeInterface instanceof XmlSimpleAttribute) {
                        XmlSimpleAttributeInterface xmlSimpleAttributeInterface = (XmlSimpleAttributeInterface)xmlAttributeInterface;
                        xmlAttributeName = xmlSimpleAttributeInterface.getXmlAttributeName();
                        String xmlAttributeValue = xmlSimpleAttributeInterface.getXmlAttributeValue();
                        if (!hash.containsKey(xmlAttributeName)) {
                            hash.put(xmlAttributeName, xmlAttributeValue);
                        } else {
                            obj = hash.get(xmlAttributeName);
                            hash.remove(xmlAttributeName);
                            hash.put(xmlAttributeName, obj.toString() + CAMA + xmlAttributeValue);
                        }
                    }
                }
                catch (XmlAttributeIndexOutOfBoundsException ae) {
                    System.out.println(ae.toString());
                }
            }
            ++i;
        }
        Enumeration keys = hash.keys();
        while (keys.hasMoreElements()) {
            Object currentKey = keys.nextElement();
            xml.append(SPACE);
            xml.append(currentKey);
            xml.append(EQUAL);
            xml.append(QUOTE);
            xml.append(hash.get(currentKey));
            xml.append(QUOTE);
        }
        int noOfChildElements = 0;
        noOfChildElements = this.getNumberXmlElements();
        XmlTextInterface xmlTextInterface = this.getXmlText();
        String value = null;
        if (xmlTextInterface != null) {
            value = xmlTextInterface.toXml();
        }
        if (value == null && noOfChildElements == 0) {
            xml.append(END_GT);
        } else if (value != null || noOfChildElements > 0) {
            xml.append(GT);
            if (value != null) {
                xml.append(value);
            }
            if (noOfChildElements > 0) {
                int i2 = 0;
                while (i2 < noOfChildElements) {
                    try {
                        XmlElementInterface xmlElement = this.getXmlElement(i2);
                        xml.append(xmlElement.toXml());
                    }
                    catch (XmlElementIndexOutOfBoundsException xe) {
                        System.out.println(xe.toString());
                    }
                    ++i2;
                }
            }
            xml.append(END_LT);
            xml.append(this.getXmlElementName());
            xml.append(GT);
        }
        return xml.toString();
    }

    private boolean startsWithReservedString(String value) {
        String[] reservedStrings = XmlAmlAttribute.getReserverdStrings();
        int i = 0;
        while (i < reservedStrings.length) {
            String reservedString = reservedStrings[i];
            if (value.startsWith(reservedString)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

