/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.modules.maps.interfaces.MapPathComponentInterface;
import com.aligo.parsing.XMLTextUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapPathComponent
implements MapPathComponentInterface {
    public static final String UNIVERSAL_PATH_COMPONENT_NAME = "*";
    public static final String UNIVERSAL_PATH_NAME = "*...";
    public static final String PATH = "Path";
    String sPathName;

    public MapPathComponent() {
    }

    public MapPathComponent(String pathName) {
        this.setPathName(pathName);
    }

    public void setPathName(String pathName) {
        this.sPathName = pathName;
    }

    public String getPathName() {
        return this.sPathName;
    }

    public boolean isUniversalPathComponent() {
        boolean universalPathComponent = false;
        String pathName = this.getPathName();
        if (pathName.equals(UNIVERSAL_PATH_COMPONENT_NAME)) {
            universalPathComponent = true;
        }
        return universalPathComponent;
    }

    public boolean isUniversalPath() {
        boolean universalPath = false;
        String pathName = this.getPathName();
        if (pathName.equals(UNIVERSAL_PATH_NAME)) {
            universalPath = true;
        }
        return universalPath;
    }

    public boolean isEqual(MapPathComponentInterface mapPathComponentInterface) {
        MapPathComponent mapPathComponent;
        String pathName;
        boolean equals = false;
        if (mapPathComponentInterface instanceof MapPathComponent && (pathName = (mapPathComponent = (MapPathComponent)mapPathComponentInterface).getPathName()).equals(this.sPathName)) {
            equals = true;
        }
        return equals;
    }

    public void fromXml(Node mapPathComponent) {
        if (mapPathComponent.getNodeType() == 1) {
            Element mapPathComponentElement = (Element)mapPathComponent;
            NodeList list = mapPathComponentElement.getChildNodes();
            if (list.item(0).getNodeValue() != null) {
                this.setPathName(list.item(0).getNodeValue());
            }
        } else {
            System.out.println("A parser caanot handle this type");
        }
    }

    public String toXml() {
        System.out.println("Entering...");
        StringBuffer xml = new StringBuffer();
        xml.append(XMLTextUtils.startElement(PATH));
        if (this.getPathName() != null) {
            xml.append(this.getPathName());
        }
        xml.append(XMLTextUtils.endElement(PATH));
        System.out.println("Leaving...");
        return xml.toString();
    }
}

