/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.jhtml.JHtmlContainer;
import com.aligo.jhtml.JHtmlDiv;
import com.aligo.jhtml.JHtmlElementCollection;
import com.aligo.jhtml.exceptions.JHtmlAttributeCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementIndexOutOfBoundsException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.jhtml.JHtmlAmlPathHandler;
import com.aligo.modules.jhtml.errors.JHtmlAmlHandlerError;
import com.aligo.modules.jhtml.events.JHtmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlCreateNextElementHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetControlMenuParentContainerHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.jhtml.exceptions.JHtmlAmlInsufficientMemoryException;
import com.aligo.modules.jhtml.util.JHtmlAmlElementUtils;
import com.aligo.modules.jhtml.util.JHtmlEventDescriptor;
import com.aligo.modules.jhtml.util.exceptions.JHtmlAmlGetRootElementFailedException;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Hashtable;
import java.util.Vector;

public class JHtmlAmlControlMenuHandler
extends JHtmlAmlPathHandler {
    private static final String SPACE = "&nbsp;";
    private Hashtable oControlMenuPresentTable = new Hashtable();
    private Hashtable oControlMenuContainerTable = new Hashtable();
    private Hashtable oCMTBNeedCopyTable = new Hashtable();
    private boolean bNoHandleCNEHandlerEvent = false;
    private Hashtable oNumberCMAddedTable = new Hashtable();

    private boolean isControlMenuPresent(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bPresent;
        boolean present = false;
        if (currentAmlPath != null && (bPresent = (Boolean)this.oControlMenuPresentTable.get(pathString = currentAmlPath.toString())) != null) {
            present = bPresent;
        }
        return present;
    }

    private void setControlMenuPresent(AmlPathInterface currentAmlPath, boolean present) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuPresentTable.put(pathString, new Boolean(present));
    }

    private JHtmlElement getControlMenuContainer(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        JHtmlElement jhtmlElement = (JHtmlElement)this.oControlMenuContainerTable.get(pathString);
        return jhtmlElement;
    }

    private void setControlMenuContainer(AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuContainerTable.put(pathString, jhtmlElement);
    }

    private boolean doesCMTBNeedCopy(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bNeedCopy;
        boolean needCopy = false;
        if (currentAmlPath != null && (bNeedCopy = (Boolean)this.oCMTBNeedCopyTable.get(pathString = currentAmlPath.toString())) != null) {
            needCopy = bNeedCopy;
        }
        return needCopy;
    }

    private void setCMTBNeedCopy(AmlPathInterface currentAmlPath, boolean needCopy) {
        String pathString = currentAmlPath.toString();
        this.oCMTBNeedCopyTable.put(pathString, new Boolean(needCopy));
    }

    private int getNumberCMAdded(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        int numAdded = 0;
        Integer inNumAdded = (Integer)this.oNumberCMAddedTable.get(pathString);
        if (inNumAdded != null) {
            numAdded = inNumAdded;
        }
        return numAdded;
    }

    private void incNumberCMAdded(AmlPathInterface currentAmlPath) {
        int numAdded = this.getNumberCMAdded(currentAmlPath);
        String pathString = currentAmlPath.toString();
        this.oNumberCMAddedTable.put(pathString, new Integer(++numAdded));
    }

    public Vector getEvents() {
        Vector<JHtmlEventDescriptor> events = new Vector<JHtmlEventDescriptor>();
        JHtmlEventDescriptor eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlAddControlMenuElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetControlMenuParentContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlCreateNextElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlIsPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long jhtmlAmlPathRelevance() {
        long currentJHtmlAmlPathRelevance;
        block21: {
            currentJHtmlAmlPathRelevance = 0L;
            if (this.oCurrentEvent instanceof JHtmlAmlAddChildContainerHandlerEvent) {
                try {
                    AmlPathInterface parentAmlPath;
                    AxmlElement parentAmlElement;
                    AmlPathInterface currentAmlPath = ((JHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) instanceof AxmlPage) {
                        currentJHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof JHtmlAmlControlMenuOffsetHandlerEvent) {
                currentJHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof JHtmlAmlAddControlMenuElementHandlerEvent) {
                currentJHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof JHtmlAmlGetControlMenuParentContainerHandlerEvent) {
                currentJHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof JHtmlAmlCreateNextElementHandlerEvent) {
                try {
                    if (!this.bNoHandleCNEHandlerEvent) {
                        int numberCM;
                        AmlPathInterface parentAmlPath;
                        int numCMAdded;
                        JHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (JHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
                        AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                        if (amlElement instanceof AxmlControlMenu && (numCMAdded = this.getNumberCMAdded(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) == (numberCM = this.getTotalControlMenus(parentAmlPath)) && this.doesCMTBNeedCopy(parentAmlPath)) {
                            currentJHtmlAmlPathRelevance = 30L;
                        }
                        break block21;
                    }
                    this.bNoHandleCNEHandlerEvent = false;
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof JHtmlAmlIsPersistentHandlerEvent) {
                try {
                    JHtmlAmlIsPersistentHandlerEvent isPersistentElementEvent = (JHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent;
                    AmlPathInterface currentAmlPath = isPersistentElementEvent.getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu) {
                        currentJHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return currentJHtmlAmlPathRelevance;
    }

    private int getTotalControlMenus(AmlPathInterface parentAmlPath) throws JHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        int numberMenus = 0;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
        int numberChildren = amlElement.getNumberElements();
        int i = 0;
        while (i < numberChildren) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws JHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        AmlPathInterface parentAmlPath;
        AxmlElement amlElement;
        int numberChildren;
        int numberMenus = 0;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        if (childIndex > (numberChildren = (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))).getNumberElements()) - 1) {
            childIndex = numberChildren - 1;
        }
        int i = 0;
        while (i < childIndex) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private void createControlMenuContainer(AmlPathInterface amlPath, JHtmlElement jhtmlElement) throws HandlerError {
        JHtmlElement controlMenuContainer = null;
        boolean oneElement = false;
        if (jhtmlElement instanceof JHtmlElementCollection) {
            int numberElements = jhtmlElement.getNumberElements();
            if (numberElements > 1) {
                controlMenuContainer = new JHtmlElementCollection();
                int i = 0;
                while (i < numberElements) {
                    try {
                        JHtmlElement cmParentContainer = jhtmlElement.jhtmlElementAt(i);
                        JHtmlElement tCMContainer = this.createCMContainerElement(amlPath, cmParentContainer);
                        controlMenuContainer.addJHtmlElement(tCMContainer);
                    }
                    catch (JHtmlElementIndexOutOfBoundsException je) {
                    }
                    catch (JHtmlElementCannotBeAddedException je) {
                        // empty catch block
                    }
                    ++i;
                }
                this.setCMTBNeedCopy(amlPath, true);
            } else {
                try {
                    jhtmlElement = jhtmlElement.jhtmlElementAt(0);
                    oneElement = true;
                }
                catch (JHtmlElementIndexOutOfBoundsException je) {}
            }
        } else {
            oneElement = true;
        }
        if (oneElement) {
            controlMenuContainer = this.createCMContainerElement(amlPath, jhtmlElement);
        }
        this.setControlMenuPresent(amlPath, true);
        this.setControlMenuContainer(amlPath, controlMenuContainer);
    }

    private JHtmlElement createCMContainerElement(AmlPathInterface amlPath, JHtmlElement jhtmlElement) throws HandlerError {
        JHtmlDiv jhtmlDiv = new JHtmlDiv();
        try {
            JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, amlPath, jhtmlElement, jhtmlDiv, 0);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        return jhtmlDiv;
    }

    private JHtmlElement composeSpace() {
        JHtmlContainer jhtmlContainer = new JHtmlContainer();
        try {
            jhtmlContainer.addJHtmlAttribute("text", SPACE);
        }
        catch (JHtmlAttributeCannotBeAddedException jHtmlAttributeCannotBeAddedException) {
            // empty catch block
        }
        return jhtmlContainer;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof JHtmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof JHtmlAmlCreateNextElementHandlerEvent) {
            JHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (JHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
            boolean memoryError = false;
            try {
                int numberElements;
                JHtmlElement cmContainer;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                if (this.doesCMTBNeedCopy(parentAmlPath) && (cmContainer = this.getControlMenuContainer(parentAmlPath)) instanceof JHtmlElementCollection && (numberElements = cmContainer.getNumberElements()) > 1) {
                    JHtmlElement filledECMContainer = cmContainer.jhtmlElementAt(0);
                    int i = 1;
                    while (i < numberElements) {
                        JHtmlElement eCMContainer = cmContainer.jhtmlElementAt(i);
                        int numberChildren = filledECMContainer.getNumberElements();
                        int j = 0;
                        while (j < numberChildren) {
                            JHtmlElement childJHtmlElement = filledECMContainer.jhtmlElementAt(j);
                            JHtmlElement clChildJHtmlElement = childJHtmlElement.cloneJHtmlElement();
                            JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, parentAmlPath, eCMContainer, clChildJHtmlElement);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof JHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.bNoHandleCNEHandlerEvent = true;
            if (memoryError) {
                JHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new JHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                JHtmlAmlCreateNextElementHandlerEvent postAgainCNEEvent = new JHtmlAmlCreateNextElementHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(postAgainCNEEvent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof JHtmlAmlAddChildContainerHandlerEvent) {
            try {
                int numberElements;
                JHtmlAmlAddChildContainerHandlerEvent jhtmlAmlAddChildContainerHandlerEvent = (JHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
                JHtmlElement childJHtmlElement = jhtmlAmlAddChildContainerHandlerEvent.getJHtmlElement();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (!(amlElement instanceof AxmlControlMenu)) return;
                boolean firstControlMenu = false;
                if (!this.isControlMenuPresent(parentAmlPath)) {
                    JHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new JHtmlAmlGetControlMenuParentContainerHandlerEvent(this.oCurrentAmlPath);
                    this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                    JHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getJHtmlElement();
                    this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                    firstControlMenu = true;
                }
                JHtmlElement jhtmlElement = this.getControlMenuContainer(parentAmlPath);
                int childIndex = jhtmlAmlAddChildContainerHandlerEvent.getChildIndex();
                if (jhtmlElement instanceof JHtmlElementCollection && (numberElements = jhtmlElement.getNumberElements()) >= 1) {
                    jhtmlElement = jhtmlElement.jhtmlElementAt(0);
                }
                this.incNumberCMAdded(parentAmlPath);
                this.addCMElement(parentAmlPath, firstControlMenu, jhtmlElement, childJHtmlElement, childIndex);
                return;
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof JHtmlAmlInsufficientMemoryException)) return;
                throw he;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (this.oCurrentEvent instanceof JHtmlAmlControlMenuOffsetHandlerEvent) {
            JHtmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (JHtmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int childIndex = controlMenuOffsetEvent.getChildIndex();
            int offsetChildIndex = -1;
            try {
                AmlPathInterface parentAmlPath;
                if (this.oCurrentAmlPath != null && this.isControlMenuPresent(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath))) {
                    int numberControlMenus = this.getNumberControlMenus(this.oCurrentAmlPath);
                    offsetChildIndex = childIndex - numberControlMenus;
                }
            }
            catch (Exception ex) {
                offsetChildIndex = 0;
            }
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
            return;
        }
        if (this.oCurrentEvent instanceof JHtmlAmlAddControlMenuElementHandlerEvent) {
            JHtmlElement jhtmlElement;
            JHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = (JHtmlAmlAddControlMenuElementHandlerEvent)this.oCurrentEvent;
            JHtmlElement childJHtmlElement = addControlMenuElementEvent.getJHtmlElement();
            AmlPathInterface parentAmlPath = this.oCurrentAmlPath;
            boolean firstControlMenu = false;
            if (!this.isControlMenuPresent(parentAmlPath)) {
                JHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new JHtmlAmlGetControlMenuParentContainerHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                JHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getJHtmlElement();
                this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                firstControlMenu = true;
            }
            if ((jhtmlElement = this.getControlMenuContainer(parentAmlPath)) instanceof JHtmlElementCollection) {
                int numberElements = jhtmlElement.getNumberElements();
                int i = 0;
                while (i < numberElements) {
                    try {
                        JHtmlElement containerElement = jhtmlElement.jhtmlElementAt(i);
                        this.addCMNMCElement(parentAmlPath, firstControlMenu, containerElement, childJHtmlElement);
                    }
                    catch (JHtmlElementIndexOutOfBoundsException je) {
                        // empty catch block
                    }
                    ++i;
                }
                return;
            }
            this.addCMNMCElement(parentAmlPath, firstControlMenu, jhtmlElement, childJHtmlElement);
            return;
        }
        if (this.oCurrentEvent instanceof JHtmlAmlGetControlMenuParentContainerHandlerEvent) {
            JHtmlAmlGetControlMenuParentContainerHandlerEvent controlMenuParentContainerEvent = (JHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent;
            JHtmlElement jhtmlElement = null;
            try {
                AmlPathInterface currentAmlPath = ((JHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                jhtmlElement = JHtmlAmlElementUtils.getChildContainerJHtmlElement(this.oHandlerManager, parentAmlPath);
            }
            catch (HandlerError he) {
                throw he;
            }
            catch (Exception ex) {
                throw new JHtmlAmlHandlerError(ex);
            }
            controlMenuParentContainerEvent.setJHtmlElement(jhtmlElement);
            return;
        }
        if (!(this.oCurrentEvent instanceof JHtmlAmlIsPersistentHandlerEvent)) return;
        ((JHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent).setPersistent(true);
    }

    private void addCMElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, JHtmlElement jhtmlElement, JHtmlElement childJHtmlElement, int childIndex) throws HandlerError {
        if (!firstControlMenu) {
            JHtmlElement spaceElement = this.composeSpace();
            JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, parentAmlPath, jhtmlElement, spaceElement, childIndex);
            if (childIndex != -1) {
                ++childIndex;
            }
        }
        JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, parentAmlPath, jhtmlElement, childJHtmlElement, childIndex);
    }

    private void addCMNMCElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, JHtmlElement jhtmlElement, JHtmlElement childJHtmlElement) throws HandlerError {
        try {
            if (!firstControlMenu) {
                JHtmlElement spaceElement = this.composeSpace();
                JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, parentAmlPath, jhtmlElement, spaceElement);
            }
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        try {
            JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, parentAmlPath, jhtmlElement, childJHtmlElement);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
    }
}

