/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlElementCollection;
import com.aligo.ihtml.exceptions.IHtmlElementCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementNotFoundException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.ihtml.state.exceptions.IHtmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.ihtml.state.exceptions.IHtmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.ihtml.state.interfaces.IHtmlAmlStateKeeperInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlAmlStateKeeper
implements IHtmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private IHtmlElement oIHtmlChildContainerElement;
    private IHtmlElement oIHtmlElements = new IHtmlElementCollection();
    private IHtmlElement oIHtmlTopElement;
    private IHtmlElement oIHtmlEndElements = new IHtmlElementCollection();
    private int iIHtmlChildPosition = -1;
    private Hashtable oIHtmlAttrTable = new Hashtable();
    private IHtmlElement oIHtmlTextElements = new IHtmlElementCollection();
    private XmlElementInterface oTopStyleElement;
    private StyleIDInterface oStyleID;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setIHtmlChildContainerElement(IHtmlElement ihtmlChildContainerElement) {
        this.oIHtmlChildContainerElement = ihtmlChildContainerElement;
    }

    public IHtmlElement getIHtmlChildContainerElement() {
        return this.oIHtmlChildContainerElement;
    }

    public void setIHtmlChildPosition(int ihtmlChildPosition) {
        this.iIHtmlChildPosition = ihtmlChildPosition;
    }

    public int getIHtmlChildPosition() {
        return this.iIHtmlChildPosition;
    }

    public void setTopIHtmlElement(IHtmlElement ihtmlTopElement) {
        this.oIHtmlTopElement = ihtmlTopElement;
    }

    public IHtmlElement getTopIHtmlElement() {
        return this.oIHtmlTopElement;
    }

    public void addEndIHtmlElement(IHtmlElement ihtmlEndElement) {
        try {
            this.oIHtmlEndElements.addIHtmlElement(ihtmlEndElement);
        }
        catch (IHtmlElementCannotBeAddedException iHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public IHtmlElement getEndIHtmlElements() {
        return this.oIHtmlEndElements;
    }

    public void removeAllEndIHtmlElements() {
        this.oIHtmlEndElements.removeAll();
    }

    public void removeEndIHtmlElement(IHtmlElement ihtmlElement) throws IHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oIHtmlEndElements.removeIHtmlElement(ihtmlElement);
        }
        catch (IHtmlElementNotFoundException we) {
            throw new IHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addIHtmlElement(IHtmlElement ihtmlElement) {
        try {
            this.oIHtmlElements.addIHtmlElement(ihtmlElement);
        }
        catch (IHtmlElementCannotBeAddedException iHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public IHtmlElement getIHtmlElements() {
        return this.oIHtmlElements;
    }

    public void removeAllIHtmlElements() {
        this.oIHtmlElements.removeAll();
    }

    public void removeIHtmlElement(IHtmlElement ihtmlElement) throws IHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oIHtmlElements.removeIHtmlElement(ihtmlElement);
        }
        catch (IHtmlElementNotFoundException we) {
            throw new IHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createIHtmlAttributeVector(IHtmlElement ihtmlElement) {
        Vector attributeVector = new Vector();
        this.oIHtmlAttrTable.put(ihtmlElement, attributeVector);
        return attributeVector;
    }

    public void addIHtmlAttribute(IHtmlElement ihtmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oIHtmlAttrTable.get(ihtmlElement);
        if (attributeVector == null) {
            attributeVector = this.createIHtmlAttributeVector(ihtmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public IHtmlElement getIHtmlAttributeElements() {
        IHtmlElementCollection attributeElements = new IHtmlElementCollection();
        Enumeration keys = this.oIHtmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                IHtmlElement ihtmlElement = (IHtmlElement)keys.nextElement();
                attributeElements.addIHtmlElement(ihtmlElement);
            }
            catch (IHtmlElementCannotBeAddedException iHtmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getIHtmlAttributes(IHtmlElement ihtmlElement) throws IHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oIHtmlAttrTable.get(ihtmlElement);
        if (attributeVector == null) {
            throw new IHtmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllIHtmlAttributes() {
        this.oIHtmlAttrTable.clear();
    }

    public void removeIHtmlAttributes(IHtmlElement ihtmlElement) throws IHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oIHtmlAttrTable.get(ihtmlElement);
        if (attributeVector == null) {
            throw new IHtmlAmlStateKeeperElementNotFoundException();
        }
        this.oIHtmlAttrTable.remove(ihtmlElement);
    }

    public void removeIHtmlAttribute(IHtmlElement ihtmlElement, String ihtmlAttrName) throws IHtmlAmlStateKeeperElementNotFoundException, IHtmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oIHtmlAttrTable.get(ihtmlElement);
        if (attributeVector == null) {
            throw new IHtmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(ihtmlAttrName);
        if (!present) {
            throw new IHtmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addIHtmlText(IHtmlElement ihtmlElement) {
        try {
            this.oIHtmlTextElements.addIHtmlElement(ihtmlElement);
        }
        catch (IHtmlElementCannotBeAddedException iHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public IHtmlElement getIHtmlTextElements() {
        return this.oIHtmlTextElements;
    }

    public void removeAllIHtmlTextElements() {
        this.oIHtmlTextElements.removeAll();
    }

    public void removeIHtmlText(IHtmlElement ihtmlElement) throws IHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oIHtmlTextElements.removeIHtmlElement(ihtmlElement);
        }
        catch (IHtmlElementNotFoundException we) {
            throw new IHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }

    public void setStyleID(StyleIDInterface styleID) {
        this.oStyleID = styleID;
    }

    public StyleIDInterface getStyleID() {
        return this.oStyleID;
    }
}

