/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlPCData;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.errors.IHtmlAmlHandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.ihtml.exceptions.IHtmlAmlInsufficientMemoryException;
import com.aligo.modules.ihtml.handlets.IHtmlAmlStylePathHandlet;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddXmlIHtmlAttributeHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.ihtml.TextUtils;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlAmlTextAttributeHandlet
extends IHtmlAmlStylePathHandlet {
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlStylePathRelevance() {
        long currentIHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            IHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                AmlPathInterface currentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
                IHtmlElement ihtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, currentAmlPath, styleXmlElement);
                String ihtmlName = addAttributeEvent.getIHtmlName();
                if (currentAmlElement instanceof AxmlText && ihtmlElement instanceof IHtmlPCData && ihtmlName.equals("text")) {
                    currentIHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentIHtmlAmlStylePathRelevance;
    }

    public long ihtmlAmlRelevance() {
        long currentIHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentIHtmlAmlRelevance = 30L;
            }
        } else {
            currentIHtmlAmlRelevance = this.oCurrentEvent instanceof IHtmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof IHtmlAmlResetTextStateHandlerEvent ? 20L : super.ihtmlAmlRelevance());
        }
        return currentIHtmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof IHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            IHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            boolean memoryError = false;
            try {
                IHtmlAmlXmlIHtmlElementHandletEvent getIHtmlElementEvent = new IHtmlAmlXmlIHtmlElementHandletEvent("Get", this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEventNow(getIHtmlElementEvent);
                IHtmlElement ihtmlElement = getIHtmlElementEvent.getIHtmlElement();
                String ihtmlName = addAttributeEvent.getIHtmlName();
                String ihtmlValue = addAttributeEvent.getIHtmlValue();
                if (ihtmlValue != null) {
                    String value = "";
                    AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    if (currentAmlElement instanceof AxmlText && ihtmlElement instanceof IHtmlPCData && ihtmlName.equals("text")) {
                        int lastIndex;
                        Integer iLastIndex;
                        String pathString = this.oCurrentAmlPath.getCanonicalPath();
                        Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                        if (strContainer == null) {
                            strContainer = new Vector();
                            String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                            boolean encode = true;
                            if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                encode = false;
                            }
                            TextUtils.prepareOutput(ihtmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                            this.oOutputContainers.put(pathString, strContainer);
                        }
                        if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                            lastIndex = 0;
                            iLastIndex = new Integer(lastIndex);
                            this.oTextIndices.put(pathString, iLastIndex);
                        } else {
                            lastIndex = iLastIndex;
                        }
                        IHtmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new IHtmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                        this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                        long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                        int numberElements = strContainer.size();
                        long memory = 0L;
                        boolean done = false;
                        boolean detach = false;
                        int i = lastIndex;
                        while (i < numberElements && !done) {
                            String element = (String)strContainer.elementAt(i);
                            long elementMemory = element.getBytes().length;
                            if ((memory += elementMemory) > remainingMemory) {
                                done = true;
                                if (i == lastIndex) {
                                    detach = true;
                                }
                                lastIndex = i;
                            } else {
                                value = value + element;
                            }
                            ++i;
                        }
                        this.oDetachFlags.put(pathString, new Boolean(detach));
                        if (done) {
                            this.oTextIndices.put(pathString, new Integer(lastIndex));
                            memoryError = true;
                        } else {
                            this.clearState(this.oCurrentAmlPath);
                        }
                        IHtmlAmlAddXmlIHtmlAttributeHandletEvent addXmlIHtmlAttributeEvent = new IHtmlAmlAddXmlIHtmlAttributeHandletEvent(this.oCurrentAmlPath, ihtmlElement, ihtmlName, value);
                        this.oHandlerManager.postEventNow(addXmlIHtmlAttributeEvent);
                    }
                }
                if (memoryError) {
                    throw new HandlerError(new IHtmlAmlInsufficientMemoryException());
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            HandlerError he = (HandlerError)ex;
            Exception eex = he.getException();
            if (eex instanceof IHtmlAmlInsufficientMemoryException) {
                throw he;
            }
        } else {
            this.oHandlerLogger.logError(ex);
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof IHtmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof IHtmlAmlShouldDetachTextMemoryHandlerEvent) {
                IHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (IHtmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof IHtmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((IHtmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new IHtmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

