/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlA;
import com.aligo.ihtml.exceptions.IHtmlAttributeCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCannotBeAddedException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.errors.IHtmlAmlHandlerError;
import com.aligo.modules.ihtml.handlets.IHtmlAmlStylePathHandlet;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.ihtml.interfaces.IHtmlEventHookPosition;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.ihtml.util.IHtmlEventHookDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.ihtml.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlAmlLinkingHandlet
extends IHtmlAmlStylePathHandlet {
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String PREVIOUS_PAGE = "Previous Page";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HREF = "href";
    private static final String NEXT_PAGE = "Next Page";
    private static final String ID = "id";
    private Hashtable oPageIDs = new Hashtable();
    private Hashtable oIDPages = new Hashtable();
    private Hashtable oIDLinks = new Hashtable();
    private IHtmlElement oIHtmlElement;

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        IHtmlEventHookDescriptor eventHookDescriptor = new IHtmlEventHookDescriptor("IHtmlAmlAddElementHandledHandletEvent", IHtmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlStylePathRelevance() {
        long currentIHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlAddElementHandledHandletEvent) {
            IHtmlAmlAddElementHandledHandletEvent addElementHandledEvent = (IHtmlAmlAddElementHandledHandletEvent)this.oCurrentEvent;
            this.oStyleXmlElement = addElementHandledEvent.getXmlElement();
            this.oCurrentAmlPath = addElementHandledEvent.getAmlPath();
            try {
                this.oIHtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlPage && this.oIHtmlElement instanceof IHtmlA) {
                    currentIHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {}
        } else if (this.oCurrentEvent instanceof IHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            IHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            try {
                IHtmlElement ihtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
                String ihtmlName = addAttributeEvent.getIHtmlName();
                if (ihtmlElement instanceof IHtmlA && ihtmlName.equals("name")) {
                    currentIHtmlAmlStylePathRelevance = 20L;
                } else if (ihtmlElement instanceof IHtmlA && ihtmlName.equals(HREF)) {
                    currentIHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return currentIHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof IHtmlAmlAddElementHandledHandletEvent) {
            try {
                this.addName(this.oIHtmlElement);
                return;
            }
            catch (Exception ex) {
                if (ex instanceof HandlerError) return;
                throw new IHtmlAmlHandlerError(ex);
            }
        } else {
            if (!(this.oCurrentEvent instanceof IHtmlAmlAddXmlAmlAddAttributeHandletEvent)) return;
            IHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            IHtmlElement ihtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
            String ihtmlName = addAttributeEvent.getIHtmlName();
            if (ihtmlElement instanceof IHtmlA && ihtmlName.equals("name")) {
                String ihtmlValue = addAttributeEvent.getIHtmlValue();
                if (ihtmlValue == null) return;
                this.setCardId(ihtmlElement, ihtmlValue);
                String strPath = this.oCurrentAmlPath.toString();
                return;
            } else {
                String ihtmlValue;
                if (!(ihtmlElement instanceof IHtmlA) || !ihtmlName.equals(HREF) || (ihtmlValue = addAttributeEvent.getIHtmlValue()) == null) return;
                String url = ihtmlValue;
                int refIndex = ihtmlValue.indexOf("#");
                if (refIndex != -1) {
                    Vector links;
                    String id = ihtmlValue.substring(refIndex + 1);
                    Vector paths = (Vector)this.oIDPages.get(id);
                    if (paths != null && paths.size() > 0) {
                        url = this.getUrl(this.oCurrentAmlPath, paths, id);
                    }
                    if ((links = (Vector)this.oIDLinks.get(id)) == null) {
                        links = new Vector();
                        this.oIDLinks.put(id, links);
                    }
                    Vector<Object> linkDesc = new Vector<Object>();
                    linkDesc.addElement(this.oCurrentAmlPath);
                    linkDesc.addElement(ihtmlElement);
                    links.addElement(linkDesc);
                } else {
                    url = TextUtils.transformAttr(HREF, url);
                }
                IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, ihtmlElement, HREF, url);
            }
        }
    }

    public String addName(IHtmlElement ihtmlElement) throws IHtmlAttributeCannotBeAddedException, IHtmlElementCannotBeAddedException, HandlerError {
        String name = null;
        if (ihtmlElement instanceof IHtmlA) {
            PageAllocatorInterface pageAllocator = IHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.allocateElement();
            name = pageAllocator.getCurrentElementID();
            this.setCardId(ihtmlElement, name);
        }
        return name;
    }

    private void setCardId(IHtmlElement ihtmlElement, String id) {
        try {
            IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, ihtmlElement, "name", id);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        String strPath = this.oCurrentAmlPath.toString();
        String oldId = (String)this.oPageIDs.get(strPath);
        if (oldId != null) {
            this.oIDPages.remove(oldId);
            PageAllocatorInterface pageAllocator = IHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.changeElement(oldId, id);
        }
        this.oPageIDs.put(strPath, id);
        Vector<AmlPathInterface> pages = (Vector<AmlPathInterface>)this.oIDPages.get(id);
        if (pages == null) {
            pages = new Vector<AmlPathInterface>();
            this.oIDPages.put(id, pages);
        }
        pages.addElement(this.oCurrentAmlPath);
        Vector links = (Vector)this.oIDLinks.get(id);
        if (links != null) {
            int number = links.size();
            int i = 0;
            while (i < number) {
                Vector linkDesc = (Vector)links.elementAt(i);
                AmlPathInterface amlPath = (AmlPathInterface)linkDesc.elementAt(0);
                IHtmlElement linkElement = (IHtmlElement)linkDesc.elementAt(1);
                try {
                    String url = this.getUrl(amlPath, pages, id);
                    IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, amlPath, linkElement, HREF, url);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private String getUrl(AmlPathInterface srcPath, Vector paths, String id) {
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        Enumeration keys = paths.elements();
        boolean isSame = false;
        boolean first = true;
        AmlPathInterface firstPath = null;
        int firstRealm = -1;
        while (keys.hasMoreElements() && !isSame) {
            AmlPathInterface destPath = (AmlPathInterface)keys.nextElement();
            int destRealm = destPath.getRealm();
            if (srcRealm == destRealm) {
                isSame = true;
                continue;
            }
            if (first) {
                firstRealm = destRealm;
                firstPath = destPath;
                first = false;
                continue;
            }
            if (destRealm >= firstRealm) continue;
            firstRealm = destRealm;
            firstPath = destPath;
        }
        if (!isSame && firstPath != null) {
            url = this.getUrl(srcPath, firstPath, id);
        }
        return url;
    }

    private String getUrl(AmlPathInterface srcPath, AmlPathInterface destPath, String id) {
        int destRealm;
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        if (srcRealm != (destRealm = destPath.getRealm())) {
            PageAllocatorInterface pageAllocator = IHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            url = pageAllocator.getElementURL(id);
        }
        return url;
    }
}

