/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlFont;
import com.aligo.ihtml.IHtmlSelect;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.exceptions.IHtmlAmlInsufficientMemoryException;
import com.aligo.modules.ihtml.handlets.IHtmlAmlStylePathHandlet;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class IHtmlAmlChoiceModeHandlet
extends IHtmlAmlStylePathHandlet {
    private static final String MULTIPLE = "multiple";
    private static final String SINGLE = "single";
    private static final String MODE = "mode";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    IHtmlElement ihtmlElement;

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlStylePathRelevance() {
        long currentIHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent) {
            IHtmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlChoice) {
                    XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute;
                    String amlName;
                    this.xmlAttribute = addAttributeEvent.getXmlAttribute();
                    if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (amlName = (xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute).getAmlAttributeName()).equals(MODE)) {
                        this.ihtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, addAttributeEvent.getXmlElement());
                        if (this.ihtmlElement instanceof IHtmlSelect) {
                            currentIHtmlAmlStylePathRelevance = 20L;
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentIHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleStylePathEvent() {
        boolean memoryError;
        block10: {
            if (!(this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent)) return;
            memoryError = false;
            try {
                if (!(this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) || !(this.ihtmlElement instanceof IHtmlSelect)) break block10;
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                this.oHandlerLogger.logDebug("Aml name " + amlAttributeName);
                IHtmlElement ihtmlParentElement = this.ihtmlElement.getIHtmlParentElement();
                int position = -1;
                if (!amlAttributeName.toLowerCase().equals(MODE)) break block10;
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                if (amlAttributeValue.toLowerCase().indexOf(MULTIPLE) != -1) {
                    IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.ihtmlElement, MULTIPLE, TRUE);
                } else if (amlAttributeValue.toLowerCase().indexOf(SINGLE) == -1) {
                    // empty if block
                }
            }
            catch (HandlerError he) {
                AxmlElement amlElement;
                Exception ex = he.getException();
                if (!(ex instanceof IHtmlAmlInsufficientMemoryException)) break block10;
                memoryError = true;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                    memoryError = false;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        if (!memoryError) {
            IHtmlAmlAddAttributeHandledHandletEvent ihtmlAmlAddAttributeHandledHandletEvent = new IHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(ihtmlAmlAddAttributeHandledHandletEvent);
            return;
        }
        try {
            IHtmlAmlElementUtils.removeIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.ihtmlElement.getIHtmlParentElement(), this.ihtmlElement);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        IHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new IHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
        this.oHandlerManager.postEvent(insufficientMemoryEvent);
    }

    public IHtmlElement getIHtmlFontFromParentList(IHtmlElement currentElement) {
        while (currentElement != null) {
            IHtmlElement parentElement = currentElement.getIHtmlParentElement();
            if (parentElement instanceof IHtmlFont) {
                return parentElement;
            }
            currentElement = parentElement;
        }
        return null;
    }
}

