/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml;

import com.aligo.axml.AxmlCheckBox;
import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlForm;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlListItem;
import com.aligo.axml.AxmlOption;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlA;
import com.aligo.ihtml.IHtmlBaseElement;
import com.aligo.ihtml.IHtmlBr;
import com.aligo.ihtml.IHtmlContainer;
import com.aligo.ihtml.IHtmlInput;
import com.aligo.ihtml.IHtmlOption;
import com.aligo.ihtml.IHtmlPCData;
import com.aligo.ihtml.exceptions.IHtmlElementNotFoundException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.IHtmlAmlHandler;
import com.aligo.modules.ihtml.errors.IHtmlAmlHandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCheckLinkFormHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCheckLinkPageHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateElementHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlEndRenderingHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetDynamicURLHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetFormRedirectionInfoHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetLastWorkingPathHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlSetCurrentPageHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlStartNewRealmMemoryHandlerEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlRemoveXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlSetFormUrlHandletEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlAmlMemoryUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.AmlPath;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.FormRedirector;
import java.util.Vector;

public class IHtmlAmlMemoryHandler
extends IHtmlAmlHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    private static final String PAGE = "com.aligo.axml.AxmlPage";
    private static final String FORM = "com.aligo.axml.AxmlForm";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";
    private static final String TABLEROW = "com.aligo.axml.AxmlTableRow";
    private static final String FORM_NAME = "Form";
    private static final String FORM_ACTION = "action";
    private static final String EQUALS = "=";
    private int iRealm = 0;
    private AmlPathInterface oLastWorkingPath = null;
    private static final String MORE = "More";
    private static final String BACK = "Back";
    private static final String HREF = "href";
    private static final String TEXT = "text";
    private static final String SUBMIT_IDENTIFIER = "s";
    private static final String FORMNUM_IDENTIFIER = "agf";
    private static final String IHTML = "IHtml";
    private static final String IHTML_1 = "IHtml-1";
    private AmlPathInterface oLastPagePath = null;
    private AmlPathInterface oCurrentPagePath = null;
    private boolean bPageSet = false;
    private AmlPathInterface oLastFormPath = null;
    private AmlPathInterface oLastFormProcessedPath = null;
    private boolean bIsChoiceFormPresent = false;
    private Vector oLastFormRedirectors = new Vector();
    private String oSecondLastChoiceFormURL = null;
    private boolean bClosingChoiceFormCall = false;
    private boolean bDisablePageBack = false;
    private boolean bDisablePageMore = false;
    private boolean bPFClosingChoiceForm = false;
    private int iFormNumber = 0;

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlInsufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlStartNewRealmMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlSetCurrentPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCheckLinkPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCheckLinkFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlIsCachedChoiceFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetLastWorkingPathHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlRelevance() {
        long currentIHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlInsufficientMemoryHandlerEvent || this.oCurrentEvent instanceof IHtmlAmlStartNewRealmMemoryHandlerEvent || this.oCurrentEvent instanceof IHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlSetCurrentPageHandlerEvent) {
            currentIHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlCheckLinkPageHandlerEvent) {
            currentIHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlCheckLinkFormHandlerEvent) {
            currentIHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlIsCachedChoiceFormHandlerEvent) {
            currentIHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetLastWorkingPathHandlerEvent) {
            currentIHtmlAmlRelevance = 20L;
        }
        return currentIHtmlAmlRelevance;
    }

    public void handleEvent() {
        block33: {
            if (this.oCurrentEvent instanceof IHtmlAmlInsufficientMemoryHandlerEvent) {
                AmlPathInterface workingPath = ((IHtmlAmlInsufficientMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
                boolean sane = false;
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("InSufficient memory...");
                }
                try {
                    AmlPathInterface lastWorkingPath;
                    do {
                        AmlPathInterface parentPath;
                        try {
                            AxmlElement amlElement;
                            if (workingPath != null && this.isTextElement(workingPath) && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && ((amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath)) instanceof AxmlTextArea || amlElement instanceof AxmlInput || amlElement instanceof AxmlCheckBox || amlElement instanceof AxmlOption || amlElement instanceof AxmlListItem)) {
                                IHtmlAmlResetTextStateHandlerEvent resetTextStateEvent = new IHtmlAmlResetTextStateHandlerEvent(workingPath);
                                this.oHandlerManager.postEventNow(resetTextStateEvent);
                            }
                        }
                        catch (HandlerError he) {
                            this.oHandlerLogger.logDebug("20040213.3: AmlMemoryHandler.handlerEvent()+" + he);
                        }
                        try {
                            IHtmlAmlElementUtils.detachFromTree(this.oHandlerManager, workingPath);
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("20040213.5: Now Detaching " + workingPath);
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        sane = IHtmlAmlElementUtils.isDeckSane(this.oHandlerManager);
                        if (sane) {
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("20040213.5: You should not see this");
                            }
                            if ((parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && !IHtmlAmlMemoryUtils.isCacheable(this.oHandlerManager, parentPath)) {
                                sane = IHtmlAmlMemoryUtils.isCacheable(this.oHandlerManager, workingPath);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("Cache sanity: working path " + workingPath + " sanity " + sane);
                                }
                            }
                        }
                        lastWorkingPath = workingPath;
                        try {
                            AmlPathInterface trWorkingPath;
                            workingPath = this.getPreviousPath(lastWorkingPath);
                            if (sane && !this.isTableRowElement(lastWorkingPath) && (trWorkingPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, lastWorkingPath, TABLEROW)) != null) {
                                sane = false;
                            }
                            if (!sane || workingPath == null) continue;
                            int currentNumberElements = workingPath.getNumberAmlPathComponents();
                            int lastNumberElements = lastWorkingPath.getNumberAmlPathComponents();
                            if (lastNumberElements == currentNumberElements) continue;
                            boolean detach = true;
                            if (this.isTextElement(lastWorkingPath)) {
                                IHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = new IHtmlAmlShouldDetachTextMemoryHandlerEvent(lastWorkingPath);
                                this.oHandlerManager.postEventNow(shouldDetachTextMemoryEvent);
                                detach = shouldDetachTextMemoryEvent.isDetach();
                            }
                            if (!detach) continue;
                            sane = false;
                        }
                        catch (HandlerError he) {
                            sane = true;
                        }
                    } while (!sane && workingPath != null);
                    this.checkLinkForm(lastWorkingPath);
                    this.checkLinkPage();
                    boolean end = false;
                    if (workingPath == null) {
                        end = true;
                    } else if (this.oLastWorkingPath != null) {
                        boolean insufficient = false;
                        try {
                            boolean ancestorPersistent = IHtmlAmlMemoryUtils.isAncestorPersistent(this.oHandlerManager, lastWorkingPath);
                            if (ancestorPersistent) {
                                insufficient = true;
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        if (!this.isTextElement(lastWorkingPath)) {
                            String lastCanonicalPath = this.oLastWorkingPath.getCanonicalPath();
                            String currentLastCanonicalPath = lastWorkingPath.getCanonicalPath();
                            if (currentLastCanonicalPath.equals(lastCanonicalPath)) {
                                insufficient = true;
                            }
                        }
                        if (insufficient) {
                            this.oHandlerLogger.logDebug("Page too big for device");
                            end = true;
                        }
                    }
                    if (end) {
                        this.end();
                        break block33;
                    }
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Starting new realm...");
                    }
                    this.startNewRealm(lastWorkingPath);
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Ending...");
                    }
                    this.end();
                }
            } else if (this.oCurrentEvent instanceof IHtmlAmlStartNewRealmMemoryHandlerEvent) {
                this.startNewRealm(((IHtmlAmlStartNewRealmMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
            }
        }
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof IHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            this.detachFromTree(((IHtmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
        } else if (this.oCurrentEvent instanceof IHtmlAmlSetCurrentPageHandlerEvent) {
            IHtmlAmlSetCurrentPageHandlerEvent setCurrentPageEvent = (IHtmlAmlSetCurrentPageHandlerEvent)this.oCurrentEvent;
            this.oCurrentPagePath = setCurrentPageEvent.getAmlPath();
            this.bPageSet = true;
        } else if (this.oCurrentEvent instanceof IHtmlAmlCheckLinkPageHandlerEvent) {
            this.checkLinkPage();
        } else if (this.oCurrentEvent instanceof IHtmlAmlCheckLinkFormHandlerEvent) {
            AmlPathInterface formPath = ((IHtmlAmlCheckLinkFormHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.checkLinkForm(formPath);
        } else if (this.oCurrentEvent instanceof IHtmlAmlIsCachedChoiceFormHandlerEvent) {
            IHtmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = (IHtmlAmlIsCachedChoiceFormHandlerEvent)this.oCurrentEvent;
            AmlPathInterface path = isCachedChoiceFormEvent.getAmlPath();
            boolean cached = this.isCachedChoiceForm(path);
            isCachedChoiceFormEvent.setCached(cached);
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetLastWorkingPathHandlerEvent) {
            ((IHtmlAmlGetLastWorkingPathHandlerEvent)this.oCurrentEvent).setAmlPath(this.oLastWorkingPath);
        }
    }

    private void end() {
        IHtmlAmlEndRenderingHandlerEvent endRenderingEvent = new IHtmlAmlEndRenderingHandlerEvent();
        this.oHandlerManager.postEvent(endRenderingEvent);
    }

    private void startNewRealm(AmlPathInterface lastWorkingPath) {
        this.oLastWorkingPath = lastWorkingPath;
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lastWorkingPath == " + this.oLastWorkingPath.toString());
        }
        ++this.iRealm;
        PageAllocatorInterface pageAllocator = IHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
        pageAllocator.allocatePage();
        AmlPath path = new AmlPath();
        path.setRealm(this.iRealm);
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug(path.toString());
        }
        IHtmlAmlCreateElementHandlerEvent createElementEvent = new IHtmlAmlCreateElementHandlerEvent(path);
        this.oHandlerManager.postEvent(createElementEvent);
    }

    private boolean isTableRowElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean tableRowElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlTableRow) {
            tableRowElement = true;
        }
        return tableRowElement;
    }

    private boolean isTextElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean textElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlText) {
            textElement = true;
        }
        return textElement;
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath) throws HandlerError {
        AmlPathInterface previousPath = null;
        int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        IHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new IHtmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
        this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
        int previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }

    private void detachFromTree(AmlPathInterface currentAmlPath) throws HandlerError {
        block2: {
            IHtmlElement topElement = IHtmlAmlElementUtils.getTopIHtmlElement(this.oHandlerManager, currentAmlPath);
            try {
                IHtmlAmlRemoveXmlIHtmlElementHandletEvent removeXmlIHtmlElementEvent = new IHtmlAmlRemoveXmlIHtmlElementHandletEvent(currentAmlPath, null, topElement);
                this.oHandlerManager.postEventNow(removeXmlIHtmlElementEvent);
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof IHtmlElementNotFoundException) break block2;
                throw he;
            }
        }
    }

    private void checkLinkPage() {
        if (this.bPageSet) {
            this.linkPage();
            this.bPageSet = false;
        }
    }

    private boolean isValidLabel(String label) {
        boolean valid = true;
        if (label == null || label != null && label.equalsIgnoreCase("none")) {
            valid = false;
        }
        return valid;
    }

    private String getNextLabel(AmlPathInterface path) {
        String nextLabel = MORE;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tNextLabel = page.getAxmlAttributeValue("next_label");
            if (this.isValidLabel(tNextLabel)) {
                nextLabel = tNextLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextLabel;
    }

    private String getPrevLabel(AmlPathInterface path) {
        String prevLabel = BACK;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tPrevLabel = page.getAxmlAttributeValue("prev_label");
            if (this.isValidLabel(tPrevLabel)) {
                prevLabel = tPrevLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prevLabel;
    }

    private void linkPage() {
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentPagePath);
            if (amlElement instanceof AxmlPage) {
                if (this.oLastPagePath != null) {
                    AxmlElement amlPage = amlElement;
                    IHtmlElement pageElement = IHtmlAmlElementUtils.getChildContainerIHtmlElement(this.oHandlerManager, this.oCurrentPagePath);
                    if (pageElement != null) {
                        IHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent;
                        IHtmlPCData ihtmlPCData;
                        IHtmlA ihtmlA;
                        String prevLabel;
                        AxmlElement lastPage = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastPagePath);
                        IHtmlElement lastPageElement = IHtmlAmlElementUtils.getChildContainerIHtmlElement(this.oHandlerManager, this.oLastPagePath);
                        PageAllocatorInterface pageAllocator = IHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                        String prevURL = pageAllocator.getPreviousPageURL();
                        String currURL = pageAllocator.getCurrentPageURL();
                        if (!this.bDisablePageBack && this.isValidLabel(prevLabel = amlPage.getAxmlAttributeValue("prev_label"))) {
                            ihtmlA = new IHtmlA();
                            ihtmlA.addIHtmlAttribute(HREF, prevURL);
                            ihtmlPCData = new IHtmlPCData();
                            ihtmlPCData.addIHtmlAttribute(TEXT, prevLabel);
                            ihtmlA.addIHtmlElement(ihtmlPCData);
                            addControlMenuElementEvent = new IHtmlAmlAddControlMenuElementHandlerEvent(this.oCurrentPagePath, ihtmlA);
                            this.oHandlerManager.postEventNow(addControlMenuElementEvent);
                        }
                        if (!this.bDisablePageMore) {
                            String nextLabel = this.getNextLabel(this.oLastPagePath);
                            ihtmlA = new IHtmlA();
                            ihtmlA.addIHtmlAttribute(HREF, currURL);
                            ihtmlPCData = new IHtmlPCData();
                            ihtmlPCData.addIHtmlAttribute(TEXT, nextLabel);
                            ihtmlA.addIHtmlElement(ihtmlPCData);
                            addControlMenuElementEvent = new IHtmlAmlAddControlMenuElementHandlerEvent(this.oLastPagePath, ihtmlA);
                            this.oHandlerManager.postEventNow(addControlMenuElementEvent);
                        }
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("+++++oLastPagePath = " + this.oLastPagePath);
                }
                this.oLastPagePath = this.oCurrentPagePath;
            }
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private boolean isCachedChoiceForm(AmlPathInterface amlPath) {
        boolean cached = false;
        if (amlPath != null && this.oLastWorkingPath != null) {
            try {
                AmlPathInterface lastChoiceFormPath;
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                if (!(amlElement instanceof AxmlChoice) && (lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE)) != null && amlPath.getCanonicalPath().equals(lastChoiceFormPath.getCanonicalPath())) {
                    cached = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cached;
    }

    private void checkLinkForm(AmlPathInterface currentAmlPath) {
        this.bDisablePageBack = false;
        this.bDisablePageMore = false;
        int formNumber = this.iFormNumber;
        try {
            PageAllocatorInterface pageAllocator = IHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            IHtmlAmlGetFormRedirectionInfoHandlerEvent getFormRedirectionInfoEvent = new IHtmlAmlGetFormRedirectionInfoHandlerEvent();
            this.oHandlerManager.postEventNow(getFormRedirectionInfoEvent);
            FormRedirectionInfo formRedirectionInfo = getFormRedirectionInfoEvent.getInfo();
            if (this.bPFClosingChoiceForm) {
                this.bDisablePageMore = true;
                this.bPFClosingChoiceForm = false;
            }
            AmlPathInterface currentFormPath = null;
            if (currentAmlPath != null) {
                currentFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, FORM);
            }
            if (this.bClosingChoiceFormCall && this.oLastFormPath != null) {
                this.oLastFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
            }
            boolean lastFormPathSet = false;
            if (this.oLastFormPath != null) {
                this.bDisablePageMore = true;
                AmlPathInterface lastChoiceFormPath = null;
                if (this.oLastWorkingPath != null) {
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                        if (!(amlElement instanceof AxmlChoice)) {
                            lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE);
                            if (this.bClosingChoiceFormCall) {
                                lastChoiceFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, lastChoiceFormPath);
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("lastChoiceFormPath = " + lastChoiceFormPath);
                }
                boolean isLastChoiceFormPresent = false;
                String choiceName = null;
                String choiceForwardValue = null;
                String choiceBackwardValue = null;
                boolean isSecondLastChoiceFormPresent = false;
                boolean lastChoiceMultiple = false;
                if (lastChoiceFormPath != null) {
                    isLastChoiceFormPresent = true;
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, lastChoiceFormPath);
                        choiceName = amlElement.getAxmlAttributeValue("name");
                        if (this.isChoiceMultiple(amlElement)) {
                            lastChoiceMultiple = true;
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug(" Last Choice Multiple = " + lastChoiceMultiple);
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (isLastChoiceFormPresent && this.oSecondLastChoiceFormURL != null) {
                    isSecondLastChoiceFormPresent = true;
                }
                if (isLastChoiceFormPresent) {
                    IHtmlElement choiceElement;
                    IHtmlInput ihtmlInput;
                    IHtmlBaseElement ihtmlElement;
                    IHtmlPCData ihtmlPCData;
                    this.bDisablePageBack = true;
                    this.bDisablePageMore = true;
                    if (isSecondLastChoiceFormPresent) {
                        try {
                            ihtmlPCData = new IHtmlPCData();
                            choiceBackwardValue = this.getPrevLabel(this.oLastPagePath);
                            ihtmlPCData.addIHtmlAttribute(TEXT, choiceBackwardValue);
                            ihtmlElement = null;
                            if (!lastChoiceMultiple || !this.isIHtml1()) {
                                ihtmlElement = new IHtmlOption();
                                ihtmlElement.addIHtmlAttribute("value", choiceBackwardValue);
                                ihtmlElement.addIHtmlElement(ihtmlPCData);
                            } else {
                                ihtmlElement = new IHtmlContainer();
                                ihtmlInput = new IHtmlInput();
                                ihtmlInput.addIHtmlAttribute("name", choiceName);
                                ihtmlInput.addIHtmlAttribute("type", "checkbox");
                                ihtmlInput.addIHtmlAttribute("value", choiceBackwardValue);
                                ihtmlElement.addIHtmlElement(ihtmlInput);
                                ihtmlElement.addIHtmlElement(ihtmlPCData);
                                ihtmlElement.addIHtmlElement(new IHtmlBr());
                            }
                            choiceElement = IHtmlAmlElementUtils.getChildContainerIHtmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, ihtmlElement);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                    if (!this.bClosingChoiceFormCall) {
                        try {
                            ihtmlPCData = new IHtmlPCData();
                            choiceForwardValue = this.getNextLabel(this.oLastPagePath);
                            ihtmlPCData.addIHtmlAttribute(TEXT, choiceForwardValue);
                            ihtmlElement = null;
                            if (!lastChoiceMultiple || !this.isIHtml1()) {
                                ihtmlElement = new IHtmlOption();
                                ihtmlElement.addIHtmlAttribute("value", choiceForwardValue);
                                ihtmlElement.addIHtmlElement(ihtmlPCData);
                            } else {
                                ihtmlElement = new IHtmlContainer();
                                ihtmlInput = new IHtmlInput();
                                ihtmlInput.addIHtmlAttribute("name", choiceName);
                                ihtmlInput.addIHtmlAttribute("type", "checkbox");
                                ihtmlInput.addIHtmlAttribute("value", choiceForwardValue);
                                ihtmlElement.addIHtmlElement(ihtmlInput);
                                ihtmlElement.addIHtmlElement(ihtmlPCData);
                                ihtmlElement.addIHtmlElement(new IHtmlBr());
                            }
                            choiceElement = IHtmlAmlElementUtils.getChildContainerIHtmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, ihtmlElement);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                }
                String currURL = null;
                boolean originalUrl = true;
                if (!this.bClosingChoiceFormCall) {
                    currURL = pageAllocator.getCurrentPageURL();
                    originalUrl = false;
                } else if (this.isDiffCanonicalPaths(currentFormPath, this.oLastFormPath)) {
                    currURL = this.getFormURL(this.oLastFormPath);
                    ++this.iFormNumber;
                } else {
                    currURL = pageAllocator.getNextPageURL();
                    originalUrl = false;
                }
                String sCurrURL = null;
                if (isLastChoiceFormPresent) {
                    String modifier;
                    IHtmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new IHtmlAmlGetDynamicURLHandlerEvent();
                    this.oHandlerManager.postEventNow(getDynamicURLEvent);
                    String dynamicURL = getDynamicURLEvent.getURL();
                    String dCurrURL = null;
                    String id = null;
                    if (!this.bClosingChoiceFormCall) {
                        IHtmlAmlGetPreviousPageIDHandlerEvent getPreviousPageIDEvent = new IHtmlAmlGetPreviousPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getPreviousPageIDEvent);
                        id = getPreviousPageIDEvent.getID();
                    } else {
                        IHtmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new IHtmlAmlGetCurrentPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                        id = getCurrentPageIDEvent.getID();
                    }
                    dCurrURL = dynamicURL + id;
                    FormRedirector formRedirector = new FormRedirector();
                    formRedirector.setDynamicURL(dCurrURL);
                    if (isSecondLastChoiceFormPresent) {
                        modifier = choiceName + EQUALS + choiceBackwardValue;
                        formRedirector.addModifier(modifier, this.oSecondLastChoiceFormURL);
                    }
                    if (!this.bClosingChoiceFormCall) {
                        modifier = choiceName + EQUALS + choiceForwardValue;
                        formRedirector.addModifier(modifier, currURL);
                    }
                    this.oLastFormRedirectors.addElement(formRedirector);
                    sCurrURL = currURL;
                    currURL = dCurrURL;
                }
                XmlElementInterface topStyleElement = IHtmlAmlElementUtils.getTopStyleElement(this.oHandlerManager, this.oLastFormPath);
                XmlElementInterface formElement = IHtmlAmlElementUtils.getFirstMatchingChild(this.oHandlerManager, topStyleElement, FORM_NAME);
                IHtmlElement ihtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, this.oLastFormPath, formElement);
                try {
                    this.setFormURL(this.oLastFormPath, currURL, formNumber);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                if (isLastChoiceFormPresent) {
                    this.oSecondLastChoiceFormURL = pageAllocator.getPreviousPageURL();
                    currURL = sCurrURL;
                }
                if (isLastChoiceFormPresent) {
                    boolean closeRedirection;
                    AmlPathInterface currentChoiceFormPath = null;
                    if (currentAmlPath != null) {
                        currentChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, CHOICE);
                    }
                    if (closeRedirection = this.isDiffCanonicalPaths(currentChoiceFormPath, lastChoiceFormPath)) {
                        if (!this.bClosingChoiceFormCall) {
                            this.bClosingChoiceFormCall = true;
                            this.checkLinkForm(currentAmlPath);
                            this.oLastFormPath = null;
                            lastFormPathSet = true;
                            this.bPFClosingChoiceForm = true;
                            this.bClosingChoiceFormCall = false;
                        }
                        if (this.bClosingChoiceFormCall) {
                            int numberElements = this.oLastFormRedirectors.size();
                            int i = 0;
                            while (i < numberElements) {
                                FormRedirector formRedirector = (FormRedirector)this.oLastFormRedirectors.elementAt(i);
                                formRedirector.setOriginalURL(currURL);
                                formRedirectionInfo.addFormRedirector(formRedirector);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("formRedirector = " + formRedirector.toString());
                                }
                                ++i;
                            }
                            this.oLastFormRedirectors.clear();
                            this.oSecondLastChoiceFormURL = null;
                        }
                    }
                }
            }
            if (!this.bClosingChoiceFormCall && this.isDiffCanonicalPaths(currentFormPath, this.oLastFormProcessedPath)) {
                AmlPathInterface destPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
                String destURL = this.getFormURL(destPath);
                IHtmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new IHtmlAmlGetDynamicURLHandlerEvent();
                this.oHandlerManager.postEventNow(getDynamicURLEvent);
                String dynamicURL = getDynamicURLEvent.getURL();
                IHtmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new IHtmlAmlGetCurrentPageIDHandlerEvent();
                this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                String id = getCurrentPageIDEvent.getID();
                String dDestURL = dynamicURL + id + SUBMIT_IDENTIFIER;
                FormRedirector formRedirector = new FormRedirector();
                formRedirector.setDynamicURL(dDestURL);
                formRedirector.setOriginalURL(destURL);
                formRedirectionInfo.addFormRedirector(formRedirector);
                this.setFormURL(destPath, dDestURL, formNumber);
                ++this.iFormNumber;
            }
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("*****oLastFormPath = " + this.oLastFormPath);
            }
            if (!lastFormPathSet) {
                this.oLastFormPath = currentFormPath;
            }
            this.oLastFormProcessedPath = currentFormPath;
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private void setFormURL(AmlPathInterface formPath, String formURL, int formNumber) throws HandlerError {
        try {
            AxmlElement formAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
            if (formAmlElement instanceof AxmlForm) {
                String methodType = formAmlElement.getAxmlAttributeValue("method");
                String numURL = "agf=" + formNumber;
                formURL = this.composeURL(formURL, numURL);
                this.setFormNativeURL(formPath, formURL);
            }
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void setFormNativeURL(AmlPathInterface formPath, String formURL) throws HandlerError {
        try {
            IHtmlAmlSetFormUrlHandletEvent setUrlEvent = new IHtmlAmlSetFormUrlHandletEvent(formPath, formURL, false);
            this.oHandlerManager.postEventNow(setUrlEvent);
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
    }

    private String composeURL(String currURL, String paramURL) {
        if (paramURL != null) {
            currURL = currURL.indexOf("?") == -1 ? currURL + "?" : currURL + "&";
            currURL = currURL + paramURL;
        }
        return currURL;
    }

    private String getFormURL(AmlPathInterface amlPath) throws HandlerError {
        String url = null;
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            url = amlElement.getAxmlAttributeValue("url");
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
        return url;
    }

    private void conditionalError(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            throw (HandlerError)ex;
        }
        throw new IHtmlAmlHandlerError(ex);
    }

    private boolean isDiffCanonicalPaths(AmlPathInterface currPath, AmlPathInterface prevPath) {
        boolean different = false;
        if (prevPath != null) {
            if (currPath == null) {
                different = true;
            } else if (!currPath.getCanonicalPath().equals(prevPath.getCanonicalPath())) {
                different = true;
            }
        }
        return different;
    }

    private boolean isChoiceMultiple(AxmlElement amlElement) {
        boolean multiple = false;
        String mode = amlElement.getAxmlAttributeValue("mode");
        if (mode != null && mode.equals("multiple")) {
            multiple = true;
        }
        return multiple;
    }

    private boolean isIHtml1() {
        boolean ihtml1 = false;
        String amlId = this.oUAProfile.getAmlID();
        if (amlId == null || amlId.equals(IHTML_1) || amlId.equals(IHTML)) {
            ihtml1 = true;
        }
        return ihtml1;
    }
}

