/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml;

import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.ihtml.IHtmlAmlPathHandler;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextChildHandledHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextChildHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextChildNoneHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetNextChildIndexHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Vector;

public class IHtmlAmlCreateNextChildHandler
extends IHtmlAmlPathHandler {
    private boolean bPendingMemoryEvent = false;

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCreateNextChildHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlPathRelevance() {
        long currentIHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlCreateNextChildHandlerEvent) {
            currentIHtmlAmlPathRelevance = 20L;
        }
        return currentIHtmlAmlPathRelevance;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof IHtmlAmlCreateNextChildHandlerEvent) {
            boolean none = false;
            AmlPathInterface parentAmlPath = null;
            try {
                parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
                IHtmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = new IHtmlAmlGetNextChildIndexHandlerEvent(this.oCurrentAmlPath, childIndex);
                this.oHandlerManager.postEventNow(getNextChildIndexEvent);
                int nextIndex = getNextChildIndexEvent.getNextIndex();
                int numberChildren = currentAmlElement.getNumberElements();
                if (nextIndex < numberChildren) {
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, nextIndex);
                    if (this.bPendingMemoryEvent) {
                        this.bPendingMemoryEvent = false;
                        IHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new IHtmlAmlInsufficientMemoryHandlerEvent(childAmlPath);
                        this.oHandlerManager.postEvent(insufficientMemoryEvent);
                    } else {
                        IHtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new IHtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                        this.oHandlerManager.postEvent(createNextChildHandledEvent);
                    }
                } else {
                    none = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                none = true;
            }
            if (none) {
                boolean memoryEvent = false;
                Object memoryPath = null;
                try {
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                    if (amlElement instanceof AxmlChoice) {
                        IHtmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = new IHtmlAmlIsCachedChoiceFormHandlerEvent(parentAmlPath);
                        this.oHandlerManager.postEventNow(isCachedChoiceFormEvent);
                        if (isCachedChoiceFormEvent.isCached()) {
                            this.bPendingMemoryEvent = true;
                        }
                    } else if (amlElement instanceof AxmlDocument) {
                        this.bPendingMemoryEvent = false;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                IHtmlAmlCreateNextChildNoneHandlerEvent createNextChildNoneEvent = new IHtmlAmlCreateNextChildNoneHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEvent(createNextChildNoneEvent);
            }
        }
    }
}

