/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlContainer;
import com.aligo.ihtml.IHtmlDiv;
import com.aligo.ihtml.IHtmlElementCollection;
import com.aligo.ihtml.exceptions.IHtmlAttributeCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementIndexOutOfBoundsException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.IHtmlAmlPathHandler;
import com.aligo.modules.ihtml.errors.IHtmlAmlHandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextElementHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetControlMenuParentContainerHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.ihtml.exceptions.IHtmlAmlInsufficientMemoryException;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.ihtml.util.exceptions.IHtmlAmlGetRootElementFailedException;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlAmlControlMenuHandler
extends IHtmlAmlPathHandler {
    private static final String SPACE = "&nbsp;";
    private Hashtable oControlMenuPresentTable = new Hashtable();
    private Hashtable oControlMenuContainerTable = new Hashtable();
    private Hashtable oCMTBNeedCopyTable = new Hashtable();
    private boolean bNoHandleCNEHandlerEvent = false;
    private Hashtable oNumberCMAddedTable = new Hashtable();

    private boolean isControlMenuPresent(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bPresent;
        boolean present = false;
        if (currentAmlPath != null && (bPresent = (Boolean)this.oControlMenuPresentTable.get(pathString = currentAmlPath.toString())) != null) {
            present = bPresent;
        }
        return present;
    }

    private void setControlMenuPresent(AmlPathInterface currentAmlPath, boolean present) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuPresentTable.put(pathString, new Boolean(present));
    }

    private IHtmlElement getControlMenuContainer(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        IHtmlElement ihtmlElement = (IHtmlElement)this.oControlMenuContainerTable.get(pathString);
        return ihtmlElement;
    }

    private void setControlMenuContainer(AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuContainerTable.put(pathString, ihtmlElement);
    }

    private boolean doesCMTBNeedCopy(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bNeedCopy;
        boolean needCopy = false;
        if (currentAmlPath != null && (bNeedCopy = (Boolean)this.oCMTBNeedCopyTable.get(pathString = currentAmlPath.toString())) != null) {
            needCopy = bNeedCopy;
        }
        return needCopy;
    }

    private void setCMTBNeedCopy(AmlPathInterface currentAmlPath, boolean needCopy) {
        String pathString = currentAmlPath.toString();
        this.oCMTBNeedCopyTable.put(pathString, new Boolean(needCopy));
    }

    private int getNumberCMAdded(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        int numAdded = 0;
        Integer inNumAdded = (Integer)this.oNumberCMAddedTable.get(pathString);
        if (inNumAdded != null) {
            numAdded = inNumAdded;
        }
        return numAdded;
    }

    private void incNumberCMAdded(AmlPathInterface currentAmlPath) {
        int numAdded = this.getNumberCMAdded(currentAmlPath);
        String pathString = currentAmlPath.toString();
        this.oNumberCMAddedTable.put(pathString, new Integer(++numAdded));
    }

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddControlMenuElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetControlMenuParentContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCreateNextElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlIsPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlPathRelevance() {
        long currentIHtmlAmlPathRelevance;
        block21: {
            currentIHtmlAmlPathRelevance = 0L;
            if (this.oCurrentEvent instanceof IHtmlAmlAddChildContainerHandlerEvent) {
                try {
                    AmlPathInterface parentAmlPath;
                    AxmlElement parentAmlElement;
                    AmlPathInterface currentAmlPath = ((IHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) instanceof AxmlPage) {
                        currentIHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof IHtmlAmlControlMenuOffsetHandlerEvent) {
                currentIHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof IHtmlAmlAddControlMenuElementHandlerEvent) {
                currentIHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof IHtmlAmlGetControlMenuParentContainerHandlerEvent) {
                currentIHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof IHtmlAmlCreateNextElementHandlerEvent) {
                try {
                    if (!this.bNoHandleCNEHandlerEvent) {
                        int numberCM;
                        AmlPathInterface parentAmlPath;
                        int numCMAdded;
                        IHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (IHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
                        AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                        if (amlElement instanceof AxmlControlMenu && (numCMAdded = this.getNumberCMAdded(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) == (numberCM = this.getTotalControlMenus(parentAmlPath)) && this.doesCMTBNeedCopy(parentAmlPath)) {
                            currentIHtmlAmlPathRelevance = 30L;
                        }
                        break block21;
                    }
                    this.bNoHandleCNEHandlerEvent = false;
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof IHtmlAmlIsPersistentHandlerEvent) {
                try {
                    IHtmlAmlIsPersistentHandlerEvent isPersistentElementEvent = (IHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent;
                    AmlPathInterface currentAmlPath = isPersistentElementEvent.getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu) {
                        currentIHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return currentIHtmlAmlPathRelevance;
    }

    private int getTotalControlMenus(AmlPathInterface parentAmlPath) throws IHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        int numberMenus = 0;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
        int numberChildren = amlElement.getNumberElements();
        int i = 0;
        while (i < numberChildren) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws IHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        AmlPathInterface parentAmlPath;
        AxmlElement amlElement;
        int numberChildren;
        int numberMenus = 0;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        if (childIndex > (numberChildren = (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))).getNumberElements()) - 1) {
            childIndex = numberChildren - 1;
        }
        int i = 0;
        while (i < childIndex) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private void createControlMenuContainer(AmlPathInterface amlPath, IHtmlElement ihtmlElement) throws HandlerError {
        IHtmlElement controlMenuContainer = null;
        boolean oneElement = false;
        if (ihtmlElement instanceof IHtmlElementCollection) {
            int numberElements = ihtmlElement.getNumberElements();
            if (numberElements > 1) {
                controlMenuContainer = new IHtmlElementCollection();
                int i = 0;
                while (i < numberElements) {
                    try {
                        IHtmlElement cmParentContainer = ihtmlElement.ihtmlElementAt(i);
                        IHtmlElement tCMContainer = this.createCMContainerElement(amlPath, cmParentContainer);
                        controlMenuContainer.addIHtmlElement(tCMContainer);
                    }
                    catch (IHtmlElementIndexOutOfBoundsException je) {
                    }
                    catch (IHtmlElementCannotBeAddedException je) {
                        // empty catch block
                    }
                    ++i;
                }
                this.setCMTBNeedCopy(amlPath, true);
            } else {
                try {
                    ihtmlElement = ihtmlElement.ihtmlElementAt(0);
                    oneElement = true;
                }
                catch (IHtmlElementIndexOutOfBoundsException je) {}
            }
        } else {
            oneElement = true;
        }
        if (oneElement) {
            controlMenuContainer = this.createCMContainerElement(amlPath, ihtmlElement);
        }
        this.setControlMenuPresent(amlPath, true);
        this.setControlMenuContainer(amlPath, controlMenuContainer);
    }

    private IHtmlElement createCMContainerElement(AmlPathInterface amlPath, IHtmlElement ihtmlElement) throws HandlerError {
        IHtmlDiv ihtmlDiv = new IHtmlDiv();
        try {
            IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, amlPath, ihtmlElement, ihtmlDiv, 0);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        return ihtmlDiv;
    }

    private IHtmlElement composeSpace() {
        IHtmlContainer ihtmlContainer = new IHtmlContainer();
        try {
            ihtmlContainer.addIHtmlAttribute("text", SPACE);
        }
        catch (IHtmlAttributeCannotBeAddedException iHtmlAttributeCannotBeAddedException) {
            // empty catch block
        }
        return ihtmlContainer;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof IHtmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof IHtmlAmlCreateNextElementHandlerEvent) {
            IHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (IHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
            boolean memoryError = false;
            try {
                int numberElements;
                IHtmlElement cmContainer;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                if (this.doesCMTBNeedCopy(parentAmlPath) && (cmContainer = this.getControlMenuContainer(parentAmlPath)) instanceof IHtmlElementCollection && (numberElements = cmContainer.getNumberElements()) > 1) {
                    IHtmlElement filledECMContainer = cmContainer.ihtmlElementAt(0);
                    int i = 1;
                    while (i < numberElements) {
                        IHtmlElement eCMContainer = cmContainer.ihtmlElementAt(i);
                        int numberChildren = filledECMContainer.getNumberElements();
                        int j = 0;
                        while (j < numberChildren) {
                            IHtmlElement childIHtmlElement = filledECMContainer.ihtmlElementAt(j);
                            IHtmlElement clChildIHtmlElement = childIHtmlElement.cloneIHtmlElement();
                            IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, parentAmlPath, eCMContainer, clChildIHtmlElement);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof IHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.bNoHandleCNEHandlerEvent = true;
            if (memoryError) {
                IHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new IHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                IHtmlAmlCreateNextElementHandlerEvent postAgainCNEEvent = new IHtmlAmlCreateNextElementHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(postAgainCNEEvent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof IHtmlAmlAddChildContainerHandlerEvent) {
            try {
                int numberElements;
                IHtmlAmlAddChildContainerHandlerEvent ihtmlAmlAddChildContainerHandlerEvent = (IHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
                IHtmlElement childIHtmlElement = ihtmlAmlAddChildContainerHandlerEvent.getIHtmlElement();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (!(amlElement instanceof AxmlControlMenu)) return;
                boolean firstControlMenu = false;
                if (!this.isControlMenuPresent(parentAmlPath)) {
                    IHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new IHtmlAmlGetControlMenuParentContainerHandlerEvent(this.oCurrentAmlPath);
                    this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                    IHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getIHtmlElement();
                    this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                    firstControlMenu = true;
                }
                IHtmlElement ihtmlElement = this.getControlMenuContainer(parentAmlPath);
                int childIndex = ihtmlAmlAddChildContainerHandlerEvent.getChildIndex();
                if (ihtmlElement instanceof IHtmlElementCollection && (numberElements = ihtmlElement.getNumberElements()) >= 1) {
                    ihtmlElement = ihtmlElement.ihtmlElementAt(0);
                }
                this.incNumberCMAdded(parentAmlPath);
                this.addCMElement(parentAmlPath, firstControlMenu, ihtmlElement, childIHtmlElement, childIndex);
                return;
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof IHtmlAmlInsufficientMemoryException)) return;
                throw he;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (this.oCurrentEvent instanceof IHtmlAmlControlMenuOffsetHandlerEvent) {
            IHtmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (IHtmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int childIndex = controlMenuOffsetEvent.getChildIndex();
            int offsetChildIndex = -1;
            try {
                AmlPathInterface parentAmlPath;
                if (this.oCurrentAmlPath != null && this.isControlMenuPresent(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath))) {
                    int numberControlMenus = this.getNumberControlMenus(this.oCurrentAmlPath);
                    offsetChildIndex = childIndex - numberControlMenus;
                }
            }
            catch (Exception ex) {
                offsetChildIndex = 0;
            }
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
            return;
        }
        if (this.oCurrentEvent instanceof IHtmlAmlAddControlMenuElementHandlerEvent) {
            IHtmlElement ihtmlElement;
            IHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = (IHtmlAmlAddControlMenuElementHandlerEvent)this.oCurrentEvent;
            IHtmlElement childIHtmlElement = addControlMenuElementEvent.getIHtmlElement();
            AmlPathInterface parentAmlPath = this.oCurrentAmlPath;
            boolean firstControlMenu = false;
            if (!this.isControlMenuPresent(parentAmlPath)) {
                IHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new IHtmlAmlGetControlMenuParentContainerHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                IHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getIHtmlElement();
                this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                firstControlMenu = true;
            }
            if ((ihtmlElement = this.getControlMenuContainer(parentAmlPath)) instanceof IHtmlElementCollection) {
                int numberElements = ihtmlElement.getNumberElements();
                int i = 0;
                while (i < numberElements) {
                    try {
                        IHtmlElement containerElement = ihtmlElement.ihtmlElementAt(i);
                        this.addCMNMCElement(parentAmlPath, firstControlMenu, containerElement, childIHtmlElement);
                    }
                    catch (IHtmlElementIndexOutOfBoundsException je) {
                        // empty catch block
                    }
                    ++i;
                }
                return;
            }
            this.addCMNMCElement(parentAmlPath, firstControlMenu, ihtmlElement, childIHtmlElement);
            return;
        }
        if (this.oCurrentEvent instanceof IHtmlAmlGetControlMenuParentContainerHandlerEvent) {
            IHtmlAmlGetControlMenuParentContainerHandlerEvent controlMenuParentContainerEvent = (IHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent;
            IHtmlElement ihtmlElement = null;
            try {
                AmlPathInterface currentAmlPath = ((IHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                ihtmlElement = IHtmlAmlElementUtils.getChildContainerIHtmlElement(this.oHandlerManager, parentAmlPath);
            }
            catch (HandlerError he) {
                throw he;
            }
            catch (Exception ex) {
                throw new IHtmlAmlHandlerError(ex);
            }
            controlMenuParentContainerEvent.setIHtmlElement(ihtmlElement);
            return;
        }
        if (!(this.oCurrentEvent instanceof IHtmlAmlIsPersistentHandlerEvent)) return;
        ((IHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent).setPersistent(true);
    }

    private void addCMElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, IHtmlElement ihtmlElement, IHtmlElement childIHtmlElement, int childIndex) throws HandlerError {
        if (!firstControlMenu) {
            IHtmlElement spaceElement = this.composeSpace();
            IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, parentAmlPath, ihtmlElement, spaceElement, childIndex);
            if (childIndex != -1) {
                ++childIndex;
            }
        }
        IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, parentAmlPath, ihtmlElement, childIHtmlElement, childIndex);
    }

    private void addCMNMCElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, IHtmlElement ihtmlElement, IHtmlElement childIHtmlElement) throws HandlerError {
        try {
            if (!firstControlMenu) {
                IHtmlElement spaceElement = this.composeSpace();
                IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, parentAmlPath, ihtmlElement, spaceElement);
            }
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        try {
            IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, parentAmlPath, ihtmlElement, childIHtmlElement);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
    }
}

