/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.util;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.events.HtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetRootElementHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetTopHtmlElementStateHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlSetRootElementHandlerEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddXmlHtmlAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddXmlHtmlElementHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlCreateXmlHtmlElementHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlRemoveXmlHtmlAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlRemoveXmlHtmlElementHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlResetXmlHtmlTextHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlSetXmlHtmlTextHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlXmlHtmlElementHandletEvent;
import com.aligo.modules.html.util.exceptions.HtmlAmlGetRootElementFailedException;
import com.aligo.modules.html.util.exceptions.HtmlAmlSetRootElementFailedException;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Hashtable;

public class HtmlAmlElementUtils {
    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            HtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new HtmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws HtmlAmlGetRootElementFailedException {
        try {
            HtmlAmlGetRootElementHandlerEvent getRootElementHandlerEvent = new HtmlAmlGetRootElementHandlerEvent();
            handlerManager.postEventNow(getRootElementHandlerEvent);
            return getRootElementHandlerEvent.getAmlElement();
        }
        catch (HandlerError handlerError) {
            throw new HtmlAmlGetRootElementFailedException(handlerError.toString());
        }
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws HtmlAmlSetRootElementFailedException {
        try {
            HtmlAmlSetRootElementHandlerEvent setRootElementHandlerEvent = new HtmlAmlSetRootElementHandlerEvent(rootAmlElement);
            handlerManager.postEventNow(setRootElementHandlerEvent);
        }
        catch (HandlerError handlerError) {
            throw new HtmlAmlSetRootElementFailedException(handlerError.toString());
        }
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new HtmlAmlIsSufficientMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static HtmlElement getTopHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HtmlAmlGetTopHtmlElementStateHandlerEvent getTopHtmlElementStateEvent = new HtmlAmlGetTopHtmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopHtmlElementStateEvent);
        return getTopHtmlElementStateEvent.getHtmlElement();
    }

    public static void detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HtmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new HtmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        HtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new HtmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static HtmlElement getChildContainerHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HtmlAmlGetHtmlChildContainerStateHandlerEvent getHtmlChildContainerStateEvent = new HtmlAmlGetHtmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getHtmlChildContainerStateEvent);
        return getHtmlChildContainerStateEvent.getHtmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HtmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new HtmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = HtmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static HtmlElement getHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        HtmlAmlXmlHtmlElementHandletEvent xmlHtmlElementEvent = new HtmlAmlXmlHtmlElementHandletEvent("Get", currentAmlPath, xmlElement);
        handlerManager.postEventNow(xmlHtmlElementEvent);
        return xmlHtmlElementEvent.getHtmlElement();
    }

    public static HtmlElement createHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws HandlerError {
        HtmlAmlCreateXmlHtmlElementHandletEvent createXmlHtmlEvent = new HtmlAmlCreateXmlHtmlElementHandletEvent(currentAmlPath, name);
        handlerManager.postEventNow(createXmlHtmlEvent);
        return createXmlHtmlEvent.getHtmlElement();
    }

    public static void addHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement, HtmlElement childHtmlElement) throws HandlerError {
        HtmlAmlElementUtils.addHtmlElement(handlerManager, currentAmlPath, htmlElement, childHtmlElement, -1);
    }

    public static void addHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement, HtmlElement childHtmlElement, int childIndex) throws HandlerError {
        HtmlAmlAddXmlHtmlElementHandletEvent addXmlHtmlElementEvent = new HtmlAmlAddXmlHtmlElementHandletEvent(currentAmlPath, htmlElement, childHtmlElement, childIndex);
        handlerManager.postEventNow(addXmlHtmlElementEvent);
    }

    public static void addHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement, String name, String value) throws HandlerError {
        HtmlAmlAddXmlHtmlAttributeHandletEvent addXmlHtmlAttributeEvent = new HtmlAmlAddXmlHtmlAttributeHandletEvent(currentAmlPath, htmlElement, name, value);
        handlerManager.postEventNow(addXmlHtmlAttributeEvent);
    }

    public static void setHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement, String text) throws HandlerError {
        HtmlAmlSetXmlHtmlTextHandletEvent setXmlHtmlTextEvent = new HtmlAmlSetXmlHtmlTextHandletEvent(currentAmlPath, htmlElement, text);
        handlerManager.postEventNow(setXmlHtmlTextEvent);
    }

    public static void removeHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement, HtmlElement childHtmlElement) throws HandlerError {
        HtmlAmlRemoveXmlHtmlElementHandletEvent removeXmlHtmlElementEvent = new HtmlAmlRemoveXmlHtmlElementHandletEvent(currentAmlPath, htmlElement, childHtmlElement);
        handlerManager.postEventNow(removeXmlHtmlElementEvent);
    }

    public static void removeHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement, String name) throws HandlerError {
        HtmlAmlRemoveXmlHtmlAttributeHandletEvent removeXmlHtmlAttributeEvent = new HtmlAmlRemoveXmlHtmlAttributeHandletEvent(currentAmlPath, htmlElement, name);
        handlerManager.postEventNow(removeXmlHtmlAttributeEvent);
    }

    public static void resetHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HtmlElement htmlElement) throws HandlerError {
        HtmlAmlResetXmlHtmlTextHandletEvent resetXmlHtmlTextEvent = new HtmlAmlResetXmlHtmlTextHandletEvent(currentAmlPath, htmlElement);
        handlerManager.postEventNow(resetXmlHtmlTextEvent);
    }

    public static Hashtable getPresentationElements(HandlerManagerInterface handlerManager) throws HandlerError {
        HtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = new HtmlAmlGetPresentationElementsHandlerEvent();
        handlerManager.postEventNow(getPresentationElementsEvent);
        return getPresentationElementsEvent.getHtmlElements();
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, HtmlElement htmlElement) throws HandlerError {
        boolean present = false;
        Hashtable htmlElements = HtmlAmlElementUtils.getPresentationElements(handlerManager);
        if (htmlElements.get(htmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, HtmlElement htmlElement) throws HandlerError {
        Hashtable htmlElements = HtmlAmlElementUtils.getPresentationElements(handlerManager);
        HtmlAmlElementUtils.addPresentationElement(htmlElements, htmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, HtmlElement htmlElement) throws HandlerError {
        Hashtable htmlElements = HtmlAmlElementUtils.getPresentationElements(handlerManager);
        HtmlAmlElementUtils.removePresentationElement(htmlElements, htmlElement);
    }

    public static void addPresentationElement(Hashtable htmlElements, HtmlElement htmlElement) {
        htmlElements.put(htmlElement, htmlElement);
    }

    public static void removePresentationElement(Hashtable htmlElements, HtmlElement htmlElement) {
        htmlElements.remove(htmlElement);
    }

    public static boolean isPersistent(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HtmlAmlIsPersistentHandlerEvent isPersistentEvent = new HtmlAmlIsPersistentHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isPersistentEvent);
        return isPersistentEvent.isPersistent();
    }
}

