/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.handlets;

import com.aligo.html.exceptions.HtmlTextNotSetException;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.events.HtmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlRemoveHtmlTextStateHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.handlets.HtmlAmlElementPathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlResetHtmlTextHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlResetXmlHtmlTextHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import java.util.Vector;

public class HtmlAmlResetXmlHtmlTextHandlet
extends HtmlAmlElementPathHandlet {
    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlResetXmlHtmlTextHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlElementPathRelevance() {
        long currentHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlResetXmlHtmlTextHandletEvent) {
            HtmlAmlResetXmlHtmlTextHandletEvent setHtmlTextEvent = (HtmlAmlResetXmlHtmlTextHandletEvent)this.oCurrentEvent;
            currentHtmlAmlRelevance = 20L;
        }
        return currentHtmlAmlRelevance;
    }

    public void handleElementPathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HtmlAmlResetXmlHtmlTextHandletEvent) {
            long removeMemory = 0L;
            if (HtmlAmlElementUtils.isPresentationElement(this.oHandlerManager, this.oHtmlElement)) {
                try {
                    String contents = this.oHtmlElement.getText();
                    removeMemory += (long)contents.getBytes().length;
                }
                catch (HtmlTextNotSetException je) {
                    // empty catch block
                }
            }
            HtmlAmlResetHtmlTextHandletEvent resetHtmlTextEvent = new HtmlAmlResetHtmlTextHandletEvent(this.oHtmlElement);
            this.oHandlerManager.postEventNow(resetHtmlTextEvent);
            HtmlAmlRemoveHtmlTextStateHandlerEvent removeHtmlTextStateEvent = new HtmlAmlRemoveHtmlTextStateHandlerEvent(this.oCurrentAmlPath, this.oHtmlElement);
            this.oHandlerManager.postEventNow(removeHtmlTextStateEvent);
            if (removeMemory != 0L) {
                HtmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = new HtmlAmlRemoveCurrentMemoryHandlerEvent(this.oCurrentAmlPath, removeMemory);
                this.oHandlerManager.postEventNow(removeCurrentMemoryEvent);
            }
            if (!HtmlAmlElementUtils.isSufficientMemory(this.oHandlerManager, this.oCurrentAmlPath)) {
                throw new HandlerError(new HtmlAmlInsufficientMemoryException());
            }
        }
    }
}

