/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlOl;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.events.HtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.handlets.HtmlAmlStylePathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlXmlHtmlElementHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class HtmlAmlOrderedListHandlet
extends HtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    HtmlElement htmlElement;
    private static final String TYPE = "type";
    private static final String NUMERIC = "numeric";
    private static final String UPPERCASE_ROMAN = "uppercase_roman";
    private static final String LOWERCASE_ROMAN = "lowercase_roman";
    private static final String UPPERCASE_ALPHA = "uppercase_alpha";
    private static final String LOWERCASE_ALPHA = "lowercase_alpha";
    private static final String NUMERIC_VALUE = "1";
    private static final String UPPERCASE_ROMAN_VALUE = "I";
    private static final String LOWERCASE_ROMAN_VALUE = "i";
    private static final String UPPERCASE_ALPHA_VALUE = "A";
    private static final String LOWERCASE_ALPHA_VALUE = "a";

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlStylePathRelevance() {
        long currentHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent) {
            HtmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                HtmlAmlXmlHtmlElementHandletEvent getHtmlElementEvent = new HtmlAmlXmlHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getHtmlElementEvent);
                this.oCurrentEvent = event;
                this.htmlElement = getHtmlElementEvent.getHtmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.htmlElement instanceof HtmlOl) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(TYPE)) {
                        currentHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.htmlElement instanceof HtmlOl) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    HtmlElement htmlParentElement = this.htmlElement.getHtmlParentElement();
                    int position = -1;
                    if (amlAttributeName.toLowerCase().equals(TYPE)) {
                        AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                        String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                        if (amlAttributeValue.toLowerCase().indexOf(NUMERIC) != -1) {
                            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement, amlAttributeName, NUMERIC_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(UPPERCASE_ROMAN) != -1) {
                            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement, amlAttributeName, UPPERCASE_ROMAN_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(LOWERCASE_ROMAN) != -1) {
                            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement, amlAttributeName, LOWERCASE_ROMAN_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(UPPERCASE_ALPHA) != -1) {
                            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement, amlAttributeName, UPPERCASE_ALPHA_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(LOWERCASE_ALPHA) != -1) {
                            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement, amlAttributeName, LOWERCASE_ALPHA_VALUE);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof HtmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    HtmlAmlElementUtils.removeHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement.getHtmlParentElement(), this.htmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                HtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                HtmlAmlAddAttributeHandledHandletEvent htmlAmlAddAttributeHandledHandletEvent = new HtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(htmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

