/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlA;
import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.errors.HtmlAmlHandlerError;
import com.aligo.modules.html.handlets.HtmlAmlStylePathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.html.interfaces.HtmlEventHookPosition;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.html.util.HtmlEventHookDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.html.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlAmlLinkingHandlet
extends HtmlAmlStylePathHandlet {
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String PREVIOUS_PAGE = "Previous Page";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HREF = "href";
    private static final String NEXT_PAGE = "Next Page";
    private static final String ID = "id";
    private Hashtable oPageIDs = new Hashtable();
    private Hashtable oIDPages = new Hashtable();
    private Hashtable oIDLinks = new Hashtable();
    private HtmlElement oHtmlElement;

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        HtmlEventHookDescriptor eventHookDescriptor = new HtmlEventHookDescriptor("HtmlAmlAddElementHandledHandletEvent", HtmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlStylePathRelevance() {
        long currentHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlAddElementHandledHandletEvent) {
            HtmlAmlAddElementHandledHandletEvent addElementHandledEvent = (HtmlAmlAddElementHandledHandletEvent)this.oCurrentEvent;
            this.oStyleXmlElement = addElementHandledEvent.getXmlElement();
            this.oCurrentAmlPath = addElementHandledEvent.getAmlPath();
            try {
                this.oHtmlElement = HtmlAmlElementUtils.getHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlPage && this.oHtmlElement instanceof HtmlA) {
                    currentHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {}
        } else if (this.oCurrentEvent instanceof HtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            HtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            try {
                HtmlElement htmlElement = HtmlAmlElementUtils.getHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
                String htmlName = addAttributeEvent.getHtmlName();
                if (htmlElement instanceof HtmlA && htmlName.equals("name")) {
                    currentHtmlAmlStylePathRelevance = 20L;
                } else if (htmlElement instanceof HtmlA && htmlName.equals(HREF)) {
                    currentHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return currentHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HtmlAmlAddElementHandledHandletEvent) {
            try {
                this.addName(this.oHtmlElement);
                return;
            }
            catch (Exception ex) {
                if (ex instanceof HandlerError) return;
                throw new HtmlAmlHandlerError(ex);
            }
        } else {
            if (!(this.oCurrentEvent instanceof HtmlAmlAddXmlAmlAddAttributeHandletEvent)) return;
            HtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            HtmlElement htmlElement = HtmlAmlElementUtils.getHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
            String htmlName = addAttributeEvent.getHtmlName();
            if (htmlElement instanceof HtmlA && htmlName.equals("name")) {
                String htmlValue = addAttributeEvent.getHtmlValue();
                if (htmlValue == null) return;
                this.setCardId(htmlElement, htmlValue);
                String strPath = this.oCurrentAmlPath.toString();
                return;
            } else {
                String htmlValue;
                if (!(htmlElement instanceof HtmlA) || !htmlName.equals(HREF) || (htmlValue = addAttributeEvent.getHtmlValue()) == null) return;
                String url = htmlValue;
                int refIndex = htmlValue.indexOf("#");
                if (refIndex != -1) {
                    Vector links;
                    String id = htmlValue.substring(refIndex + 1);
                    Vector paths = (Vector)this.oIDPages.get(id);
                    if (paths != null && paths.size() > 0) {
                        url = this.getUrl(this.oCurrentAmlPath, paths, id);
                    }
                    if ((links = (Vector)this.oIDLinks.get(id)) == null) {
                        links = new Vector();
                        this.oIDLinks.put(id, links);
                    }
                    Vector<Object> linkDesc = new Vector<Object>();
                    linkDesc.addElement(this.oCurrentAmlPath);
                    linkDesc.addElement(htmlElement);
                    links.addElement(linkDesc);
                } else {
                    url = TextUtils.transformAttr(HREF, url);
                }
                HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, htmlElement, HREF, url);
            }
        }
    }

    public String addName(HtmlElement htmlElement) throws HtmlAttributeCannotBeAddedException, HtmlElementCannotBeAddedException, HandlerError {
        String name = null;
        if (htmlElement instanceof HtmlA) {
            PageAllocatorInterface pageAllocator = HtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.allocateElement();
            name = pageAllocator.getCurrentElementID();
            this.setCardId(htmlElement, name);
        }
        return name;
    }

    private void setCardId(HtmlElement htmlElement, String id) {
        try {
            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, htmlElement, "name", id);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        String strPath = this.oCurrentAmlPath.toString();
        String oldId = (String)this.oPageIDs.get(strPath);
        if (oldId != null) {
            this.oIDPages.remove(oldId);
            PageAllocatorInterface pageAllocator = HtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.changeElement(oldId, id);
        }
        this.oPageIDs.put(strPath, id);
        Vector<AmlPathInterface> pages = (Vector<AmlPathInterface>)this.oIDPages.get(id);
        if (pages == null) {
            pages = new Vector<AmlPathInterface>();
            this.oIDPages.put(id, pages);
        }
        pages.addElement(this.oCurrentAmlPath);
        Vector links = (Vector)this.oIDLinks.get(id);
        if (links != null) {
            int number = links.size();
            int i = 0;
            while (i < number) {
                Vector linkDesc = (Vector)links.elementAt(i);
                AmlPathInterface amlPath = (AmlPathInterface)linkDesc.elementAt(0);
                HtmlElement linkElement = (HtmlElement)linkDesc.elementAt(1);
                try {
                    String url = this.getUrl(amlPath, pages, id);
                    HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, amlPath, linkElement, HREF, url);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private String getUrl(AmlPathInterface srcPath, Vector paths, String id) {
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        Enumeration keys = paths.elements();
        boolean isSame = false;
        boolean first = true;
        AmlPathInterface firstPath = null;
        int firstRealm = -1;
        while (keys.hasMoreElements() && !isSame) {
            AmlPathInterface destPath = (AmlPathInterface)keys.nextElement();
            int destRealm = destPath.getRealm();
            if (srcRealm == destRealm) {
                isSame = true;
                continue;
            }
            if (first) {
                firstRealm = destRealm;
                firstPath = destPath;
                first = false;
                continue;
            }
            if (destRealm >= firstRealm) continue;
            firstRealm = destRealm;
            firstPath = destPath;
        }
        if (!isSame && firstPath != null) {
            url = this.getUrl(srcPath, firstPath, id);
        }
        return url;
    }

    private String getUrl(AmlPathInterface srcPath, AmlPathInterface destPath, String id) {
        int destRealm;
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        if (srcRealm != (destRealm = destPath.getRealm())) {
            PageAllocatorInterface pageAllocator = HtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            url = pageAllocator.getElementURL(id);
        }
        return url;
    }
}

