/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlTable;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.html.amlhandlets.events.HtmlAmlCreateTableHandledHandletEvent;
import com.aligo.modules.html.amlhandlets.events.HtmlAmlCreateTableHandletEvent;
import com.aligo.modules.html.events.HtmlAmlCreateNextChildHandledHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlCreateNextChildHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlCreateNextChildNoneHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlPathHandlerEvent;
import com.aligo.modules.html.handlets.HtmlAmlPathHandlet;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlAmlCreateTableHandlet
extends HtmlAmlPathHandlet {
    private static final String REGULAR_ROWS = "regular";
    private static final String PERMANENT_ROWS = "permanent";
    private static final String REGULAR_ROW_INDEX = "rindex";
    private static final String PERMANENT_ROW_INDEX = "pindex";
    Hashtable tableState = new Hashtable();

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlCreateTableHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlCreateNextChildHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlPathRelevance() {
        long currentHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlCreateTableHandletEvent) {
            currentHtmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HtmlAmlCreateNextChildHandlerEvent) {
            try {
                HtmlAmlPathHandlerEvent pathHandlerEvent = (HtmlAmlPathHandlerEvent)this.oCurrentEvent;
                this.oCurrentAmlPath = pathHandlerEvent.getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                int childPathIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                boolean postHighRelevance = false;
                if (parentAmlElement instanceof AxmlTable) {
                    if (childPathIndex == -1) {
                        postHighRelevance = true;
                    } else {
                        AxmlElement childAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                        if (childAmlElement instanceof AxmlTableRow) {
                            postHighRelevance = true;
                        }
                    }
                }
                if (postHighRelevance) {
                    currentHtmlAmlPathRelevance = 30L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentHtmlAmlPathRelevance;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof HtmlAmlCreateTableHandletEvent) {
            try {
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (axmlElement instanceof AxmlTable) {
                    if (this.oCurrentAmlPath == null) {
                        this.oHandlerLogger.logDebug("!!!CurrentAmlPath is null....");
                    }
                    int numElements = axmlElement.getNumberElements();
                    Hashtable<String, Serializable> tablePathState = new Hashtable<String, Serializable>();
                    Vector<Integer> permanentRows = new Vector<Integer>();
                    Vector<Integer> regularRows = new Vector<Integer>();
                    int i = 0;
                    while (i < numElements) {
                        AxmlElement child = axmlElement.axmlElementAt(i);
                        if (child instanceof AxmlTableRow) {
                            String headerAttr = child.getAxmlAttributeValue("header");
                            if (headerAttr != null && headerAttr.equals("true")) {
                                permanentRows.add(0, new Integer(i));
                            } else {
                                String persistAttr = child.getAxmlAttributeValue("persist");
                                if (persistAttr != null && persistAttr.equals("true")) {
                                    permanentRows.add(new Integer(i));
                                } else {
                                    regularRows.add(new Integer(i));
                                }
                            }
                        }
                        ++i;
                    }
                    tablePathState.put(PERMANENT_ROWS, permanentRows);
                    tablePathState.put(REGULAR_ROWS, regularRows);
                    tablePathState.put(REGULAR_ROW_INDEX, new Integer(0));
                    tablePathState.put(PERMANENT_ROW_INDEX, new Integer(0));
                    this.tableState.put(this.oCurrentAmlPath.toString(), tablePathState);
                }
                HtmlAmlCreateTableHandledHandletEvent event = new HtmlAmlCreateTableHandledHandletEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(event);
            }
            catch (Exception ex) {
                this.oHandlerLogger.logDebug("Exception....." + ex.getMessage());
            }
        } else if (this.oCurrentEvent instanceof HtmlAmlCreateNextChildHandlerEvent) {
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            Hashtable tablePathState = (Hashtable)this.tableState.get(parentAmlPath.toString());
            Vector permanentRows = (Vector)tablePathState.get(PERMANENT_ROWS);
            Vector regularRows = (Vector)tablePathState.get(REGULAR_ROWS);
            int permIndex = (Integer)tablePathState.get(PERMANENT_ROW_INDEX);
            int regIndex = (Integer)tablePathState.get(REGULAR_ROW_INDEX);
            if (regIndex == 0 && permIndex < permanentRows.size()) {
                AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, (Integer)permanentRows.elementAt(permIndex));
                tablePathState.put(PERMANENT_ROW_INDEX, new Integer(++permIndex));
                HtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new HtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                this.oHandlerManager.postEvent(createNextChildHandledEvent);
            } else if (regIndex < regularRows.size()) {
                AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, (Integer)regularRows.elementAt(regIndex));
                tablePathState.put(REGULAR_ROW_INDEX, new Integer(++regIndex));
                HtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new HtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                this.oHandlerManager.postEvent(createNextChildHandledEvent);
            } else {
                HtmlAmlCreateNextChildNoneHandlerEvent createNextChildNoneEvent = new HtmlAmlCreateNextChildNoneHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEvent(createNextChildNoneEvent);
            }
        }
    }
}

