/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.util;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.events.HdmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetHdmlChildContainerStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetRootElementHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetTopHdmlElementStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlSetRootElementHandlerEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddXmlHdmlAttributeHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlCreateXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlRemoveXmlHdmlAttributeHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlRemoveXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlResetXmlHdmlTextHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlSetXmlHdmlTextHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.exceptions.HdmlAmlGetRootElementFailedException;
import com.aligo.modules.hdml.util.exceptions.HdmlAmlSetRootElementFailedException;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Hashtable;

public class HdmlAmlElementUtils {
    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            HdmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new HdmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws HdmlAmlGetRootElementFailedException {
        try {
            HdmlAmlGetRootElementHandlerEvent getRootElementHandlerEvent = new HdmlAmlGetRootElementHandlerEvent();
            handlerManager.postEventNow(getRootElementHandlerEvent);
            return getRootElementHandlerEvent.getAmlElement();
        }
        catch (HandlerError handlerError) {
            throw new HdmlAmlGetRootElementFailedException(handlerError.toString());
        }
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws HdmlAmlSetRootElementFailedException {
        try {
            HdmlAmlSetRootElementHandlerEvent setRootElementHandlerEvent = new HdmlAmlSetRootElementHandlerEvent(rootAmlElement);
            handlerManager.postEventNow(setRootElementHandlerEvent);
        }
        catch (HandlerError handlerError) {
            throw new HdmlAmlSetRootElementFailedException(handlerError.toString());
        }
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) throws HandlerError {
        HdmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new HdmlAmlIsSufficientMemoryHandlerEvent(amlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static HdmlElement getTopHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HdmlAmlGetTopHdmlElementStateHandlerEvent getTopHdmlElementStateEvent = new HdmlAmlGetTopHdmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopHdmlElementStateEvent);
        return getTopHdmlElementStateEvent.getHdmlElement();
    }

    public static AmlPathInterface detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HdmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new HdmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
        return detachFromTreeEvent.getRestartAmlPath();
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        HdmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new HdmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static HdmlElement getChildContainerHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HdmlAmlGetHdmlChildContainerStateHandlerEvent getHdmlChildContainerStateEvent = new HdmlAmlGetHdmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getHdmlChildContainerStateEvent);
        return getHdmlChildContainerStateEvent.getHdmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        HdmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new HdmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = HdmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static HdmlElement getHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        HdmlAmlXmlHdmlElementHandletEvent xmlHdmlElementEvent = new HdmlAmlXmlHdmlElementHandletEvent("Get", currentAmlPath, xmlElement);
        handlerManager.postEventNow(xmlHdmlElementEvent);
        return xmlHdmlElementEvent.getHdmlElement();
    }

    public static HdmlElement createHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws HandlerError {
        HdmlAmlCreateXmlHdmlElementHandletEvent createXmlHdmlEvent = new HdmlAmlCreateXmlHdmlElementHandletEvent(currentAmlPath, name);
        handlerManager.postEventNow(createXmlHdmlEvent);
        return createXmlHdmlEvent.getHdmlElement();
    }

    public static void addHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement, HdmlElement childHdmlElement) throws HandlerError {
        HdmlAmlElementUtils.addHdmlElement(handlerManager, currentAmlPath, hdmlElement, childHdmlElement, -1);
    }

    public static void addHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement, HdmlElement childHdmlElement, int childIndex) throws HandlerError {
        HdmlAmlAddXmlHdmlElementHandletEvent addXmlHdmlElementEvent = new HdmlAmlAddXmlHdmlElementHandletEvent(currentAmlPath, hdmlElement, childHdmlElement, childIndex);
        handlerManager.postEventNow(addXmlHdmlElementEvent);
    }

    public static void addHdmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement, String name, String value) throws HandlerError {
        HdmlAmlAddXmlHdmlAttributeHandletEvent addXmlHdmlAttributeEvent = new HdmlAmlAddXmlHdmlAttributeHandletEvent(currentAmlPath, hdmlElement, name, value);
        handlerManager.postEventNow(addXmlHdmlAttributeEvent);
    }

    public static void setHdmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement, String text) throws HandlerError {
        HdmlAmlSetXmlHdmlTextHandletEvent setXmlHdmlTextEvent = new HdmlAmlSetXmlHdmlTextHandletEvent(currentAmlPath, hdmlElement, text);
        handlerManager.postEventNow(setXmlHdmlTextEvent);
    }

    public static void removeHdmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement, HdmlElement childHdmlElement) throws HandlerError {
        HdmlAmlRemoveXmlHdmlElementHandletEvent removeXmlHdmlElementEvent = new HdmlAmlRemoveXmlHdmlElementHandletEvent(currentAmlPath, hdmlElement, childHdmlElement);
        handlerManager.postEventNow(removeXmlHdmlElementEvent);
    }

    public static void removeHdmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement, String name) throws HandlerError {
        HdmlAmlRemoveXmlHdmlAttributeHandletEvent removeXmlHdmlAttributeEvent = new HdmlAmlRemoveXmlHdmlAttributeHandletEvent(currentAmlPath, hdmlElement, name);
        handlerManager.postEventNow(removeXmlHdmlAttributeEvent);
    }

    public static void resetHdmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, HdmlElement hdmlElement) throws HandlerError {
        HdmlAmlResetXmlHdmlTextHandletEvent resetXmlHdmlTextEvent = new HdmlAmlResetXmlHdmlTextHandletEvent(currentAmlPath, hdmlElement);
        handlerManager.postEventNow(resetXmlHdmlTextEvent);
    }

    public static Hashtable getPresentationElements(HandlerManagerInterface handlerManager) throws HandlerError {
        HdmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = new HdmlAmlGetPresentationElementsHandlerEvent();
        handlerManager.postEventNow(getPresentationElementsEvent);
        return getPresentationElementsEvent.getHdmlElements();
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, HdmlElement hdmlElement) throws HandlerError {
        boolean present = false;
        Hashtable hdmlElements = HdmlAmlElementUtils.getPresentationElements(handlerManager);
        if (hdmlElements.get(hdmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, HdmlElement hdmlElement) throws HandlerError {
        Hashtable hdmlElements = HdmlAmlElementUtils.getPresentationElements(handlerManager);
        HdmlAmlElementUtils.addPresentationElement(hdmlElements, hdmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, HdmlElement hdmlElement) throws HandlerError {
        Hashtable hdmlElements = HdmlAmlElementUtils.getPresentationElements(handlerManager);
        HdmlAmlElementUtils.removePresentationElement(hdmlElements, hdmlElement);
    }

    public static void addPresentationElement(Hashtable hdmlElements, HdmlElement hdmlElement) {
        hdmlElements.put(hdmlElement, hdmlElement);
    }

    public static void removePresentationElement(Hashtable hdmlElements, HdmlElement hdmlElement) {
        hdmlElements.remove(hdmlElement);
    }
}

