/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.HdmlElementCollection;
import com.aligo.hdml.exceptions.HdmlElementCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementNotFoundException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.hdml.state.exceptions.HdmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.hdml.state.exceptions.HdmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.hdml.state.interfaces.HdmlAmlStateKeeperInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HdmlAmlStateKeeper
implements HdmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private HdmlElement oHdmlChildContainerElement;
    private HdmlElement oHdmlElements = new HdmlElementCollection();
    private HdmlElement oHdmlTopElement;
    private HdmlElement oHdmlEndElements = new HdmlElementCollection();
    private int iHdmlChildPosition = -1;
    private Hashtable oHdmlAttrTable = new Hashtable();
    private HdmlElement oHdmlTextElements = new HdmlElementCollection();
    private XmlElementInterface oTopStyleElement;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setHdmlChildContainerElement(HdmlElement hdmlChildContainerElement) {
        this.oHdmlChildContainerElement = hdmlChildContainerElement;
    }

    public HdmlElement getHdmlChildContainerElement() {
        return this.oHdmlChildContainerElement;
    }

    public void setHdmlChildPosition(int hdmlChildPosition) {
        this.iHdmlChildPosition = hdmlChildPosition;
    }

    public int getHdmlChildPosition() {
        return this.iHdmlChildPosition;
    }

    public void setTopHdmlElement(HdmlElement hdmlTopElement) {
        this.oHdmlTopElement = hdmlTopElement;
    }

    public HdmlElement getTopHdmlElement() {
        return this.oHdmlTopElement;
    }

    public void addEndHdmlElement(HdmlElement hdmlEndElement) {
        try {
            this.oHdmlEndElements.addHdmlElement(hdmlEndElement);
        }
        catch (HdmlElementCannotBeAddedException hdmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public HdmlElement getEndHdmlElements() {
        return this.oHdmlEndElements;
    }

    public void removeAllEndHdmlElements() {
        this.oHdmlEndElements.removeAll();
    }

    public void removeEndHdmlElement(HdmlElement hdmlElement) throws HdmlAmlStateKeeperElementNotFoundException {
        try {
            this.oHdmlEndElements.removeHdmlElement(hdmlElement);
        }
        catch (HdmlElementNotFoundException we) {
            throw new HdmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addHdmlElement(HdmlElement hdmlElement) {
        try {
            this.oHdmlElements.addHdmlElement(hdmlElement);
        }
        catch (HdmlElementCannotBeAddedException hdmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public HdmlElement getHdmlElements() {
        return this.oHdmlElements;
    }

    public void removeAllHdmlElements() {
        this.oHdmlElements.removeAll();
    }

    public void removeHdmlElement(HdmlElement hdmlElement) throws HdmlAmlStateKeeperElementNotFoundException {
        try {
            this.oHdmlElements.removeHdmlElement(hdmlElement);
        }
        catch (HdmlElementNotFoundException we) {
            throw new HdmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createHdmlAttributeVector(HdmlElement hdmlElement) {
        Vector attributeVector = new Vector();
        this.oHdmlAttrTable.put(hdmlElement, attributeVector);
        return attributeVector;
    }

    public void addHdmlAttribute(HdmlElement hdmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oHdmlAttrTable.get(hdmlElement);
        if (attributeVector == null) {
            attributeVector = this.createHdmlAttributeVector(hdmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public HdmlElement getHdmlAttributeElements() {
        HdmlElementCollection attributeElements = new HdmlElementCollection();
        Enumeration keys = this.oHdmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                HdmlElement hdmlElement = (HdmlElement)keys.nextElement();
                attributeElements.addHdmlElement(hdmlElement);
            }
            catch (HdmlElementCannotBeAddedException hdmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getHdmlAttributes(HdmlElement hdmlElement) throws HdmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oHdmlAttrTable.get(hdmlElement);
        if (attributeVector == null) {
            throw new HdmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllHdmlAttributes() {
        this.oHdmlAttrTable.clear();
    }

    public void removeHdmlAttributes(HdmlElement hdmlElement) throws HdmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oHdmlAttrTable.get(hdmlElement);
        if (attributeVector == null) {
            throw new HdmlAmlStateKeeperElementNotFoundException();
        }
        this.oHdmlAttrTable.remove(hdmlElement);
    }

    public void removeHdmlAttribute(HdmlElement hdmlElement, String hdmlAttrName) throws HdmlAmlStateKeeperElementNotFoundException, HdmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oHdmlAttrTable.get(hdmlElement);
        if (attributeVector == null) {
            throw new HdmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(hdmlAttrName);
        if (!present) {
            throw new HdmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addHdmlText(HdmlElement hdmlElement) {
        try {
            this.oHdmlTextElements.addHdmlElement(hdmlElement);
        }
        catch (HdmlElementCannotBeAddedException hdmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public HdmlElement getHdmlTextElements() {
        return this.oHdmlTextElements;
    }

    public void removeAllHdmlTextElements() {
        this.oHdmlTextElements.removeAll();
    }

    public void removeHdmlText(HdmlElement hdmlElement) throws HdmlAmlStateKeeperElementNotFoundException {
        try {
            this.oHdmlTextElements.removeHdmlElement(hdmlElement);
        }
        catch (HdmlElementNotFoundException we) {
            throw new HdmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }
}

