/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.HdmlContainer;
import com.aligo.hdml.HdmlDisplay;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.amlhandlets.events.HdmlAmlEntryHandletEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetAmlPathOfTheHdmlElementHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.hdml.exceptions.HdmlAmlInsufficientMemoryException;
import com.aligo.modules.hdml.handlets.HdmlAmlStylePathHandlet;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Vector;

public class HdmlAmlEntryHandlet
extends HdmlAmlStylePathHandlet {
    protected AxmlElement oCurrentAxmlElement;
    protected HdmlElement hdmlElement;
    protected int iChildIndex = 0;
    private AmlPathInterface oCurrentAmlPath;

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlEntryHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlStylePathRelevance() {
        long currentHdmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlEntryHandletEvent) {
            currentHdmlAmlStylePathRelevance = 20L;
        }
        return currentHdmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean flag = true;
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof HdmlAmlEntryHandletEvent) {
            try {
                HdmlAmlEntryHandletEvent hdmlAmlEntryHandletEvent = (HdmlAmlEntryHandletEvent)this.oCurrentEvent;
                this.oCurrentAmlPath = hdmlAmlEntryHandletEvent.getAmlPath();
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                HdmlElement entryElement = hdmlAmlEntryHandletEvent.getHdmlElement();
                XmlElementInterface parentXmlElement = hdmlAmlEntryHandletEvent.getXmlElement().getParentXmlElement();
                HdmlElement entryContainerElement = null;
                PageAllocatorInterface pageAllocator = HdmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                pageAllocator.allocateElement();
                String name = pageAllocator.getCurrentElementID();
                HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, entryElement, "name", name);
                HdmlAmlXmlHdmlElementHandletEvent getParentHdmlElementEvent = new HdmlAmlXmlHdmlElementHandletEvent("Get", this.oCurrentAmlPath, parentXmlElement);
                this.oHandlerManager.postEventNow(getParentHdmlElementEvent);
                entryContainerElement = HdmlAmlElementUtils.getTopHdmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                HdmlElement displayElement = this.getDisplayElement(entryContainerElement);
                if (displayElement != null) {
                    int noOfElements = displayElement.getNumberElements();
                    int i = 0;
                    while (i < noOfElements) {
                        HdmlElement displayChildElement = displayElement.hdmlElementAt(i);
                        HdmlAmlElementUtils.addHdmlElement(this.oHandlerManager, this.oCurrentAmlPath, entryElement, displayChildElement);
                        ++i;
                    }
                    HdmlAmlGetAmlPathOfTheHdmlElementHandlerEvent hdmlAmlGetAmlPathOfTheHdmlElementHandlerEvent = new HdmlAmlGetAmlPathOfTheHdmlElementHandlerEvent(displayElement);
                    this.oHandlerManager.postEventNow(hdmlAmlGetAmlPathOfTheHdmlElementHandlerEvent);
                    HdmlAmlElementUtils.removeHdmlElement(this.oHandlerManager, hdmlAmlGetAmlPathOfTheHdmlElementHandlerEvent.getAmlPath(), displayElement.getHdmlParentElement(), displayElement);
                }
                HdmlAmlElementUtils.addHdmlElement(this.oHandlerManager, this.oCurrentAmlPath, entryContainerElement, entryElement);
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof HdmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                HdmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HdmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else if (flag) {
                HdmlAmlAddElementHandledHandletEvent hdmlAddElementHandledEvent = new HdmlAmlAddElementHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEvent(hdmlAddElementHandledEvent);
            }
        }
    }

    private boolean emptyContainer(HdmlElement container) {
        try {
            if (container instanceof HdmlContainer && container.getNumberElements() <= 1) {
                container = container.hdmlElementAt(0);
                return this.emptyContainer(container);
            }
        }
        catch (HdmlElementIndexOutOfBoundsException e) {
            return true;
        }
        return false;
    }

    private HdmlElement getPreviousEntryContainer(HdmlElement hdmlContainer, int position) {
        HdmlElement previousContainer = null;
        try {
            previousContainer = hdmlContainer.hdmlElementAt(position - 1);
            if (this.emptyContainer(previousContainer)) {
                return this.getPreviousEntryContainer(hdmlContainer, position - 1);
            }
            return previousContainer;
        }
        catch (HdmlElementIndexOutOfBoundsException e) {
            return previousContainer;
        }
    }

    private HdmlElement getDisplayElement(HdmlElement hdmlElement) {
        try {
            HdmlElement parentElement = hdmlElement.getHdmlParentElement();
            if (parentElement != null) {
                int pos = parentElement.hdmlElementIndex(hdmlElement);
                HdmlElement childElement = null;
                if (pos > 0) {
                    int i = 0;
                    while (i < pos) {
                        childElement = parentElement.hdmlElementAt(i);
                        if (childElement != null) {
                            if (childElement instanceof HdmlDisplay) {
                                return childElement;
                            }
                            if (childElement.getNumberElements() >= 1) {
                                int j = 0;
                                if (j < childElement.getNumberElements()) {
                                    childElement = childElement.hdmlElementAt(j);
                                    return this.getDisplayElement(childElement);
                                }
                            }
                        }
                        ++i;
                    }
                } else if (hdmlElement != null && hdmlElement instanceof HdmlDisplay) {
                    return hdmlElement;
                }
                return this.getDisplayElement(parentElement);
            }
        }
        catch (Exception e) {
            this.oHandlerLogger.logError(e);
        }
        return null;
    }
}

