/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.HdmlAmlPathHandler;
import com.aligo.modules.hdml.errors.HdmlAmlHandlerError;
import com.aligo.modules.hdml.events.HdmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlCompactElementHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetNextChildIndexHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlIsAncestorPersistentHandlerEvent;
import com.aligo.modules.hdml.exceptions.HdmlAmlNextIndexNotFoundPersistException;
import com.aligo.modules.hdml.exceptions.HdmlAmlPreviousIndexNotFoundPersistException;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlAmlMemoryUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HdmlAmlPersistChildHandler
extends HdmlAmlPathHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    private Hashtable oPathIndices = new Hashtable();
    private Hashtable oIsPersistent = new Hashtable();
    private Hashtable oCompactIndices = new Hashtable();

    public Hashtable getPathIndices(AmlPathInterface amlPath) {
        String strAmlPath = amlPath.toString();
        Hashtable indices = (Hashtable)this.oPathIndices.get(strAmlPath);
        if (indices == null) {
            indices = new Hashtable();
            this.oPathIndices.put(strAmlPath, indices);
        }
        return indices;
    }

    private int getCompactIndex(AmlPathInterface amlPath) {
        String strAmlPath = amlPath.toString();
        int compactIndex = 0;
        Integer ICompactIndex = (Integer)this.oCompactIndices.get(strAmlPath);
        if (ICompactIndex != null) {
            compactIndex = ICompactIndex;
        }
        return compactIndex;
    }

    private void setCompactIndex(AmlPathInterface amlPath, int compactIndex) {
        String strAmlPath = amlPath.toString();
        this.oCompactIndices.put(strAmlPath, new Integer(compactIndex));
    }

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetNextChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetPreviousChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlCompactElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlIsAncestorPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlPathRelevance() {
        long currentHdmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlGetNextChildIndexHandlerEvent) {
            HdmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = (HdmlAmlGetNextChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getNextChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null) {
                int currentIndex = getNextChildIndexEvent.getCurrentIndex();
                boolean relevant = false;
                relevant = currentIndex == -1 ? true : this.isRelevant(parentAmlPath);
                if (relevant) {
                    currentHdmlAmlPathRelevance = 30L;
                }
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPreviousChildIndexHandlerEvent) {
            boolean relevant;
            HdmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = (HdmlAmlGetPreviousChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getPreviousChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null && (relevant = this.isRelevant(parentAmlPath))) {
                currentHdmlAmlPathRelevance = 30L;
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlAddChildContainerHandlerEvent) {
            HdmlAmlAddChildContainerHandlerEvent addChildContainerEvent = (HdmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addChildContainerEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null && this.isRelevant(parentAmlPath)) {
                try {
                    AxmlElement childAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (!this.isPersistentElement(childAmlElement)) {
                        currentHdmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlCompactElementHandlerEvent) {
            currentHdmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlIsAncestorPersistentHandlerEvent) {
            currentHdmlAmlPathRelevance = 20L;
        }
        return currentHdmlAmlPathRelevance;
    }

    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HdmlAmlGetNextChildIndexHandlerEvent) {
            HdmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = (HdmlAmlGetNextChildIndexHandlerEvent)this.oCurrentEvent;
            int currentIndex = getNextChildIndexEvent.getCurrentIndex();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int nextIndex = 0;
            if (currentIndex == -1) {
                this.prepareIndices(parentAmlPath);
            }
            nextIndex = this.getNextChildIndex(parentAmlPath, currentIndex);
            getNextChildIndexEvent.setNextIndex(nextIndex);
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPreviousChildIndexHandlerEvent) {
            HdmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = (HdmlAmlGetPreviousChildIndexHandlerEvent)this.oCurrentEvent;
            int currentIndex = getPreviousChildIndexEvent.getCurrentIndex();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int previousIndex = this.getPreviousChildIndex(parentAmlPath, currentIndex);
            getPreviousChildIndexEvent.setPreviousIndex(previousIndex);
        } else if (this.oCurrentEvent instanceof HdmlAmlAddChildContainerHandlerEvent) {
            HdmlAmlAddChildContainerHandlerEvent addChildContainerEvent = (HdmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = this.oCurrentAmlPath;
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            int childIndex = this.getAddChildIndex(currentAmlPath);
            HdmlElement hdmlElement = HdmlAmlElementUtils.getChildContainerHdmlElement(this.oHandlerManager, parentAmlPath);
            HdmlElement childHdmlElement = addChildContainerEvent.getHdmlElement();
            int childSubIndex = addChildContainerEvent.getChildIndex();
            if (childSubIndex == -1) {
                childSubIndex = 0;
            }
            HdmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = new HdmlAmlControlMenuOffsetHandlerEvent(currentAmlPath, childIndex);
            this.oHandlerManager.postEventNow(controlMenuOffsetEvent);
            int cmOffsetChildIndex = controlMenuOffsetEvent.getOffsetChildIndex();
            childIndex = cmOffsetChildIndex != -1 ? cmOffsetChildIndex + childSubIndex : (childIndex += childSubIndex);
            int compactIndex = this.getCompactIndex(parentAmlPath);
            HdmlAmlElementUtils.addHdmlElement(this.oHandlerManager, currentAmlPath, hdmlElement, childHdmlElement, childIndex -= compactIndex);
        } else if (this.oCurrentEvent instanceof HdmlAmlCompactElementHandlerEvent) {
            int compactIndex = this.getCompactIndex(this.oCurrentAmlPath);
            this.setCompactIndex(this.oCurrentAmlPath, ++compactIndex);
        } else if (this.oCurrentEvent instanceof HdmlAmlIsAncestorPersistentHandlerEvent) {
            HdmlAmlIsAncestorPersistentHandlerEvent isAncestorPersistentEvent = (HdmlAmlIsAncestorPersistentHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = isAncestorPersistentEvent.getAmlPath();
            boolean persistent = this.isAncestorPersistent(amlPath);
            isAncestorPersistentEvent.setPersistent(persistent);
        }
    }

    private int getAddChildIndex(AmlPathInterface currentAmlPath) throws HandlerError {
        int addChildIndex = -1;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        AmlPathInterface lastWorkingPath = HdmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        if (lastWorkingPath == null) {
            addChildIndex = childIndex;
        } else {
            int currentNumberElements = currentAmlPath.getNumberAmlPathComponents();
            int numberElements = lastWorkingPath.getNumberAmlPathComponents();
            try {
                boolean memoryCache = false;
                AmlPathInterface amlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                AmlPathInterface parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath);
                if (this.arePathsConcurrent(amlPath, parentLastWorkingPath)) {
                    memoryCache = true;
                }
                if (!memoryCache) {
                    addChildIndex = childIndex;
                } else if (numberElements < currentNumberElements) {
                    addChildIndex = childIndex;
                } else {
                    AmlPathComponentInterface pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1);
                    int lastChildIndex = pathComponent.getPathIndex();
                    if (childIndex >= lastChildIndex) {
                        addChildIndex = this.getNumberPersistElements(amlPath, lastChildIndex);
                        addChildIndex += childIndex - lastChildIndex;
                    }
                }
            }
            catch (AmlPathIndexOutOfBoundsException ae) {
                // empty catch block
            }
        }
        return addChildIndex;
    }

    private int getNumberPersistElements(AmlPathInterface parentPath, int lastChildIndex) {
        int numberPersistElements = 0;
        if (parentPath != null) {
            try {
                AxmlElement parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath);
                int numberChildren = parentAmlElement.getNumberElements();
                if (lastChildIndex > numberChildren) {
                    lastChildIndex = numberChildren;
                }
                try {
                    int i = 0;
                    while (i < lastChildIndex) {
                        AxmlElement childAmlElement = parentAmlElement.axmlElementAt(i);
                        if (this.isPersistentElement(childAmlElement)) {
                            ++numberPersistElements;
                        }
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {}
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return numberPersistElements;
    }

    private boolean isRelevant(AmlPathInterface amlPath) {
        boolean relevant = false;
        String strAmlPath = amlPath.toString();
        Boolean isPersistent = (Boolean)this.oIsPersistent.get(strAmlPath);
        if (isPersistent != null) {
            relevant = isPersistent;
        }
        return relevant;
    }

    private boolean arePathsConcurrent(AmlPathInterface path1, AmlPathInterface path2) {
        boolean concurrent = false;
        if (path1 != null && path2 != null) {
            int path2Elements;
            int path1Elements = path1.getNumberAmlPathComponents();
            if (path1Elements <= (path2Elements = path2.getNumberAmlPathComponents())) {
                try {
                    boolean equal = true;
                    int i = 0;
                    while (i < path1Elements && equal) {
                        AmlPathComponentInterface memoryComponent;
                        int memoryPathIndex;
                        AmlPathComponentInterface component = path1.getAmlPathComponentAt(i);
                        int pathIndex = component.getPathIndex();
                        if (pathIndex != (memoryPathIndex = (memoryComponent = path2.getAmlPathComponentAt(i)).getPathIndex())) {
                            equal = false;
                        }
                        ++i;
                    }
                    if (equal) {
                        concurrent = true;
                    }
                }
                catch (AmlPathIndexOutOfBoundsException ae) {}
            }
        } else if (path1 == null && path2 == null) {
            concurrent = true;
        }
        return concurrent;
    }

    private int getNextTableIndex(AmlPathInterface amlPath, int currentIndex) throws Exception {
        int nextIndex = currentIndex;
        Hashtable indices = this.getPathIndices(amlPath);
        boolean error = false;
        if (indices != null) {
            Integer nextIIndex = (Integer)indices.get(new Integer(currentIndex));
            if (nextIIndex != null) {
                nextIndex = nextIIndex;
            } else {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new HdmlAmlNextIndexNotFoundPersistException(amlPath, currentIndex);
        }
        return nextIndex;
    }

    private int getPreviousTableIndex(AmlPathInterface amlPath, int currentIndex) throws Exception {
        int previousIndex = currentIndex;
        Hashtable indices = this.getPathIndices(amlPath);
        boolean error = false;
        boolean found = false;
        if (indices != null) {
            Enumeration keys = indices.keys();
            Integer IcurrentIndex = new Integer(currentIndex);
            while (keys.hasMoreElements() && !found) {
                Integer key = (Integer)keys.nextElement();
                Integer value = (Integer)indices.get(key);
                if (value == null || !IcurrentIndex.equals(value)) continue;
                previousIndex = key;
                found = true;
            }
            if (!found) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new HdmlAmlPreviousIndexNotFoundPersistException(amlPath, currentIndex);
        }
        return previousIndex;
    }

    private int getNextChildIndex(AmlPathInterface amlPath, int currentIndex) throws HandlerError {
        AmlPathInterface lastWorkingPath = HdmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        return this.getNextChildIndex(amlPath, currentIndex, lastWorkingPath);
    }

    private int getPreviousChildIndex(AmlPathInterface amlPath, int currentIndex) throws HandlerError {
        AmlPathInterface lastWorkingPath = HdmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        return this.getPreviousChildIndex(amlPath, currentIndex, lastWorkingPath);
    }

    private int getNextChildIndex(AmlPathInterface amlPath, int currentIndex, AmlPathInterface lastWorkingPath) throws HandlerError {
        try {
            int nextIndex = this.getNextTableIndex(amlPath, currentIndex);
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            try {
                if (nextIndex < numberChildren) {
                    AmlPathInterface parentLastWorkingPath;
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, nextIndex);
                    boolean persistent = this.isAncestorPersistent(childAmlPath);
                    boolean memoryCache = false;
                    if (lastWorkingPath != null && this.arePathsConcurrent(amlPath, parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath))) {
                        memoryCache = true;
                    }
                    if (!persistent && memoryCache) {
                        AmlPathComponentInterface pathComponent;
                        int lastChildIndex;
                        int currentNumberElements = amlPath.getNumberAmlPathComponents() + 1;
                        int numberElements = lastWorkingPath.getNumberAmlPathComponents();
                        if (currentNumberElements != 0 && numberElements >= currentNumberElements && nextIndex < (lastChildIndex = (pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1)).getPathIndex())) {
                            nextIndex = this.getNextChildIndex(amlPath, nextIndex);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new HdmlAmlHandlerError(ex);
            }
            return nextIndex;
        }
        catch (Exception ex) {
            throw new HdmlAmlHandlerError(ex);
        }
    }

    private int getPreviousChildIndex(AmlPathInterface amlPath, int currentIndex, AmlPathInterface lastWorkingPath) throws HandlerError {
        try {
            int previousIndex = this.getPreviousTableIndex(amlPath, currentIndex);
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            try {
                if (previousIndex >= 0) {
                    AmlPathInterface parentLastWorkingPath;
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, previousIndex);
                    boolean persistent = this.isAncestorPersistent(childAmlPath);
                    boolean memoryCache = false;
                    if (lastWorkingPath != null && this.arePathsConcurrent(amlPath, parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath))) {
                        memoryCache = true;
                    }
                    if (!persistent && memoryCache) {
                        AmlPathComponentInterface pathComponent;
                        int lastChildIndex;
                        int currentNumberElements = amlPath.getNumberAmlPathComponents() + 1;
                        int numberElements = lastWorkingPath.getNumberAmlPathComponents();
                        if (currentNumberElements != 0 && numberElements >= currentNumberElements && previousIndex < (lastChildIndex = (pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1)).getPathIndex())) {
                            previousIndex = this.getPreviousChildIndex(amlPath, previousIndex, lastWorkingPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new HdmlAmlHandlerError(ex);
            }
            return previousIndex;
        }
        catch (Exception ex) {
            throw new HdmlAmlHandlerError(ex);
        }
    }

    private boolean isAncestorPersistent(AmlPathInterface amlPath) {
        boolean persistent = false;
        AmlPathInterface rPath = amlPath;
        boolean done = false;
        try {
            while (rPath != null && !done) {
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, rPath);
                if (this.isPersistentElement(amlElement)) {
                    persistent = true;
                    done = true;
                }
                rPath = AmlPathUtils.getParentPath(this.oHandlerManager, rPath);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return persistent;
    }

    private boolean isPersistentElement(AxmlElement amlElement) {
        boolean persistentElement = false;
        if (amlElement instanceof AxmlControlMenu) {
            persistentElement = true;
        } else {
            String value = amlElement.getAxmlAttributeValue(PERSIST);
            if (value != null && !value.equals(PERSIST_FALSE)) {
                persistentElement = true;
            }
        }
        return persistentElement;
    }

    private void prepareIndices(AmlPathInterface amlPath) {
        try {
            boolean isPersistent = false;
            Hashtable indices = this.getPathIndices(amlPath);
            String strAmlPath = amlPath.toString();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            Vector<Integer> persistIndices = new Vector<Integer>();
            Vector<Integer> normalIndices = new Vector<Integer>();
            int i = 0;
            while (i < numberChildren) {
                try {
                    AxmlElement childAmlElement = amlElement.axmlElementAt(i);
                    if (this.isPersistentElement(childAmlElement)) {
                        if (!isPersistent) {
                            this.oIsPersistent.put(strAmlPath, new Boolean(true));
                            isPersistent = true;
                        }
                        persistIndices.addElement(new Integer(i));
                    } else {
                        normalIndices.addElement(new Integer(i));
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                ++i;
            }
            Integer lpin = new Integer(-1);
            int psize = persistIndices.size();
            int i2 = 0;
            while (i2 < psize) {
                Integer pin = (Integer)persistIndices.elementAt(i2);
                indices.put(lpin, pin);
                lpin = pin;
                ++i2;
            }
            int nsize = normalIndices.size();
            int i3 = 0;
            while (i3 < nsize) {
                Integer nin = (Integer)normalIndices.elementAt(i3);
                indices.put(lpin, nin);
                lpin = nin;
                ++i3;
            }
            indices.put(lpin, new Integer(numberChildren));
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }
}

