/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.HdmlAmlPathHandler;
import com.aligo.modules.hdml.events.HdmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetActiveIndexMemoryHandlerEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.hdml.util.exceptions.HdmlAmlGetRootElementFailedException;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Vector;

public class HdmlAmlAddChildContainerHandler
extends HdmlAmlPathHandler {
    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlPathRelevance() {
        long currentHdmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlAddChildContainerHandlerEvent) {
            currentHdmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlControlMenuOffsetHandlerEvent) {
            currentHdmlAmlPathRelevance = 20L;
        }
        return currentHdmlAmlPathRelevance;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws HdmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        int numberMenus = 0;
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        if (parentAmlPath != null) {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
            int numberChildren = amlElement.getNumberElements();
            int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            if (childIndex > numberChildren - 1) {
                childIndex = numberChildren - 1;
            }
            int i = 0;
            while (i < childIndex) {
                AxmlElement childAmlElement = amlElement.axmlElementAt(i);
                if (childAmlElement instanceof AxmlControlMenu) {
                    ++numberMenus;
                }
                ++i;
            }
        }
        return numberMenus;
    }

    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HdmlAmlAddChildContainerHandlerEvent) {
            HdmlAmlAddChildContainerHandlerEvent hdmlAmlAddChildContainerHandlerEvent = (HdmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            HdmlElement hdmlElement = HdmlAmlElementUtils.getChildContainerHdmlElement(this.oHandlerManager, parentAmlPath);
            HdmlElement childHdmlElement = hdmlAmlAddChildContainerHandlerEvent.getHdmlElement();
            int childIndex = hdmlAmlAddChildContainerHandlerEvent.getChildIndex();
            AmlPathInterface elementContainerPath = null;
            if (parentAmlPath == null) {
                elementContainerPath = this.oCurrentAmlPath;
                try {
                    HdmlAmlGetActiveIndexMemoryHandlerEvent event = new HdmlAmlGetActiveIndexMemoryHandlerEvent();
                    this.oHandlerManager.postEventNow(event);
                    childIndex = event.getActiveIndex();
                }
                catch (HandlerError he) {}
            } else {
                elementContainerPath = parentAmlPath;
            }
            HdmlAmlElementUtils.addHdmlElement(this.oHandlerManager, elementContainerPath, hdmlElement, childHdmlElement, childIndex);
        } else if (this.oCurrentEvent instanceof HdmlAmlControlMenuOffsetHandlerEvent) {
            HdmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (HdmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int childIndex = controlMenuOffsetEvent.getChildIndex();
            int offsetChildIndex = -1;
            try {
                int numberControlMenus;
                if (this.oCurrentAmlPath != null && (numberControlMenus = this.getNumberControlMenus(this.oCurrentAmlPath)) > 0) {
                    offsetChildIndex = childIndex - numberControlMenus;
                }
            }
            catch (Exception ex) {
                offsetChildIndex = 0;
            }
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
        }
    }
}

