/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlContainer;
import com.aligo.chtml.CHtmlInput;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.events.CHtmlAmlGetStyleIDStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.exceptions.CHtmlAmlInsufficientMemoryException;
import com.aligo.modules.chtml.handlets.CHtmlAmlStylePathHandlet;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class CHtmlAmlSeparatePidFromFormsUrlHandlet
extends CHtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    CHtmlElement chtmlElement;
    boolean style_id = false;
    private static final String HIDDEN = "hidden";
    private static final String URL = "url";
    private static final String QUESTION_MARK = "?";
    private static final String EQUAL_TO = "=";
    private static final String ACTION = "action";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlStylePathRelevance() {
        long currentCHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent) {
            CHtmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                XmlStyleID xmlStyleID;
                String name;
                AligoEventInterface event = this.oCurrentEvent;
                CHtmlAmlXmlCHtmlElementHandletEvent getCHtmlElementEvent = new CHtmlAmlXmlCHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getCHtmlElementEvent);
                this.oCurrentEvent = event;
                this.chtmlElement = getCHtmlElementEvent.getCHtmlElement();
                CHtmlAmlGetStyleIDStateHandlerEvent getStyleIDStateEvent = new CHtmlAmlGetStyleIDStateHandlerEvent(addAttributeEvent.getAmlPath());
                this.oHandlerManager.postEventNow(getStyleIDStateEvent);
                StyleIDInterface styleID = getStyleIDStateEvent.getStyleID();
                if (styleID instanceof XmlStyleID && (name = (xmlStyleID = (XmlStyleID)styleID).getName()) != null && name.equals("CHtml_2")) {
                    this.style_id = true;
                }
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.chtmlElement instanceof CHtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(HIDDEN)) {
                        currentCHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentCHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.chtmlElement instanceof CHtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    Object previousCHtmlElement = null;
                    AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    String amlAttributeValue = axmlElement.getAxmlAttributeValue(URL);
                    if (amlAttributeName.toLowerCase().equals(HIDDEN) && amlAttributeValue.indexOf(QUESTION_MARK) != -1) {
                        int position = amlAttributeValue.indexOf(QUESTION_MARK);
                        String formUrl = amlAttributeValue.substring(0, position);
                        String sessionIdInfo = amlAttributeValue.substring(position + 1);
                        if (sessionIdInfo.indexOf(EQUAL_TO) != -1) {
                            int eqPosition = sessionIdInfo.indexOf(EQUAL_TO);
                            CHtmlElement topElement = CHtmlAmlElementUtils.getTopCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                            CHtmlElement containerElement = topElement.chtmlElementAt(0);
                            CHtmlElement formElement = containerElement.chtmlElementAt(0);
                            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, formElement, ACTION, formUrl);
                            CHtmlInput input = new CHtmlInput();
                            input.addCHtmlAttribute(TYPE, HIDDEN);
                            input.addCHtmlAttribute(NAME, sessionIdInfo.substring(0, eqPosition));
                            input.addCHtmlAttribute(VALUE, sessionIdInfo.substring(eqPosition + 1));
                            CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, formElement, input);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof CHtmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    CHtmlAmlElementUtils.removeCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement.getCHtmlParentElement(), this.chtmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                CHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new CHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                CHtmlAmlAddAttributeHandledHandletEvent chtmlAmlAddAttributeHandledHandletEvent = new CHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(chtmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

