/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.amlhandlets;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlMeta;
import com.aligo.chtml.exceptions.CHtmlAttributeCannotBeAddedException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.handlets.CHtmlAmlStylePathHandlet;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class CHtmlAmlRefreshHandlet
extends CHtmlAmlStylePathHandlet {
    private static final String REFRESH = "Refresh";
    private static final String CONTENT_SEPARATOR = "; ";
    private static final String URL = "URL";
    private static final String EQUALS = "=";
    private AxmlElement oAmlElement;
    private String sRefresh;
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlStylePathRelevance() {
        CHtmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentCHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (CHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface) {
            String refresh;
            String attrName;
            XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute;
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            if (amlElement instanceof AxmlDocument && (attrName = xmlAmlHandlerAttribute.getAmlAttributeName()).equals("refresh") && (refresh = amlElement.getAxmlAttributeValue(attrName)) != null) {
                this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                this.oAmlElement = amlElement;
                this.sRefresh = refresh;
                currentCHtmlAmlStylePathRelevance = 20L;
            }
        }
        return currentCHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent) {
            try {
                CHtmlElement chtmlElement = CHtmlAmlElementUtils.getCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                try {
                    CHtmlMeta chtmlMeta = new CHtmlMeta();
                    chtmlMeta.addCHtmlAttribute("http-equiv", REFRESH);
                    int timeout = 0;
                    try {
                        String strTimeout = this.oAmlElement.getAxmlAttributeValue("refresh_timeout");
                        if (strTimeout != null) {
                            timeout = new Integer(strTimeout);
                        }
                    }
                    catch (NumberFormatException ne) {
                        this.oHandlerLogger.logError(ne);
                    }
                    String content = timeout + CONTENT_SEPARATOR + URL + EQUALS + this.sRefresh;
                    chtmlMeta.addCHtmlAttribute("content", content);
                    CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, chtmlElement, chtmlMeta);
                }
                catch (CHtmlAttributeCannotBeAddedException ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
            CHtmlAmlAddAttributeHandledHandletEvent addAttributeHandledEvent = new CHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(addAttributeHandledEvent);
        }
    }
}

