/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlFont;
import com.aligo.chtml.CHtmlSelect;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.events.CHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.exceptions.CHtmlAmlInsufficientMemoryException;
import com.aligo.modules.chtml.handlets.CHtmlAmlStylePathHandlet;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class CHtmlAmlChoiceModeHandlet
extends CHtmlAmlStylePathHandlet {
    private static final String MULTIPLE = "multiple";
    private static final String SINGLE = "single";
    private static final String MODE = "mode";
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    CHtmlElement chtmlElement;

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlStylePathRelevance() {
        long currentCHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent) {
            CHtmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                CHtmlAmlXmlCHtmlElementHandletEvent getCHtmlElementEvent = new CHtmlAmlXmlCHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getCHtmlElementEvent);
                this.oCurrentEvent = event;
                this.chtmlElement = getCHtmlElementEvent.getCHtmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.chtmlElement instanceof CHtmlSelect) {
                    currentCHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentCHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleStylePathEvent() {
        boolean memoryError;
        block10: {
            if (!(this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent)) return;
            memoryError = false;
            try {
                if (!(this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) || !(this.chtmlElement instanceof CHtmlSelect)) break block10;
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                CHtmlElement chtmlParentElement = this.chtmlElement.getCHtmlParentElement();
                int position = -1;
                if (!amlAttributeName.toLowerCase().equals(MODE)) break block10;
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                if (amlAttributeValue.toLowerCase().indexOf(MULTIPLE) != -1) {
                    CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement, MULTIPLE, "true");
                } else if (amlAttributeValue.toLowerCase().indexOf(SINGLE) == -1) {
                    // empty if block
                }
            }
            catch (HandlerError he) {
                AxmlElement amlElement;
                Exception ex = he.getException();
                if (!(ex instanceof CHtmlAmlInsufficientMemoryException)) break block10;
                memoryError = true;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                    memoryError = false;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        if (!memoryError) {
            CHtmlAmlAddAttributeHandledHandletEvent chtmlAmlAddAttributeHandledHandletEvent = new CHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(chtmlAmlAddAttributeHandledHandletEvent);
            return;
        }
        try {
            CHtmlAmlElementUtils.removeCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement.getCHtmlParentElement(), this.chtmlElement);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        CHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new CHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
        this.oHandlerManager.postEvent(insufficientMemoryEvent);
    }

    public CHtmlElement getCHtmlFontFromParentList(CHtmlElement currentElement) {
        while (currentElement != null) {
            CHtmlElement parentElement = currentElement.getCHtmlParentElement();
            if (parentElement instanceof CHtmlFont) {
                return parentElement;
            }
            currentElement = parentElement;
        }
        return null;
    }
}

