/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml;

import com.aligo.axml.AxmlCheckBox;
import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlForm;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlListItem;
import com.aligo.axml.AxmlOption;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlA;
import com.aligo.chtml.CHtmlOption;
import com.aligo.chtml.CHtmlPCData;
import com.aligo.chtml.exceptions.CHtmlElementNotFoundException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.CHtmlAmlHandler;
import com.aligo.modules.chtml.errors.CHtmlAmlHandlerError;
import com.aligo.modules.chtml.events.CHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlCheckLinkFormHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlCheckLinkPageHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlCreateElementHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlEndRenderingHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetDynamicURLHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetFormRedirectionInfoHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetLastWorkingPathHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlSetCurrentPageHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlStartNewRealmMemoryHandlerEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlRemoveXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlSetFormUrlHandletEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlAmlMemoryUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.AmlPath;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.FormRedirector;
import java.util.Vector;

public class CHtmlAmlMemoryHandler
extends CHtmlAmlHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    private static final String PAGE = "com.aligo.axml.AxmlPage";
    private static final String FORM = "com.aligo.axml.AxmlForm";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";
    private static final String TABLEROW = "com.aligo.axml.AxmlTableRow";
    private static final String FORM_NAME = "Form";
    private static final String FORM_ACTION = "action";
    private static final String EQUALS = "=";
    private int iRealm = 0;
    private AmlPathInterface oLastWorkingPath = null;
    private static final String MORE = "More";
    private static final String BACK = "Back";
    private static final String HREF = "href";
    private static final String TEXT = "text";
    private static final String SUBMIT_IDENTIFIER = "s";
    private static final String FORMNUM_IDENTIFIER = "agf";
    private AmlPathInterface oLastPagePath = null;
    private AmlPathInterface oCurrentPagePath = null;
    private boolean bPageSet = false;
    private AmlPathInterface oLastFormPath = null;
    private AmlPathInterface oLastFormProcessedPath = null;
    private boolean bIsChoiceFormPresent = false;
    private Vector oLastFormRedirectors = new Vector();
    private String oSecondLastChoiceFormURL = null;
    private boolean bClosingChoiceFormCall = false;
    private boolean bDisablePageBack = false;
    private boolean bDisablePageMore = false;
    private boolean bPFClosingChoiceForm = false;
    private int iFormNumber = 0;

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlInsufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlStartNewRealmMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlSetCurrentPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlCheckLinkPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlCheckLinkFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlIsCachedChoiceFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetLastWorkingPathHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlRelevance() {
        long currentCHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlInsufficientMemoryHandlerEvent || this.oCurrentEvent instanceof CHtmlAmlStartNewRealmMemoryHandlerEvent || this.oCurrentEvent instanceof CHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlSetCurrentPageHandlerEvent) {
            currentCHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlCheckLinkPageHandlerEvent) {
            currentCHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlCheckLinkFormHandlerEvent) {
            currentCHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsCachedChoiceFormHandlerEvent) {
            currentCHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetLastWorkingPathHandlerEvent) {
            currentCHtmlAmlRelevance = 20L;
        }
        return currentCHtmlAmlRelevance;
    }

    public void handleEvent() {
        block30: {
            if (this.oCurrentEvent instanceof CHtmlAmlInsufficientMemoryHandlerEvent) {
                AmlPathInterface workingPath = ((CHtmlAmlInsufficientMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
                boolean sane = false;
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("InSufficient memory...");
                }
                try {
                    AmlPathInterface lastWorkingPath;
                    do {
                        AmlPathInterface parentPath;
                        try {
                            AxmlElement amlElement;
                            if (workingPath != null && this.isTextElement(workingPath) && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && ((amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath)) instanceof AxmlTextArea || amlElement instanceof AxmlInput || amlElement instanceof AxmlCheckBox || amlElement instanceof AxmlOption || amlElement instanceof AxmlListItem)) {
                                CHtmlAmlResetTextStateHandlerEvent resetTextStateEvent = new CHtmlAmlResetTextStateHandlerEvent(workingPath);
                                this.oHandlerManager.postEventNow(resetTextStateEvent);
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        try {
                            CHtmlAmlElementUtils.detachFromTree(this.oHandlerManager, workingPath);
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        sane = CHtmlAmlElementUtils.isDeckSane(this.oHandlerManager);
                        if (sane && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && !CHtmlAmlMemoryUtils.isCacheable(this.oHandlerManager, parentPath)) {
                            sane = CHtmlAmlMemoryUtils.isCacheable(this.oHandlerManager, workingPath);
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Cache sanity: working path " + workingPath + " sanity " + sane);
                            }
                        }
                        lastWorkingPath = workingPath;
                        try {
                            AmlPathInterface trWorkingPath;
                            workingPath = this.getPreviousPath(lastWorkingPath);
                            if (sane && !this.isTableRowElement(lastWorkingPath) && (trWorkingPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, lastWorkingPath, TABLEROW)) != null) {
                                sane = false;
                            }
                            if (!sane || workingPath == null) continue;
                            int currentNumberElements = workingPath.getNumberAmlPathComponents();
                            int lastNumberElements = lastWorkingPath.getNumberAmlPathComponents();
                            if (lastNumberElements == currentNumberElements) continue;
                            boolean detach = true;
                            if (this.isTextElement(lastWorkingPath)) {
                                CHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = new CHtmlAmlShouldDetachTextMemoryHandlerEvent(lastWorkingPath);
                                this.oHandlerManager.postEventNow(shouldDetachTextMemoryEvent);
                                detach = shouldDetachTextMemoryEvent.isDetach();
                            }
                            if (!detach) continue;
                            sane = false;
                        }
                        catch (HandlerError he) {
                            sane = true;
                        }
                    } while (!sane && workingPath != null);
                    this.checkLinkForm(lastWorkingPath);
                    this.checkLinkPage();
                    boolean end = false;
                    if (workingPath == null) {
                        end = true;
                    } else if (this.oLastWorkingPath != null) {
                        boolean insufficient = false;
                        try {
                            boolean ancestorPersistent = CHtmlAmlMemoryUtils.isAncestorPersistent(this.oHandlerManager, lastWorkingPath);
                            if (ancestorPersistent) {
                                insufficient = true;
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        if (!this.isTextElement(lastWorkingPath)) {
                            String lastCanonicalPath = this.oLastWorkingPath.getCanonicalPath();
                            String currentLastCanonicalPath = lastWorkingPath.getCanonicalPath();
                            if (currentLastCanonicalPath.equals(lastCanonicalPath)) {
                                insufficient = true;
                            }
                        }
                        if (insufficient) {
                            this.oHandlerLogger.logDebug("Page too big for device");
                            end = true;
                        }
                    }
                    if (end) {
                        this.end();
                        break block30;
                    }
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Starting new realm...");
                    }
                    this.startNewRealm(lastWorkingPath);
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Ending...");
                    }
                    this.end();
                }
            } else if (this.oCurrentEvent instanceof CHtmlAmlStartNewRealmMemoryHandlerEvent) {
                this.startNewRealm(((CHtmlAmlStartNewRealmMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
            }
        }
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof CHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            this.detachFromTree(((CHtmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
        } else if (this.oCurrentEvent instanceof CHtmlAmlSetCurrentPageHandlerEvent) {
            CHtmlAmlSetCurrentPageHandlerEvent setCurrentPageEvent = (CHtmlAmlSetCurrentPageHandlerEvent)this.oCurrentEvent;
            this.oCurrentPagePath = setCurrentPageEvent.getAmlPath();
            this.bPageSet = true;
        } else if (this.oCurrentEvent instanceof CHtmlAmlCheckLinkPageHandlerEvent) {
            this.checkLinkPage();
        } else if (this.oCurrentEvent instanceof CHtmlAmlCheckLinkFormHandlerEvent) {
            AmlPathInterface formPath = ((CHtmlAmlCheckLinkFormHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.checkLinkForm(formPath);
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsCachedChoiceFormHandlerEvent) {
            CHtmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = (CHtmlAmlIsCachedChoiceFormHandlerEvent)this.oCurrentEvent;
            AmlPathInterface path = isCachedChoiceFormEvent.getAmlPath();
            boolean cached = this.isCachedChoiceForm(path);
            isCachedChoiceFormEvent.setCached(cached);
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetLastWorkingPathHandlerEvent) {
            ((CHtmlAmlGetLastWorkingPathHandlerEvent)this.oCurrentEvent).setAmlPath(this.oLastWorkingPath);
        }
    }

    private void end() {
        CHtmlAmlEndRenderingHandlerEvent endRenderingEvent = new CHtmlAmlEndRenderingHandlerEvent();
        this.oHandlerManager.postEvent(endRenderingEvent);
    }

    private void startNewRealm(AmlPathInterface lastWorkingPath) {
        this.oLastWorkingPath = lastWorkingPath;
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lastWorkingPath == " + this.oLastWorkingPath.toString());
        }
        ++this.iRealm;
        PageAllocatorInterface pageAllocator = CHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
        pageAllocator.allocatePage();
        AmlPath path = new AmlPath();
        path.setRealm(this.iRealm);
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug(path.toString());
        }
        CHtmlAmlCreateElementHandlerEvent createElementEvent = new CHtmlAmlCreateElementHandlerEvent(path);
        this.oHandlerManager.postEvent(createElementEvent);
    }

    private boolean isTableRowElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean tableRowElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlTableRow) {
            tableRowElement = true;
        }
        return tableRowElement;
    }

    private boolean isTextElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean textElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlText) {
            textElement = true;
        }
        return textElement;
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath) throws HandlerError {
        AmlPathInterface previousPath = null;
        int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        CHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new CHtmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
        this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
        int previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }

    private void detachFromTree(AmlPathInterface currentAmlPath) throws HandlerError {
        block2: {
            CHtmlElement topElement = CHtmlAmlElementUtils.getTopCHtmlElement(this.oHandlerManager, currentAmlPath);
            try {
                CHtmlAmlRemoveXmlCHtmlElementHandletEvent removeXmlCHtmlElementEvent = new CHtmlAmlRemoveXmlCHtmlElementHandletEvent(currentAmlPath, null, topElement);
                this.oHandlerManager.postEventNow(removeXmlCHtmlElementEvent);
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof CHtmlElementNotFoundException) break block2;
                throw he;
            }
        }
    }

    private void checkLinkPage() {
        if (this.bPageSet) {
            this.linkPage();
            this.bPageSet = false;
        }
    }

    private boolean isValidLabel(String label) {
        boolean valid = true;
        if (label == null || label != null && label.equalsIgnoreCase("none")) {
            valid = false;
        }
        return valid;
    }

    private String getNextLabel(AmlPathInterface path) {
        String nextLabel = MORE;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tNextLabel = page.getAxmlAttributeValue("next_label");
            if (this.isValidLabel(tNextLabel)) {
                nextLabel = tNextLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextLabel;
    }

    private String getPrevLabel(AmlPathInterface path) {
        String prevLabel = BACK;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tPrevLabel = page.getAxmlAttributeValue("prev_label");
            if (this.isValidLabel(tPrevLabel)) {
                prevLabel = tPrevLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prevLabel;
    }

    private void linkPage() {
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentPagePath);
            if (amlElement instanceof AxmlPage) {
                if (this.oLastPagePath != null) {
                    AxmlElement amlPage = amlElement;
                    CHtmlElement pageElement = CHtmlAmlElementUtils.getChildContainerCHtmlElement(this.oHandlerManager, this.oCurrentPagePath);
                    if (pageElement != null) {
                        CHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent;
                        CHtmlPCData chtmlPCData;
                        CHtmlA chtmlA;
                        String prevLabel;
                        AxmlElement lastPage = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastPagePath);
                        CHtmlElement lastPageElement = CHtmlAmlElementUtils.getChildContainerCHtmlElement(this.oHandlerManager, this.oLastPagePath);
                        PageAllocatorInterface pageAllocator = CHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                        String prevURL = pageAllocator.getPreviousPageURL();
                        String currURL = pageAllocator.getCurrentPageURL();
                        if (!this.bDisablePageBack && this.isValidLabel(prevLabel = amlPage.getAxmlAttributeValue("prev_label"))) {
                            chtmlA = new CHtmlA();
                            chtmlA.addCHtmlAttribute(HREF, prevURL);
                            chtmlPCData = new CHtmlPCData();
                            chtmlPCData.addCHtmlAttribute(TEXT, prevLabel);
                            chtmlA.addCHtmlElement(chtmlPCData);
                            addControlMenuElementEvent = new CHtmlAmlAddControlMenuElementHandlerEvent(this.oCurrentPagePath, chtmlA);
                            this.oHandlerManager.postEventNow(addControlMenuElementEvent);
                        }
                        if (!this.bDisablePageMore) {
                            String nextLabel = this.getNextLabel(this.oLastPagePath);
                            chtmlA = new CHtmlA();
                            chtmlA.addCHtmlAttribute(HREF, currURL);
                            chtmlPCData = new CHtmlPCData();
                            chtmlPCData.addCHtmlAttribute(TEXT, nextLabel);
                            chtmlA.addCHtmlElement(chtmlPCData);
                            addControlMenuElementEvent = new CHtmlAmlAddControlMenuElementHandlerEvent(this.oLastPagePath, chtmlA);
                            this.oHandlerManager.postEventNow(addControlMenuElementEvent);
                        }
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("+++++oLastPagePath = " + this.oLastPagePath);
                }
                this.oLastPagePath = this.oCurrentPagePath;
            }
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private boolean isCachedChoiceForm(AmlPathInterface amlPath) {
        boolean cached = false;
        if (amlPath != null && this.oLastWorkingPath != null) {
            try {
                AmlPathInterface lastChoiceFormPath;
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                if (!(amlElement instanceof AxmlChoice) && (lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE)) != null && amlPath.getCanonicalPath().equals(lastChoiceFormPath.getCanonicalPath())) {
                    cached = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cached;
    }

    private void checkLinkForm(AmlPathInterface currentAmlPath) {
        this.bDisablePageBack = false;
        this.bDisablePageMore = false;
        int formNumber = this.iFormNumber;
        try {
            PageAllocatorInterface pageAllocator = CHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            CHtmlAmlGetFormRedirectionInfoHandlerEvent getFormRedirectionInfoEvent = new CHtmlAmlGetFormRedirectionInfoHandlerEvent();
            this.oHandlerManager.postEventNow(getFormRedirectionInfoEvent);
            FormRedirectionInfo formRedirectionInfo = getFormRedirectionInfoEvent.getInfo();
            if (this.bPFClosingChoiceForm) {
                this.bDisablePageMore = true;
                this.bPFClosingChoiceForm = false;
            }
            AmlPathInterface currentFormPath = null;
            if (currentAmlPath != null) {
                currentFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, FORM);
            }
            if (this.bClosingChoiceFormCall && this.oLastFormPath != null) {
                this.oLastFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
            }
            boolean lastFormPathSet = false;
            if (this.oLastFormPath != null) {
                this.bDisablePageMore = true;
                AmlPathInterface lastChoiceFormPath = null;
                if (this.oLastWorkingPath != null) {
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                        if (!(amlElement instanceof AxmlChoice)) {
                            lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE);
                            if (this.bClosingChoiceFormCall) {
                                lastChoiceFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, lastChoiceFormPath);
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("lastChoiceFormPath = " + lastChoiceFormPath);
                }
                boolean isLastChoiceFormPresent = false;
                String choiceName = null;
                String choiceForwardValue = null;
                String choiceBackwardValue = null;
                boolean isSecondLastChoiceFormPresent = false;
                if (lastChoiceFormPath != null) {
                    isLastChoiceFormPresent = true;
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, lastChoiceFormPath);
                        choiceName = amlElement.getAxmlAttributeValue("name");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (isLastChoiceFormPresent && this.oSecondLastChoiceFormURL != null) {
                    isSecondLastChoiceFormPresent = true;
                }
                if (isLastChoiceFormPresent) {
                    CHtmlElement choiceElement;
                    CHtmlPCData chtmlPCData;
                    CHtmlOption chtmlOption;
                    this.bDisablePageBack = true;
                    this.bDisablePageMore = true;
                    if (isSecondLastChoiceFormPresent) {
                        try {
                            chtmlOption = new CHtmlOption();
                            chtmlPCData = new CHtmlPCData();
                            choiceBackwardValue = this.getPrevLabel(this.oLastPagePath);
                            chtmlPCData.addCHtmlAttribute(TEXT, choiceBackwardValue);
                            chtmlOption.addCHtmlAttribute("value", choiceBackwardValue);
                            chtmlOption.addCHtmlElement(chtmlPCData);
                            choiceElement = CHtmlAmlElementUtils.getChildContainerCHtmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, chtmlOption);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                    if (!this.bClosingChoiceFormCall) {
                        try {
                            chtmlOption = new CHtmlOption();
                            chtmlPCData = new CHtmlPCData();
                            choiceForwardValue = this.getNextLabel(this.oLastPagePath);
                            chtmlPCData.addCHtmlAttribute(TEXT, choiceForwardValue);
                            chtmlOption.addCHtmlAttribute("value", choiceForwardValue);
                            chtmlOption.addCHtmlElement(chtmlPCData);
                            choiceElement = CHtmlAmlElementUtils.getChildContainerCHtmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, chtmlOption);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                }
                String currURL = null;
                boolean originalUrl = true;
                if (!this.bClosingChoiceFormCall) {
                    currURL = pageAllocator.getCurrentPageURL();
                    originalUrl = false;
                } else if (this.isDiffCanonicalPaths(currentFormPath, this.oLastFormPath)) {
                    currURL = this.getFormURL(this.oLastFormPath);
                } else {
                    currURL = pageAllocator.getNextPageURL();
                    originalUrl = false;
                }
                String sCurrURL = null;
                if (isLastChoiceFormPresent) {
                    String modifier;
                    CHtmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new CHtmlAmlGetDynamicURLHandlerEvent();
                    this.oHandlerManager.postEventNow(getDynamicURLEvent);
                    String dynamicURL = getDynamicURLEvent.getURL();
                    String dCurrURL = null;
                    String id = null;
                    if (!this.bClosingChoiceFormCall) {
                        CHtmlAmlGetPreviousPageIDHandlerEvent getPreviousPageIDEvent = new CHtmlAmlGetPreviousPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getPreviousPageIDEvent);
                        id = getPreviousPageIDEvent.getID();
                    } else {
                        CHtmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new CHtmlAmlGetCurrentPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                        id = getCurrentPageIDEvent.getID();
                    }
                    dCurrURL = dynamicURL + id;
                    FormRedirector formRedirector = new FormRedirector();
                    formRedirector.setDynamicURL(dCurrURL);
                    if (isSecondLastChoiceFormPresent) {
                        modifier = choiceName + EQUALS + choiceBackwardValue;
                        formRedirector.addModifier(modifier, this.oSecondLastChoiceFormURL);
                    }
                    if (!this.bClosingChoiceFormCall) {
                        modifier = choiceName + EQUALS + choiceForwardValue;
                        formRedirector.addModifier(modifier, currURL);
                    }
                    this.oLastFormRedirectors.addElement(formRedirector);
                    sCurrURL = currURL;
                    currURL = dCurrURL;
                }
                XmlElementInterface topStyleElement = CHtmlAmlElementUtils.getTopStyleElement(this.oHandlerManager, this.oLastFormPath);
                XmlElementInterface formElement = CHtmlAmlElementUtils.getFirstMatchingChild(this.oHandlerManager, topStyleElement, FORM_NAME);
                CHtmlElement chtmlElement = CHtmlAmlElementUtils.getCHtmlElement(this.oHandlerManager, this.oLastFormPath, formElement);
                try {
                    this.setFormURL(this.oLastFormPath, currURL, formNumber);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                if (isLastChoiceFormPresent) {
                    this.oSecondLastChoiceFormURL = pageAllocator.getPreviousPageURL();
                    currURL = sCurrURL;
                }
                if (isLastChoiceFormPresent) {
                    boolean closeRedirection;
                    AmlPathInterface currentChoiceFormPath = null;
                    if (currentAmlPath != null) {
                        currentChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, CHOICE);
                    }
                    if (closeRedirection = this.isDiffCanonicalPaths(currentChoiceFormPath, lastChoiceFormPath)) {
                        if (!this.bClosingChoiceFormCall) {
                            this.bClosingChoiceFormCall = true;
                            this.checkLinkForm(currentAmlPath);
                            this.oLastFormPath = null;
                            lastFormPathSet = true;
                            this.bPFClosingChoiceForm = true;
                            this.bClosingChoiceFormCall = false;
                        }
                        if (this.bClosingChoiceFormCall) {
                            int numberElements = this.oLastFormRedirectors.size();
                            int i = 0;
                            while (i < numberElements) {
                                FormRedirector formRedirector = (FormRedirector)this.oLastFormRedirectors.elementAt(i);
                                formRedirector.setOriginalURL(currURL);
                                formRedirectionInfo.addFormRedirector(formRedirector);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("formRedirector = " + formRedirector.toString());
                                }
                                ++i;
                            }
                            this.oLastFormRedirectors.clear();
                            this.oSecondLastChoiceFormURL = null;
                        }
                    }
                }
            }
            if (!this.bClosingChoiceFormCall && this.isDiffCanonicalPaths(currentFormPath, this.oLastFormProcessedPath)) {
                AmlPathInterface destPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
                String destURL = this.getFormURL(destPath);
                CHtmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new CHtmlAmlGetDynamicURLHandlerEvent();
                this.oHandlerManager.postEventNow(getDynamicURLEvent);
                String dynamicURL = getDynamicURLEvent.getURL();
                CHtmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new CHtmlAmlGetCurrentPageIDHandlerEvent();
                this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                String id = getCurrentPageIDEvent.getID();
                String dDestURL = dynamicURL + id + SUBMIT_IDENTIFIER;
                FormRedirector formRedirector = new FormRedirector();
                formRedirector.setDynamicURL(dDestURL);
                formRedirector.setOriginalURL(destURL);
                formRedirectionInfo.addFormRedirector(formRedirector);
                this.setFormURL(destPath, dDestURL, formNumber);
                ++this.iFormNumber;
            }
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("*****oLastFormPath = " + this.oLastFormPath);
            }
            if (!lastFormPathSet) {
                this.oLastFormPath = currentFormPath;
            }
            this.oLastFormProcessedPath = currentFormPath;
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private void setFormURL(AmlPathInterface formPath, String formURL, int formNumber) throws HandlerError {
        try {
            AxmlElement formAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
            if (formAmlElement instanceof AxmlForm) {
                String methodType = formAmlElement.getAxmlAttributeValue("method");
                String numURL = "agf=" + formNumber;
                formURL = this.composeURL(formURL, numURL);
                this.setFormNativeURL(formPath, formURL);
            }
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void setFormNativeURL(AmlPathInterface formPath, String formURL) throws HandlerError {
        try {
            CHtmlAmlSetFormUrlHandletEvent setUrlEvent = new CHtmlAmlSetFormUrlHandletEvent(formPath, formURL, false);
            this.oHandlerManager.postEventNow(setUrlEvent);
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
    }

    private String composeURL(String currURL, String paramURL) {
        if (paramURL != null) {
            currURL = currURL.indexOf("?") == -1 ? currURL + "?" : currURL + "&";
            currURL = currURL + paramURL;
        }
        return currURL;
    }

    private String getFormURL(AmlPathInterface amlPath) throws HandlerError {
        String url = null;
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            url = amlElement.getAxmlAttributeValue("url");
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
        return url;
    }

    private void conditionalError(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            throw (HandlerError)ex;
        }
        throw new CHtmlAmlHandlerError(ex);
    }

    private boolean isDiffCanonicalPaths(AmlPathInterface currPath, AmlPathInterface prevPath) {
        boolean different = false;
        if (prevPath != null) {
            if (currPath == null) {
                different = true;
            } else if (!currPath.getCanonicalPath().equals(prevPath.getCanonicalPath())) {
                different = true;
            }
        }
        return different;
    }
}

