/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlContainer;
import com.aligo.chtml.CHtmlDiv;
import com.aligo.chtml.CHtmlElementCollection;
import com.aligo.chtml.exceptions.CHtmlAttributeCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementIndexOutOfBoundsException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.CHtmlAmlPathHandler;
import com.aligo.modules.chtml.errors.CHtmlAmlHandlerError;
import com.aligo.modules.chtml.events.CHtmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlCreateNextElementHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetControlMenuParentContainerHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.chtml.exceptions.CHtmlAmlInsufficientMemoryException;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.chtml.util.exceptions.CHtmlAmlGetRootElementFailedException;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlAmlControlMenuHandler
extends CHtmlAmlPathHandler {
    private static final String SPACE = "&nbsp;";
    private Hashtable oControlMenuPresentTable = new Hashtable();
    private Hashtable oControlMenuContainerTable = new Hashtable();
    private Hashtable oCMTBNeedCopyTable = new Hashtable();
    private boolean bNoHandleCNEHandlerEvent = false;
    private Hashtable oNumberCMAddedTable = new Hashtable();

    private boolean isControlMenuPresent(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bPresent;
        boolean present = false;
        if (currentAmlPath != null && (bPresent = (Boolean)this.oControlMenuPresentTable.get(pathString = currentAmlPath.toString())) != null) {
            present = bPresent;
        }
        return present;
    }

    private void setControlMenuPresent(AmlPathInterface currentAmlPath, boolean present) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuPresentTable.put(pathString, new Boolean(present));
    }

    private CHtmlElement getControlMenuContainer(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        CHtmlElement chtmlElement = (CHtmlElement)this.oControlMenuContainerTable.get(pathString);
        return chtmlElement;
    }

    private void setControlMenuContainer(AmlPathInterface currentAmlPath, CHtmlElement chtmlElement) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuContainerTable.put(pathString, chtmlElement);
    }

    private boolean doesCMTBNeedCopy(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bNeedCopy;
        boolean needCopy = false;
        if (currentAmlPath != null && (bNeedCopy = (Boolean)this.oCMTBNeedCopyTable.get(pathString = currentAmlPath.toString())) != null) {
            needCopy = bNeedCopy;
        }
        return needCopy;
    }

    private void setCMTBNeedCopy(AmlPathInterface currentAmlPath, boolean needCopy) {
        String pathString = currentAmlPath.toString();
        this.oCMTBNeedCopyTable.put(pathString, new Boolean(needCopy));
    }

    private int getNumberCMAdded(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        int numAdded = 0;
        Integer inNumAdded = (Integer)this.oNumberCMAddedTable.get(pathString);
        if (inNumAdded != null) {
            numAdded = inNumAdded;
        }
        return numAdded;
    }

    private void incNumberCMAdded(AmlPathInterface currentAmlPath) {
        int numAdded = this.getNumberCMAdded(currentAmlPath);
        String pathString = currentAmlPath.toString();
        this.oNumberCMAddedTable.put(pathString, new Integer(++numAdded));
    }

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddControlMenuElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetControlMenuParentContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlCreateNextElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlIsPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlPathRelevance() {
        long currentCHtmlAmlPathRelevance;
        block21: {
            currentCHtmlAmlPathRelevance = 0L;
            if (this.oCurrentEvent instanceof CHtmlAmlAddChildContainerHandlerEvent) {
                try {
                    AmlPathInterface parentAmlPath;
                    AxmlElement parentAmlElement;
                    AmlPathInterface currentAmlPath = ((CHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) instanceof AxmlPage) {
                        currentCHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof CHtmlAmlControlMenuOffsetHandlerEvent) {
                currentCHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof CHtmlAmlAddControlMenuElementHandlerEvent) {
                currentCHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof CHtmlAmlGetControlMenuParentContainerHandlerEvent) {
                currentCHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof CHtmlAmlCreateNextElementHandlerEvent) {
                try {
                    if (!this.bNoHandleCNEHandlerEvent) {
                        int numberCM;
                        AmlPathInterface parentAmlPath;
                        int numCMAdded;
                        CHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (CHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
                        AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                        if (amlElement instanceof AxmlControlMenu && (numCMAdded = this.getNumberCMAdded(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) == (numberCM = this.getTotalControlMenus(parentAmlPath)) && this.doesCMTBNeedCopy(parentAmlPath)) {
                            currentCHtmlAmlPathRelevance = 30L;
                        }
                        break block21;
                    }
                    this.bNoHandleCNEHandlerEvent = false;
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof CHtmlAmlIsPersistentHandlerEvent) {
                try {
                    CHtmlAmlIsPersistentHandlerEvent isPersistentElementEvent = (CHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent;
                    AmlPathInterface currentAmlPath = isPersistentElementEvent.getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu) {
                        currentCHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return currentCHtmlAmlPathRelevance;
    }

    private int getTotalControlMenus(AmlPathInterface parentAmlPath) throws CHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        int numberMenus = 0;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
        int numberChildren = amlElement.getNumberElements();
        int i = 0;
        while (i < numberChildren) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws CHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        AmlPathInterface parentAmlPath;
        AxmlElement amlElement;
        int numberChildren;
        int numberMenus = 0;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        if (childIndex > (numberChildren = (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))).getNumberElements()) - 1) {
            childIndex = numberChildren - 1;
        }
        int i = 0;
        while (i < childIndex) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private void createControlMenuContainer(AmlPathInterface amlPath, CHtmlElement chtmlElement) throws HandlerError {
        CHtmlElement controlMenuContainer = null;
        boolean oneElement = false;
        if (chtmlElement instanceof CHtmlElementCollection) {
            int numberElements = chtmlElement.getNumberElements();
            if (numberElements > 1) {
                controlMenuContainer = new CHtmlElementCollection();
                int i = 0;
                while (i < numberElements) {
                    try {
                        CHtmlElement cmParentContainer = chtmlElement.chtmlElementAt(i);
                        CHtmlElement tCMContainer = this.createCMContainerElement(amlPath, cmParentContainer);
                        controlMenuContainer.addCHtmlElement(tCMContainer);
                    }
                    catch (CHtmlElementIndexOutOfBoundsException je) {
                    }
                    catch (CHtmlElementCannotBeAddedException je) {
                        // empty catch block
                    }
                    ++i;
                }
                this.setCMTBNeedCopy(amlPath, true);
            } else {
                try {
                    chtmlElement = chtmlElement.chtmlElementAt(0);
                    oneElement = true;
                }
                catch (CHtmlElementIndexOutOfBoundsException je) {}
            }
        } else {
            oneElement = true;
        }
        if (oneElement) {
            controlMenuContainer = this.createCMContainerElement(amlPath, chtmlElement);
        }
        this.setControlMenuPresent(amlPath, true);
        this.setControlMenuContainer(amlPath, controlMenuContainer);
    }

    private CHtmlElement createCMContainerElement(AmlPathInterface amlPath, CHtmlElement chtmlElement) throws HandlerError {
        CHtmlDiv chtmlDiv = new CHtmlDiv();
        try {
            CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, amlPath, chtmlElement, chtmlDiv, 0);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        return chtmlDiv;
    }

    private CHtmlElement composeSpace() {
        CHtmlContainer chtmlContainer = new CHtmlContainer();
        try {
            chtmlContainer.addCHtmlAttribute("text", SPACE);
        }
        catch (CHtmlAttributeCannotBeAddedException cHtmlAttributeCannotBeAddedException) {
            // empty catch block
        }
        return chtmlContainer;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof CHtmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof CHtmlAmlCreateNextElementHandlerEvent) {
            CHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (CHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
            boolean memoryError = false;
            try {
                int numberElements;
                CHtmlElement cmContainer;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                if (this.doesCMTBNeedCopy(parentAmlPath) && (cmContainer = this.getControlMenuContainer(parentAmlPath)) instanceof CHtmlElementCollection && (numberElements = cmContainer.getNumberElements()) > 1) {
                    CHtmlElement filledECMContainer = cmContainer.chtmlElementAt(0);
                    int i = 1;
                    while (i < numberElements) {
                        CHtmlElement eCMContainer = cmContainer.chtmlElementAt(i);
                        int numberChildren = filledECMContainer.getNumberElements();
                        int j = 0;
                        while (j < numberChildren) {
                            CHtmlElement childCHtmlElement = filledECMContainer.chtmlElementAt(j);
                            CHtmlElement clChildCHtmlElement = childCHtmlElement.cloneCHtmlElement();
                            CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, parentAmlPath, eCMContainer, clChildCHtmlElement);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof CHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.bNoHandleCNEHandlerEvent = true;
            if (memoryError) {
                CHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new CHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                CHtmlAmlCreateNextElementHandlerEvent postAgainCNEEvent = new CHtmlAmlCreateNextElementHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(postAgainCNEEvent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof CHtmlAmlAddChildContainerHandlerEvent) {
            try {
                int numberElements;
                CHtmlAmlAddChildContainerHandlerEvent chtmlAmlAddChildContainerHandlerEvent = (CHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
                CHtmlElement childCHtmlElement = chtmlAmlAddChildContainerHandlerEvent.getCHtmlElement();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (!(amlElement instanceof AxmlControlMenu)) return;
                boolean firstControlMenu = false;
                if (!this.isControlMenuPresent(parentAmlPath)) {
                    CHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new CHtmlAmlGetControlMenuParentContainerHandlerEvent(this.oCurrentAmlPath);
                    this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                    CHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getCHtmlElement();
                    this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                    firstControlMenu = true;
                }
                CHtmlElement chtmlElement = this.getControlMenuContainer(parentAmlPath);
                int childIndex = chtmlAmlAddChildContainerHandlerEvent.getChildIndex();
                if (chtmlElement instanceof CHtmlElementCollection && (numberElements = chtmlElement.getNumberElements()) >= 1) {
                    chtmlElement = chtmlElement.chtmlElementAt(0);
                }
                this.incNumberCMAdded(parentAmlPath);
                this.addCMElement(parentAmlPath, firstControlMenu, chtmlElement, childCHtmlElement, childIndex);
                return;
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof CHtmlAmlInsufficientMemoryException)) return;
                throw he;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (this.oCurrentEvent instanceof CHtmlAmlControlMenuOffsetHandlerEvent) {
            CHtmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (CHtmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int childIndex = controlMenuOffsetEvent.getChildIndex();
            int offsetChildIndex = -1;
            try {
                AmlPathInterface parentAmlPath;
                if (this.oCurrentAmlPath != null && this.isControlMenuPresent(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath))) {
                    int numberControlMenus = this.getNumberControlMenus(this.oCurrentAmlPath);
                    offsetChildIndex = childIndex - numberControlMenus;
                }
            }
            catch (Exception ex) {
                offsetChildIndex = 0;
            }
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
            return;
        }
        if (this.oCurrentEvent instanceof CHtmlAmlAddControlMenuElementHandlerEvent) {
            CHtmlElement chtmlElement;
            CHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = (CHtmlAmlAddControlMenuElementHandlerEvent)this.oCurrentEvent;
            CHtmlElement childCHtmlElement = addControlMenuElementEvent.getCHtmlElement();
            AmlPathInterface parentAmlPath = this.oCurrentAmlPath;
            boolean firstControlMenu = false;
            if (!this.isControlMenuPresent(parentAmlPath)) {
                CHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new CHtmlAmlGetControlMenuParentContainerHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                CHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getCHtmlElement();
                this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                firstControlMenu = true;
            }
            if ((chtmlElement = this.getControlMenuContainer(parentAmlPath)) instanceof CHtmlElementCollection) {
                int numberElements = chtmlElement.getNumberElements();
                int i = 0;
                while (i < numberElements) {
                    try {
                        CHtmlElement containerElement = chtmlElement.chtmlElementAt(i);
                        this.addCMNMCElement(parentAmlPath, firstControlMenu, containerElement, childCHtmlElement);
                    }
                    catch (CHtmlElementIndexOutOfBoundsException je) {
                        // empty catch block
                    }
                    ++i;
                }
                return;
            }
            this.addCMNMCElement(parentAmlPath, firstControlMenu, chtmlElement, childCHtmlElement);
            return;
        }
        if (this.oCurrentEvent instanceof CHtmlAmlGetControlMenuParentContainerHandlerEvent) {
            CHtmlAmlGetControlMenuParentContainerHandlerEvent controlMenuParentContainerEvent = (CHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent;
            CHtmlElement chtmlElement = null;
            try {
                AmlPathInterface currentAmlPath = ((CHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                chtmlElement = CHtmlAmlElementUtils.getChildContainerCHtmlElement(this.oHandlerManager, parentAmlPath);
            }
            catch (HandlerError he) {
                throw he;
            }
            catch (Exception ex) {
                throw new CHtmlAmlHandlerError(ex);
            }
            controlMenuParentContainerEvent.setCHtmlElement(chtmlElement);
            return;
        }
        if (!(this.oCurrentEvent instanceof CHtmlAmlIsPersistentHandlerEvent)) return;
        ((CHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent).setPersistent(true);
    }

    private void addCMElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, CHtmlElement chtmlElement, CHtmlElement childCHtmlElement, int childIndex) throws HandlerError {
        if (!firstControlMenu) {
            CHtmlElement spaceElement = this.composeSpace();
            CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, parentAmlPath, chtmlElement, spaceElement, childIndex);
            if (childIndex != -1) {
                ++childIndex;
            }
        }
        CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, parentAmlPath, chtmlElement, childCHtmlElement, childIndex);
    }

    private void addCMNMCElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, CHtmlElement chtmlElement, CHtmlElement childCHtmlElement) throws HandlerError {
        try {
            if (!firstControlMenu) {
                CHtmlElement spaceElement = this.composeSpace();
                CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, parentAmlPath, chtmlElement, spaceElement);
            }
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        try {
            CHtmlAmlElementUtils.addCHtmlElement(this.oHandlerManager, parentAmlPath, chtmlElement, childCHtmlElement);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
    }
}

