/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules;

import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;
import java.util.Enumeration;
import java.util.Vector;

public class Path
implements PathInterface {
    Vector oPathContainer;

    public Path() {
        this.oPathContainer = new Vector();
    }

    public Path(Vector pathContainer) {
        this.setPathContainer(pathContainer);
    }

    public void setPathContainer(Vector pathContainer) {
        if (pathContainer != null) {
            this.oPathContainer = pathContainer;
        }
    }

    public void addPathComponent(PathComponentInterface component) {
        this.oPathContainer.addElement(component);
    }

    public void addPathComponentAt(PathComponentInterface component, int index) throws PathIndexOutOfBoundsException {
        try {
            this.oPathContainer.insertElementAt(component, index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new PathIndexOutOfBoundsException(ae.toString());
        }
    }

    public Enumeration getPathComponents() {
        return this.oPathContainer.elements();
    }

    public PathComponentInterface getPathComponentAt(int i) throws PathIndexOutOfBoundsException {
        try {
            return (PathComponentInterface)this.oPathContainer.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new PathIndexOutOfBoundsException(ae.toString());
        }
    }

    public PathComponentInterface getFirstPathComponent() throws PathIndexOutOfBoundsException {
        return this.getPathComponentAt(0);
    }

    public PathInterface getNextPath() {
        Path remainingPath = new Path();
        int numberElements = this.oPathContainer.size();
        int i = 1;
        while (i < numberElements) {
            PathComponent component = (PathComponent)this.oPathContainer.elementAt(i);
            remainingPath.addPathComponent(component);
            ++i;
        }
        return remainingPath;
    }

    public boolean hasMoreComponents() {
        boolean moreComponents = false;
        int numberElements = this.oPathContainer.size();
        if (numberElements > 0) {
            moreComponents = true;
        }
        return moreComponents;
    }

    public int getNumberComponents() {
        return this.oPathContainer.size();
    }
}

