/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules;

import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.exceptions.EventIndexOutOfBoundsException;
import com.aligo.modules.interfaces.EventRepositoryInterface;
import java.util.Enumeration;
import java.util.Vector;

public class EventRepository
implements EventRepositoryInterface {
    Vector oEventContainer = new Vector();

    public void addEvent(AligoEventInterface event) {
        this.oEventContainer.addElement(event);
    }

    public void removeEvent(AligoEventInterface event) {
        this.oEventContainer.removeElement(event);
    }

    public AligoEventInterface peekLastEvent() {
        AligoEventInterface currentEvent = null;
        int numberEvents = this.oEventContainer.size();
        int currentIndex = numberEvents - 1;
        if (numberEvents > 0) {
            currentEvent = (AligoEventInterface)this.oEventContainer.elementAt(currentIndex);
        }
        return currentEvent;
    }

    public Enumeration peekEvents() {
        return this.oEventContainer.elements();
    }

    public AligoEventInterface peekEventAt(int i) throws EventIndexOutOfBoundsException {
        try {
            return (AligoEventInterface)this.oEventContainer.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new EventIndexOutOfBoundsException(ae.toString());
        }
    }

    public boolean hasMoreEvents() {
        boolean moreEvents = false;
        int numberEvents = this.oEventContainer.size();
        if (numberEvents > 0) {
            moreEvents = true;
        }
        return moreEvents;
    }

    public AligoEventInterface getFirstEvent() {
        AligoEventInterface firstEvent = null;
        if (this.hasMoreEvents()) {
            firstEvent = (AligoEventInterface)this.oEventContainer.elementAt(0);
            this.oEventContainer.remove(firstEvent);
        }
        return firstEvent;
    }

    public void clearEvents() {
        this.oEventContainer.removeAllElements();
    }

    public int numberEvents() {
        return this.oEventContainer.size();
    }
}

