/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.jhtml;

import com.aligo.jhtml.JHtmlAttributes;
import com.aligo.jhtml.JHtmlContainer;
import com.aligo.jhtml.JHtmlElementCollection;
import com.aligo.jhtml.exceptions.JHtmlAttributeCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementCloneFailedException;
import com.aligo.jhtml.exceptions.JHtmlElementIndexOutOfBoundsException;
import com.aligo.jhtml.exceptions.JHtmlElementNotFoundException;
import com.aligo.jhtml.exceptions.JHtmlTextCannotBeResetException;
import com.aligo.jhtml.exceptions.JHtmlTextCannotBeSetException;
import com.aligo.jhtml.exceptions.JHtmlTextNotSetException;
import com.aligo.jhtml.interfaces.JHtmlAttributeInterface;
import com.aligo.jhtml.interfaces.JHtmlContainerInterface;
import com.aligo.jhtml.interfaces.JHtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JHtmlBaseElement
implements JHtmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String JHTML_BOOLEAN = "boolean";
    public static final String JHTML_CDATA = "cdata";
    public static final String JHTML_EMPH = "emph";
    public static final String JHTML_FLOW = "flow";
    public static final String JHTML_HREF = "href";
    public static final String JHTML_ID = "id";
    public static final String JHTML_INLINE = "inline";
    public static final String JHTML_LAYOUT = "layout";
    public static final String JHTML_LENGTH = "length";
    public static final String JHTML_NUMBER = "number";
    public static final String JHTML_PASSWORD = "password";
    public static final String JHTML_PCDATA = "pcdata";
    public static final String JHTML_TEXT = "text";
    public static final String JHTML_TOKEN = "nmtoken";
    public static final String JHTML_VDATA = "vdata";
    public static final String[] SJHtmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String JHTML_JHTML = "JHtml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    protected boolean bContentsWithTag = false;
    private String SName = this.getName();
    private String sContents = null;
    protected JHtmlElementCollection elements = new JHtmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected JHtmlAttributeInterface oAttributes = new JHtmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private JHtmlElement oJHtmlParentElement;

    public JHtmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "JHtmlBaseElement";
    }

    public String getXmlID() {
        return JHTML_JHTML;
    }

    protected void addNCJHtmlElement(JHtmlElement jhtmlElement, int index) throws JHtmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addJHtmlElement(jhtmlElement);
        } else {
            this.elements.addJHtmlElementAt(jhtmlElement, index);
        }
        jhtmlElement.setJHtmlParentElement(this);
    }

    public void addJHtmlElementAt(JHtmlElement jhtmlElement, int index) throws JHtmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = jhtmlElement.getName();
        if (this instanceof JHtmlContainerInterface || jhtmlElement instanceof JHtmlContainerInterface) {
            this.addNCJHtmlElement(jhtmlElement, index);
            JHtmlContainerInterface checkValidElement = null;
            if (this instanceof JHtmlContainerInterface) {
                checkValidElement = (JHtmlContainerInterface)((Object)this);
            } else if (jhtmlElement instanceof JHtmlContainerInterface) {
                checkValidElement = (JHtmlContainerInterface)((Object)jhtmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeJHtmlElement(jhtmlElement);
                }
                catch (JHtmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new JHtmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    JHtmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.jhtmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.jhtmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (JHtmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new JHtmlElementCannotBeAddedException();
            }
            this.addNCJHtmlElement(jhtmlElement, index);
        }
    }

    public void addJHtmlElement(JHtmlElement jhtmlElement) throws JHtmlElementCannotBeAddedException {
        this.addJHtmlElementAt(jhtmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public JHtmlElement jhtmlElementAt(int index) throws JHtmlElementIndexOutOfBoundsException {
        return this.elements.jhtmlElementAt(index);
    }

    public int jhtmlElementIndex(JHtmlElement jhtmlElement) throws JHtmlElementNotFoundException {
        return this.elements.jhtmlElementIndex(jhtmlElement);
    }

    public void removeJHtmlElement(int index) throws JHtmlElementIndexOutOfBoundsException {
        JHtmlElement jhtmlElement = this.jhtmlElementAt(index);
        try {
            this.removeJHtmlElement(jhtmlElement);
        }
        catch (JHtmlElementNotFoundException we) {
            throw new JHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeJHtmlElement(JHtmlElement jhtmlElement) throws JHtmlElementNotFoundException {
        this.elements.removeJHtmlElement(jhtmlElement);
        jhtmlElement.setJHtmlParentElement(null);
    }

    public void removeAll() {
        int numberElements = this.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            try {
                JHtmlElement jhtmlElement = this.jhtmlElementAt(i);
                jhtmlElement.setJHtmlParentElement(null);
            }
            catch (JHtmlElementIndexOutOfBoundsException jHtmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        this.elements.removeAll();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areJHtmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                JHtmlElement containedElement;
                JHtmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.jhtmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (JHtmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.jhtmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (JHtmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (JHtmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addJHtmlAttribute(String name, String value) throws JHtmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new JHtmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getJHtmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeJHtmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeJHtmlAttribute(String name) {
        String value = this.getJHtmlAttributeValue(name);
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areJHtmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + ">\n";
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!endTag.equals(ONCE)) {
            tail = "</" + endTag + GREATERTHAN + NEWLINE;
        }
        return tail;
    }

    public String getBody() {
        String body = ONCE;
        String text = null;
        try {
            text = this.getText();
            if (text != null) {
                body = text;
            }
        }
        catch (JHtmlTextNotSetException we) {
            body = this.elements.getContents();
        }
        return body;
    }

    public String getContents() {
        String contents = ONCE;
        if (this.sContents == null) {
            String body = this.getBody();
            contents = this.getHead() + body + this.getTail();
        } else {
            contents = this.bContentsWithTag ? this.getHead() + this.sContents + this.getTail() : this.sContents;
        }
        return contents;
    }

    public void setContents(String contents) {
        this.sContents = contents;
        this.bContentsWithTag = false;
    }

    public void setContentsWithTag(String contents) {
        this.setContents(contents);
        this.bContentsWithTag = true;
    }

    public void setText(String text) throws JHtmlTextCannotBeSetException {
        throw new JHtmlTextCannotBeSetException();
    }

    public String getText() throws JHtmlTextNotSetException {
        throw new JHtmlTextNotSetException();
    }

    public void resetText() throws JHtmlTextCannotBeResetException {
        throw new JHtmlTextCannotBeResetException();
    }

    public void setJHtmlParentElement(JHtmlElement jhtmlParentElement) {
        this.oJHtmlParentElement = jhtmlParentElement;
    }

    public JHtmlElement getJHtmlParentElement() {
        return this.oJHtmlParentElement;
    }

    public JHtmlElement cloneJHtmlElement() throws JHtmlElementCloneFailedException {
        JHtmlElement cJHtmlElement = null;
        try {
            cJHtmlElement = (JHtmlElement)this.getClass().newInstance();
            Enumeration keys = this.oAttributes.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = this.oAttributes.getValue(name);
                cJHtmlElement.addJHtmlAttribute(name, value);
            }
            try {
                String text = this.getText();
                cJHtmlElement.setText(text);
            }
            catch (JHtmlTextNotSetException je) {
                // empty catch block
            }
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                JHtmlElement childJHtmlElement = this.jhtmlElementAt(i);
                JHtmlElement cChildJHtmlElement = childJHtmlElement.cloneJHtmlElement();
                cJHtmlElement.addJHtmlElement(cChildJHtmlElement);
                ++i;
            }
        }
        catch (JHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new JHtmlElementCloneFailedException(ex.getMessage());
        }
        return cJHtmlElement;
    }

    public static String[] getJHtmlDataTypes() {
        return SJHtmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SJHtmlDataTypes.length && !found) {
            if (dataType.equals(SJHtmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return JHTML_PCDATA;
    }

    private Vector getNonContainerElements(JHtmlElement jhtmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(jhtmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(JHtmlElement jhtmlElement, Vector nonContainerElements) {
        if (jhtmlElement != null) {
            if (jhtmlElement instanceof JHtmlContainer) {
                int numberChildren = jhtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        JHtmlElement childJHtmlElement = jhtmlElement.jhtmlElementAt(i);
                        this.getNonContainerElements(childJHtmlElement, nonContainerElements);
                    }
                    catch (JHtmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(jhtmlElement);
            }
        }
    }
}

