/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.html;

import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCloneFailedException;
import com.aligo.html.exceptions.HtmlElementIndexOutOfBoundsException;
import com.aligo.html.exceptions.HtmlElementNotFoundException;
import com.aligo.html.exceptions.HtmlTextCannotBeResetException;
import com.aligo.html.exceptions.HtmlTextCannotBeSetException;
import com.aligo.html.exceptions.HtmlTextNotSetException;
import com.aligo.html.interfaces.HtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlElementCollection
implements HtmlElement {
    Vector elements = new Vector();

    public String getName() {
        return "HtmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addHtmlElementAt(HtmlElement element, int index) throws HtmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addHtmlElement(HtmlElement element) throws HtmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public HtmlElement htmlElementAt(int loc) throws HtmlElementIndexOutOfBoundsException {
        try {
            return (HtmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new HtmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int htmlElementIndex(HtmlElement htmlElement) throws HtmlElementNotFoundException {
        int index = this.elements.indexOf(htmlElement);
        if (index == -1) {
            throw new HtmlElementNotFoundException();
        }
        return this.elements.indexOf(htmlElement);
    }

    public void removeHtmlElement(int index) throws HtmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new HtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeHtmlElement(HtmlElement htmlElement) throws HtmlElementNotFoundException {
        boolean present = this.elements.remove(htmlElement);
        if (!present) {
            throw new HtmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areHtmlChildrenSane() {
        return true;
    }

    public void addHtmlAttribute(String name, String value) throws HtmlAttributeCannotBeAddedException {
        throw new HtmlAttributeCannotBeAddedException();
    }

    public String getHtmlAttributeValue(String name) {
        return null;
    }

    public String changeHtmlAttribute(String name, String value) {
        return null;
    }

    public void removeHtmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areHtmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        HtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.htmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public String getTail() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getContents() {
        String contents = "";
        HtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.htmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contents = contents + element.getContents();
            ++i;
        }
        return contents;
    }

    public void setContents(String contents) {
    }

    public void setContentsWithTag(String contents) {
    }

    public void setText(String text) throws HtmlTextCannotBeSetException {
        throw new HtmlTextCannotBeSetException();
    }

    public String getText() throws HtmlTextNotSetException {
        throw new HtmlTextNotSetException();
    }

    public void resetText() throws HtmlTextCannotBeResetException {
        throw new HtmlTextCannotBeResetException();
    }

    public void setHtmlParentElement(HtmlElement htmlParentElement) {
    }

    public HtmlElement getHtmlParentElement() {
        return null;
    }

    public HtmlElement cloneHtmlElement() throws HtmlElementCloneFailedException {
        HtmlElement cHtmlElement = null;
        try {
            cHtmlElement = (HtmlElement)this.getClass().newInstance();
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                HtmlElement childHtmlElement = this.htmlElementAt(i);
                HtmlElement cChildHtmlElement = childHtmlElement.cloneHtmlElement();
                cHtmlElement.addHtmlElement(cChildHtmlElement);
                ++i;
            }
        }
        catch (HtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new HtmlElementCloneFailedException(ex.getMessage());
        }
        return cHtmlElement;
    }
}

