/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.html;

import com.aligo.html.HtmlBaseElement;
import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementIndexOutOfBoundsException;
import com.aligo.html.exceptions.HtmlElementNotFoundException;
import com.aligo.html.exceptions.HtmlTextCannotBeSetException;
import com.aligo.html.exceptions.HtmlTextNotSetException;
import com.aligo.html.interfaces.HtmlContainerInterface;
import com.aligo.html.interfaces.HtmlElement;
import java.util.Hashtable;

public class HtmlContainer
extends HtmlBaseElement
implements HtmlContainerInterface {
    public static final String HTML_TAG = "";
    public static final String HREF = "href";
    public static final String TITLE = "title";
    public static final String XML_LANG = "xml:lang";
    public static final String ID = "id";
    public static final String CLASS = "class";
    public static final String TEXT = "text";
    private static String SName = "HtmlContainer";
    private static Hashtable OChildrenRules = new Hashtable();
    private static Hashtable OAttributeRules = new Hashtable();
    private static String[] ORequiredAttributes = new String[0];

    public String getName() {
        return SName;
    }

    public Hashtable getChildrenRules() {
        return OChildrenRules;
    }

    public Hashtable getAttributeRules() {
        return OAttributeRules;
    }

    public String[] getRequiredAttributes() {
        return ORequiredAttributes;
    }

    public String getStartTag() {
        return HTML_TAG;
    }

    public boolean isAddValid() {
        boolean canAdd;
        block14: {
            canAdd = true;
            HtmlElement htmlParentElement = this.getHtmlParentElement();
            if (htmlParentElement != null) {
                try {
                    HtmlElement cHtmlElement;
                    int addIndex = htmlParentElement.htmlElementIndex(this);
                    if (htmlParentElement instanceof HtmlContainerInterface) {
                        canAdd = ((HtmlContainerInterface)((Object)htmlParentElement)).isAddValid();
                        break block14;
                    }
                    int cindex = 0;
                    try {
                        int numberElements = this.elements.getNumberElements();
                        cindex = 0;
                        while (cindex < numberElements) {
                            cHtmlElement = this.elements.htmlElementAt(cindex);
                            if (addIndex != -1) {
                                htmlParentElement.addHtmlElementAt(cHtmlElement, addIndex + cindex);
                            } else {
                                htmlParentElement.addHtmlElement(cHtmlElement);
                            }
                            ++cindex;
                        }
                    }
                    catch (HtmlElementIndexOutOfBoundsException we) {
                    }
                    catch (HtmlElementCannotBeAddedException we) {
                        canAdd = false;
                    }
                    int i = 0;
                    while (i < cindex) {
                        try {
                            cHtmlElement = this.elements.htmlElementAt(i);
                            htmlParentElement.removeHtmlElement(cHtmlElement);
                            cHtmlElement.setHtmlParentElement(this);
                        }
                        catch (HtmlElementIndexOutOfBoundsException we) {
                        }
                        catch (HtmlElementNotFoundException je) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (HtmlElementNotFoundException je) {
                    je.printStackTrace();
                }
            }
        }
        return canAdd;
    }

    public void addHtmlAttribute(String name, String value) throws HtmlAttributeCannotBeAddedException {
        if (!name.equals(TEXT)) {
            throw new HtmlAttributeCannotBeAddedException();
        }
        this.sText = value;
    }

    public String getText() throws HtmlTextNotSetException {
        if (this.sText != null) {
            return this.sText;
        }
        return super.getText();
    }

    public void setText(String text) throws HtmlTextCannotBeSetException {
        try {
            this.addHtmlAttribute(TEXT, text);
        }
        catch (HtmlAttributeCannotBeAddedException ex) {
            throw new HtmlTextCannotBeSetException();
        }
    }
}

