/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.html;

import com.aligo.html.HtmlAttributes;
import com.aligo.html.HtmlContainer;
import com.aligo.html.HtmlElementCollection;
import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCloneFailedException;
import com.aligo.html.exceptions.HtmlElementIndexOutOfBoundsException;
import com.aligo.html.exceptions.HtmlElementNotFoundException;
import com.aligo.html.exceptions.HtmlTextCannotBeResetException;
import com.aligo.html.exceptions.HtmlTextCannotBeSetException;
import com.aligo.html.exceptions.HtmlTextNotSetException;
import com.aligo.html.interfaces.HtmlAttributeInterface;
import com.aligo.html.interfaces.HtmlContainerInterface;
import com.aligo.html.interfaces.HtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlBaseElement
implements HtmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String HTML_BOOLEAN = "boolean";
    public static final String HTML_CDATA = "cdata";
    public static final String HTML_EMPH = "emph";
    public static final String HTML_FLOW = "flow";
    public static final String HTML_HREF = "href";
    public static final String HTML_ID = "id";
    public static final String HTML_INLINE = "inline";
    public static final String HTML_LAYOUT = "layout";
    public static final String HTML_LENGTH = "length";
    public static final String HTML_NUMBER = "number";
    public static final String HTML_PASSWORD = "password";
    public static final String HTML_PCDATA = "pcdata";
    public static final String HTML_TEXT = "text";
    public static final String HTML_TOKEN = "nmtoken";
    public static final String HTML_VDATA = "vdata";
    public static final String[] SHtmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String HTML_HTML = "Html";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    protected boolean bContentsWithTag = false;
    private String SName = this.getName();
    private String sContents = null;
    protected HtmlElementCollection elements = new HtmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected HtmlAttributeInterface oAttributes = new HtmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private HtmlElement oHtmlParentElement;

    public HtmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "HtmlBaseElement";
    }

    public String getXmlID() {
        return HTML_HTML;
    }

    protected void addNCHtmlElement(HtmlElement htmlElement, int index) throws HtmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addHtmlElement(htmlElement);
        } else {
            this.elements.addHtmlElementAt(htmlElement, index);
        }
        htmlElement.setHtmlParentElement(this);
    }

    public void addHtmlElementAt(HtmlElement htmlElement, int index) throws HtmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = htmlElement.getName();
        if (this instanceof HtmlContainerInterface || htmlElement instanceof HtmlContainerInterface) {
            this.addNCHtmlElement(htmlElement, index);
            HtmlContainerInterface checkValidElement = null;
            if (this instanceof HtmlContainerInterface) {
                checkValidElement = (HtmlContainerInterface)((Object)this);
            } else if (htmlElement instanceof HtmlContainerInterface) {
                checkValidElement = (HtmlContainerInterface)((Object)htmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeHtmlElement(htmlElement);
                }
                catch (HtmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new HtmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    HtmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.htmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.htmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (HtmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new HtmlElementCannotBeAddedException();
            }
            this.addNCHtmlElement(htmlElement, index);
        }
    }

    public void addHtmlElement(HtmlElement htmlElement) throws HtmlElementCannotBeAddedException {
        this.addHtmlElementAt(htmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public HtmlElement htmlElementAt(int index) throws HtmlElementIndexOutOfBoundsException {
        return this.elements.htmlElementAt(index);
    }

    public int htmlElementIndex(HtmlElement htmlElement) throws HtmlElementNotFoundException {
        return this.elements.htmlElementIndex(htmlElement);
    }

    public void removeHtmlElement(int index) throws HtmlElementIndexOutOfBoundsException {
        HtmlElement htmlElement = this.htmlElementAt(index);
        try {
            this.removeHtmlElement(htmlElement);
        }
        catch (HtmlElementNotFoundException we) {
            throw new HtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeHtmlElement(HtmlElement htmlElement) throws HtmlElementNotFoundException {
        this.elements.removeHtmlElement(htmlElement);
        htmlElement.setHtmlParentElement(null);
    }

    public void removeAll() {
        int numberElements = this.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            try {
                this.removeHtmlElement(i);
            }
            catch (HtmlElementIndexOutOfBoundsException htmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areHtmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                HtmlElement containedElement;
                HtmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.htmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (HtmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.htmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (HtmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (HtmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addHtmlAttribute(String name, String value) throws HtmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new HtmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getHtmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeHtmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeHtmlAttribute(String name) {
        String value = this.getHtmlAttributeValue(name);
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areHtmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!(endTag.equals(ONCE) || this.elements.getNumberElements() == 0 && this.sContents == null)) {
            tail = "</" + endTag + GREATERTHAN;
        }
        return tail;
    }

    public String getBody() {
        String body = ONCE;
        String text = null;
        try {
            text = this.getText();
            if (text != null) {
                body = text;
            }
        }
        catch (HtmlTextNotSetException we) {
            body = this.elements.getContents();
        }
        return body;
    }

    public String getContents() {
        String contents = ONCE;
        if (this.sContents == null) {
            String body = this.getBody();
            contents = this.getHead() + body + this.getTail();
        } else {
            contents = this.bContentsWithTag ? this.getHead() + this.sContents + this.getTail() : this.sContents;
        }
        return contents;
    }

    public void setContents(String contents) {
        this.sContents = contents;
        this.bContentsWithTag = false;
    }

    public void setContentsWithTag(String contents) {
        this.setContents(contents);
        this.bContentsWithTag = true;
    }

    public void setText(String text) throws HtmlTextCannotBeSetException {
        throw new HtmlTextCannotBeSetException();
    }

    public String getText() throws HtmlTextNotSetException {
        throw new HtmlTextNotSetException();
    }

    public void resetText() throws HtmlTextCannotBeResetException {
        throw new HtmlTextCannotBeResetException();
    }

    public void setHtmlParentElement(HtmlElement htmlParentElement) {
        this.oHtmlParentElement = htmlParentElement;
    }

    public HtmlElement getHtmlParentElement() {
        return this.oHtmlParentElement;
    }

    public HtmlElement cloneHtmlElement() throws HtmlElementCloneFailedException {
        HtmlElement cHtmlElement = null;
        try {
            cHtmlElement = (HtmlElement)this.getClass().newInstance();
            Enumeration keys = this.oAttributes.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = this.oAttributes.getValue(name);
                cHtmlElement.addHtmlAttribute(name, value);
            }
            try {
                String text = this.getText();
                cHtmlElement.setText(text);
            }
            catch (HtmlTextNotSetException je) {
                // empty catch block
            }
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                HtmlElement childHtmlElement = this.htmlElementAt(i);
                HtmlElement cChildHtmlElement = childHtmlElement.cloneHtmlElement();
                cHtmlElement.addHtmlElement(cChildHtmlElement);
                ++i;
            }
        }
        catch (HtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new HtmlElementCloneFailedException(ex.getMessage());
        }
        return cHtmlElement;
    }

    public static String[] getHtmlDataTypes() {
        return SHtmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SHtmlDataTypes.length && !found) {
            if (dataType.equals(SHtmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return HTML_PCDATA;
    }

    private Vector getNonContainerElements(HtmlElement htmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(htmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(HtmlElement htmlElement, Vector nonContainerElements) {
        if (htmlElement != null) {
            if (htmlElement instanceof HtmlContainer) {
                int numberChildren = htmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        HtmlElement childHtmlElement = htmlElement.htmlElementAt(i);
                        this.getNonContainerElements(childHtmlElement, nonContainerElements);
                    }
                    catch (HtmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(htmlElement);
            }
        }
    }
}

