/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlGridBagConstraints;
import com.aligo.aml.AmlImage;
import com.aligo.aml.AmlOrderedConstraints;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.AmlText;
import com.aligo.aml.base.AmlTextAreaElement;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;

public class AmlTextArea
extends AmlTextAreaElement {
    private AxmlTextArea axmlTextArea_ = new AxmlTextArea();
    private AxmlText axmlText_;

    public AmlTextArea() {
    }

    public AmlTextArea(String name, String value) throws AttributeCannotBeAddedException {
        this.setValue(value);
        this.setName(name);
    }

    public AmlTextArea(String name) throws AttributeCannotBeAddedException {
        this.setName(name);
    }

    public void setName(String name) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("name", name);
    }

    public void setValue(String value) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("value", value);
    }

    public void setWidth(int width) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("width", new Integer(width).toString());
    }

    public void setWidth(String width) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("width", width);
    }

    public void setHeight(int height) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("height", new Integer(height).toString());
    }

    public void setHeight(String height) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("height", height);
    }

    public void setFormat(String format) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("format", format);
    }

    public void setMaxChars(int maxChars) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("maxchars", new Integer(maxChars).toString());
    }

    public void setPersist(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("persist", new Boolean(flag).toString());
    }

    public void setBold(boolean isBold) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("bold", new Boolean(isBold).toString());
    }

    public void setItalics(boolean isItalics) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("italics", new Boolean(isItalics).toString());
    }

    public void setUnderline(boolean isUnderline) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("underline", new Boolean(isUnderline).toString());
    }

    public void setTextSize(String textSize) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        if (textSize.equals("big") || textSize.equals("small")) {
            this.axmlText_.addAxmlAttribute("textsize", textSize);
        } else {
            this.axmlText_.addAxmlAttribute("textsize", "normal");
        }
    }

    public void setView(String viewOption) throws AttributeCannotBeAddedException {
        if (viewOption.equals("hidden") || viewOption.equals("none")) {
            this.axmlTextArea_.addAxmlAttribute("view", viewOption);
        } else {
            this.axmlText_.addAxmlAttribute("view", "show");
        }
    }

    public void setAsNumeric() throws AttributeCannotBeAddedException {
        this.setFormat("numeric");
    }

    public void setAsAlphaNumeric() throws AttributeCannotBeAddedException {
        this.setFormat("alphanumeric");
    }

    public void setAsLocalizedAlphaNumeric() throws AttributeCannotBeAddedException {
        this.setFormat("localizedalphanumeric");
    }

    public void setAsAlphaNumericUpperCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphanumericuppercase");
    }

    public void setAsAlphaNumericLowerCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphanumericlowercase");
    }

    public void setAsAlphaOnlyUpperCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphaonlyuppercase");
    }

    public void setAsAlphaOnlyLowerCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphaonlylowercase");
    }

    public void setAudioText(String audioText) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text", audioText);
    }

    public void setAudioTextUrl(String audioTextUrl) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text_src", audioTextUrl);
    }

    public void setAudioGrammarUrl(String audioGrammarUrl) throws AttributeCannotBeAddedException {
        this.axmlTextArea_.addAxmlAttribute("audio_grammar_src", audioGrammarUrl);
    }

    public void setText(String text) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.axmlText_ = new AxmlText();
            try {
                this.axmlTextArea_.addAxmlElement(this.axmlText_);
            }
            catch (ElementCannotBeAddedException ex) {
                throw new AttributeCannotBeAddedException();
            }
        }
        this.axmlText_.addAxmlAttribute("text", text);
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlTextArea_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlTextArea_.addExtension(amlStyle.getExtensionObject());
    }

    public void addAmlText(AmlText amlText) throws ElementCannotBeAddedException {
        this.axmlTextArea_.addAxmlElement(amlText.getAxmlElement());
    }

    public void addAmlImage(AmlImage amlImage) throws ElementCannotBeAddedException {
        this.axmlTextArea_.addAxmlElement(amlImage.getAxmlElement());
    }

    public AxmlElement getAxmlElement() {
        return this.axmlTextArea_;
    }

    public void addAmlOrderedConstraints(AmlOrderedConstraints amlOrderedConstraints) throws ElementCannotBeAddedException {
        this.axmlTextArea_.addExtension(amlOrderedConstraints.getExtensionObject());
    }

    public void addAmlGridBagConstraints(AmlGridBagConstraints amlGridBagConstraints) throws ElementCannotBeAddedException {
        this.axmlTextArea_.addExtension(amlGridBagConstraints.getExtensionObject());
    }

    public String getName() {
        return "AmlTextArea";
    }
}

