/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlGridBagConstraints;
import com.aligo.aml.AmlOrderedConstraints;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.base.AmlTextElement;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;
import java.math.BigDecimal;

public class AmlText
extends AmlTextElement {
    private AxmlText axmlText_ = new AxmlText();

    public AmlText() {
    }

    public AmlText(String text) throws AttributeCannotBeAddedException {
        this.setText(text);
    }

    public void setBold(boolean isBold) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("bold", new Boolean(isBold).toString());
    }

    public void setItalics(boolean isItalics) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("italics", new Boolean(isItalics).toString());
    }

    public void setUnderline(boolean isUnderline) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("underline", new Boolean(isUnderline).toString());
    }

    public void setTextSize(String textSize) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        if (textSize.equals("big") || textSize.equals("small")) {
            this.axmlText_.addAxmlAttribute("textsize", textSize);
        } else {
            this.axmlText_.addAxmlAttribute("textsize", "normal");
        }
    }

    public void setHalign(String alignOption) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        if (!(alignOption.equals("center") || alignOption.equals("right") || alignOption.equals("left"))) {
            throw new AttributeCannotBeAddedException("Invalid Attr value: " + alignOption);
        }
        this.axmlText_.addAxmlAttribute("halign", alignOption);
    }

    public void setValign(String alignOption) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        if (!(alignOption.equals("top") || alignOption.equals("middle") || alignOption.equals("bottom"))) {
            throw new AttributeCannotBeAddedException("Invalid Attr value: " + alignOption);
        }
        this.axmlText_.addAxmlAttribute("valign", alignOption);
    }

    public void setFont(String font) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("font", font);
    }

    public void setColor(String color) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("color", color);
    }

    public void setBlink(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("blink", new Boolean(flag).toString());
    }

    public void setMarquee(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("marquee", new Boolean(flag).toString());
    }

    public void setCache(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("cache", new Boolean(flag).toString());
    }

    public void setPersist(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("persist", new Boolean(flag).toString());
    }

    public void setEncode(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlText_.addAxmlAttribute("encode", new Boolean(flag).toString());
    }

    public void setAudioText(String audioText) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text", audioText);
    }

    public void setAudioTextUrl(String audioTextUrl) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text_src", audioTextUrl);
    }

    public void setText(String text) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.axmlText_ = new AxmlText();
        }
        this.axmlText_.addAxmlAttribute("text", text);
    }

    public void setText(BigDecimal textBD) throws AttributeCannotBeAddedException {
        if (textBD == null) {
            this.setText("");
        } else {
            this.setText(textBD.toString());
        }
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlText_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlText_.addExtension(amlStyle.getExtensionObject());
    }

    public AxmlElement getAxmlElement() {
        return this.axmlText_;
    }

    public void addAmlOrderedConstraints(AmlOrderedConstraints amlOrderedConstraints) throws ElementCannotBeAddedException {
        this.axmlText_.addExtension(amlOrderedConstraints.getExtensionObject());
    }

    public void addAmlGridBagConstraints(AmlGridBagConstraints amlGridBagConstraints) throws ElementCannotBeAddedException {
        this.axmlText_.addExtension(amlGridBagConstraints.getExtensionObject());
    }

    public String getName() {
        return "AmlText";
    }
}

