/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlImage;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.AmlText;
import com.aligo.aml.base.AmlTableHeadElement;
import com.aligo.axml.AxmlTableCol;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;

public class AmlTableHead
extends AmlTableHeadElement {
    private AxmlTableCol axmlTableCol_ = new AxmlTableCol();
    private AxmlText axmlText_;

    public AmlTableHead() {
    }

    public AmlTableHead(String heading) throws AttributeCannotBeAddedException {
        this.setText(heading);
    }

    public AmlTableHead(int priority) throws AttributeCannotBeAddedException {
        this.setPriority(priority);
    }

    public void setMaxColWidth(int width) throws AttributeCannotBeAddedException {
        String wStr = new Integer(width).toString();
        this.axmlTableCol_.addAxmlAttribute("maxcolwidth", wStr);
    }

    public void setMaxColWidth(String width) throws AttributeCannotBeAddedException {
        this.axmlTableCol_.addAxmlAttribute("maxcolwidth", width);
    }

    public void setHalign(String halign) throws AttributeCannotBeAddedException {
        if (!(halign.equals("right") || halign.equals("center") || halign.equals("left"))) {
            throw new AttributeCannotBeAddedException("Invalid Attr value: " + halign);
        }
        this.axmlTableCol_.addAxmlAttribute("halign", halign);
    }

    public void setValign(String valign) throws AttributeCannotBeAddedException {
        if (!(valign.equals("top") || valign.equals("middle") || valign.equals("bottom"))) {
            throw new AttributeCannotBeAddedException("Invalid Attr value: " + valign);
        }
        this.axmlTableCol_.addAxmlAttribute("valign", valign);
    }

    public void setBGColor(String bgcolor) throws AttributeCannotBeAddedException {
        this.axmlTableCol_.addAxmlAttribute("bgcolor", bgcolor);
    }

    public void setPriority(int priority) throws AttributeCannotBeAddedException {
        this.axmlTableCol_.addAxmlAttribute("priority", new Integer(priority).toString());
    }

    public void setPriority(String priority) throws AttributeCannotBeAddedException {
        this.axmlTableCol_.addAxmlAttribute("priority", priority);
    }

    public void setBold(boolean isBold) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("bold", new Boolean(isBold).toString());
    }

    public void setItalics(boolean isItalics) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("italics", new Boolean(isItalics).toString());
    }

    public void setUnderline(boolean isUnderline) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("underline", new Boolean(isUnderline).toString());
    }

    public void setTextSize(String textSize) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        if (textSize.equals("big") || textSize.equals("small")) {
            this.axmlText_.addAxmlAttribute("textsize", textSize);
        } else {
            this.axmlText_.addAxmlAttribute("textsize", "normal");
        }
    }

    public void setAudioText(String audioText) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text", audioText);
    }

    public void setAudioTextUrl(String audioTextUrl) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text_src", audioTextUrl);
    }

    public void setText(String text) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.axmlText_ = new AxmlText();
            try {
                this.axmlTableCol_.addAxmlElement(this.axmlText_);
            }
            catch (ElementCannotBeAddedException ex) {
                throw new AttributeCannotBeAddedException();
            }
        }
        this.axmlText_.addAxmlAttribute("text", text);
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlTableCol_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlTableCol_.addExtension(amlStyle.getExtensionObject());
    }

    public void addAmlText(AmlText amlText) throws ElementCannotBeAddedException {
        this.axmlTableCol_.addAxmlElement(amlText.getAxmlElement());
    }

    public void addAmlImage(AmlImage amlImage) throws ElementCannotBeAddedException {
        this.axmlTableCol_.addAxmlElement(amlImage.getAxmlElement());
    }

    public AxmlElement getAxmlElement() {
        return this.axmlTableCol_;
    }

    public String getName() {
        return "AmlTableHead";
    }
}

