/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlGridBagConstraints;
import com.aligo.aml.AmlImage;
import com.aligo.aml.AmlOrderedConstraints;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.AmlText;
import com.aligo.aml.base.AmlInputElement;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;
import java.math.BigDecimal;

public class AmlInput
extends AmlInputElement {
    private AxmlInput axmlInput_ = new AxmlInput();
    private AxmlText axmlText_;

    public AmlInput() {
    }

    public AmlInput(String type, String name) throws AttributeCannotBeAddedException {
        this.setType(type);
        this.setName(name);
    }

    public void setType(String type) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("type", type);
    }

    public void setValue(String value) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("value", value);
    }

    public void setValue(int value) throws AttributeCannotBeAddedException {
        this.setValue(new Integer(value).toString());
    }

    public void setValue(BigDecimal value) throws AttributeCannotBeAddedException {
        if (value != null) {
            this.setValue(value.toString());
        } else {
            this.setValue("");
        }
    }

    public void setName(String name) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("name", name);
    }

    public void setFormat(String format) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("format", format);
    }

    public void setMaxChars(int maxChars) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("maxchars", new Integer(maxChars).toString());
    }

    public void setMaxChars(String maxChars) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("maxchars", maxChars);
    }

    public void setWidth(int width) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("width", new Integer(width).toString());
    }

    public void setWidth(String width) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("width", width);
    }

    public void setPersist(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("persist", new Boolean(flag).toString());
    }

    public void setAsText(String name) throws AttributeCannotBeAddedException {
        this.setType("text");
        this.setName(name);
    }

    public void setAsText() throws AttributeCannotBeAddedException {
        this.setType("text");
    }

    public void setAsPassword(String name) throws AttributeCannotBeAddedException {
        this.setType("password");
        this.setName(name);
    }

    public void setAsPassword() throws AttributeCannotBeAddedException {
        this.setType("password");
    }

    public void setAsNumeric() throws AttributeCannotBeAddedException {
        this.setFormat("numeric");
    }

    public void setAsAlphaNumeric() throws AttributeCannotBeAddedException {
        this.setFormat("alphanumeric");
    }

    public void setAsLocalizedAlphaNumeric() throws AttributeCannotBeAddedException {
        this.setFormat("localizedalphanumeric");
    }

    public void setAsAlphaNumericUpperCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphanumericuppercase");
    }

    public void setAsAlphaNumericLowerCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphanumericlowercase");
    }

    public void setAsAlphaOnlyUpperCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphaonlyuppercase");
    }

    public void setAsAlphaOnlyLowerCase() throws AttributeCannotBeAddedException {
        this.setFormat("alphaonlylowercase");
    }

    public void setBold(boolean isBold) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("bold", new Boolean(isBold).toString());
    }

    public void setItalics(boolean isItalics) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("italics", new Boolean(isItalics).toString());
    }

    public void setUnderline(boolean isUnderline) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("underline", new Boolean(isUnderline).toString());
    }

    public void setTextSize(String textSize) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        if (textSize.equals("big") || textSize.equals("small")) {
            this.axmlText_.addAxmlAttribute("textsize", textSize);
        } else {
            this.axmlText_.addAxmlAttribute("textsize", "normal");
        }
    }

    public void setView(String viewOption) throws AttributeCannotBeAddedException {
        if (viewOption.equals("hidden") || viewOption.equals("none")) {
            this.axmlInput_.addAxmlAttribute("view", viewOption);
        } else {
            this.axmlInput_.addAxmlAttribute("view", "show");
        }
    }

    public void setAudioText(String audioText) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlInput_.addAxmlAttribute("audio_text", audioText);
    }

    public void setAudioTextUrl(String audioTextUrl) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.setText("");
        }
        this.axmlText_.addAxmlAttribute("audio_text_src", audioTextUrl);
    }

    public void setAudioGrammarUrl(String audioGrammarUrl) throws AttributeCannotBeAddedException {
        this.axmlInput_.addAxmlAttribute("audio_grammar_src", audioGrammarUrl);
    }

    public void setText(String text) throws AttributeCannotBeAddedException {
        if (this.axmlText_ == null) {
            this.axmlText_ = new AxmlText();
            try {
                this.axmlInput_.addAxmlElement(this.axmlText_);
            }
            catch (ElementCannotBeAddedException ex) {
                throw new AttributeCannotBeAddedException();
            }
        }
        this.axmlText_.addAxmlAttribute("text", text);
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlInput_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlInput_.addExtension(amlStyle.getExtensionObject());
    }

    public void addAmlText(AmlText amlText) throws ElementCannotBeAddedException {
        this.axmlInput_.addAxmlElement(amlText.getAxmlElement());
    }

    public void addAmlImage(AmlImage amlImage) throws ElementCannotBeAddedException {
        this.axmlInput_.addAxmlElement(amlImage.getAxmlElement());
    }

    public AxmlElement getAxmlElement() {
        return this.axmlInput_;
    }

    public void addAmlOrderedConstraints(AmlOrderedConstraints amlOrderedConstraints) throws ElementCannotBeAddedException {
        this.axmlInput_.addExtension(amlOrderedConstraints.getExtensionObject());
    }

    public void addAmlGridBagConstraints(AmlGridBagConstraints amlGridBagConstraints) throws ElementCannotBeAddedException {
        this.axmlInput_.addExtension(amlGridBagConstraints.getExtensionObject());
    }

    public String getName() {
        return "AmlInput";
    }
}

