/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModificationSet;
import sun.comm.dirmig.commAttrValuePair;
import sun.comm.dirmig.commAttribute;
import sun.comm.dirmig.commDomainEntry;

public class commConfigService {
    Vector sAttributes = new Vector();
    LDAPModificationSet sModificationSet = null;
    commAttrValuePair sService = null;

    public commConfigService() {
    }

    public commConfigService(String theServiceName) {
        this.addServiceIdentifier(theServiceName);
    }

    public commConfigService(commAttrValuePair theService) {
        this.addServiceIdentifier(theService);
    }

    public commConfigService(commConfigService theCommConfigService) {
        Iterator aIterator = null;
        this.sService = theCommConfigService.sService;
        this.sAttributes = new Vector();
        aIterator = theCommConfigService.sAttributes.iterator();
        while (aIterator.hasNext()) {
            this.sAttributes.add(new commAttribute((commAttribute)((Object)aIterator.next())));
        }
        this.sModificationSet = null;
    }

    public void addAttribute(commAttrValuePair theAttrValuePair) {
        commAttribute aCommAttribute = null;
        aCommAttribute = this.findAttribute(theAttrValuePair.getAttributeName());
        if (aCommAttribute == null) {
            aCommAttribute = new commAttribute(theAttrValuePair);
            this.sAttributes.add(aCommAttribute);
        } else {
            aCommAttribute.addValue(theAttrValuePair.getStringValue());
        }
    }

    public commAttribute findAttribute(String theAttributeName) {
        Iterator aIterator = this.sAttributes.iterator();
        commAttribute aCommAttribute = null;
        while (aIterator.hasNext()) {
            aCommAttribute = (commAttribute)((Object)aIterator.next());
            if (!theAttributeName.equalsIgnoreCase(aCommAttribute.getBaseName())) continue;
            return aCommAttribute;
        }
        return null;
    }

    public void add(commConfigService theConfigService) throws Exception {
        this.mergeLdapAttributes(theConfigService.sAttributes);
    }

    public commConfigService getExclusive(LDAPEntry theLdapEntry) throws Exception {
        commConfigService aConfigService = new commConfigService(this.sService);
        Object aCommAttributeVector = null;
        aConfigService.sAttributes = this.siftExclusive(theLdapEntry.getAttributeSet());
        return aConfigService;
    }

    public void substitute(commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        Iterator aIterator = this.sAttributes.iterator();
        while (aIterator.hasNext()) {
            ((commAttribute)((Object)aIterator.next())).substitute(theDomain, theEntry, theValueMap);
        }
    }

    public LDAPAttributeSet getAttributeSetWithSubstitution(commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        Iterator aIterator = this.sAttributes.iterator();
        LDAPAttribute aLdapAttribute = null;
        LDAPAttributeSet aLdapAttributeSet = new LDAPAttributeSet();
        while (aIterator.hasNext()) {
            aLdapAttribute = ((commAttribute)((Object)aIterator.next())).getLdapAttrWithSubstitution(theDomain, theEntry, theValueMap);
            if (aLdapAttribute == null) continue;
            aLdapAttributeSet.add(aLdapAttribute);
        }
        return aLdapAttributeSet;
    }

    public void addServiceIdentifier(String theServiceName) {
        commAttrValuePair aAttrValuePair;
        this.sService = aAttrValuePair = new commAttrValuePair(theServiceName);
    }

    public void addServiceIdentifier(commAttrValuePair theService) {
        this.sService = theService;
    }

    public LDAPModificationSet getModificationSet() {
        return this.sModificationSet;
    }

    public Vector getAttributeSet() {
        return this.sAttributes;
    }

    public int getType() {
        return this.sService.getType();
    }

    public int getClassType() {
        return this.sService.getClassType();
    }

    public int getOrder() {
        return this.sService.getOrder();
    }

    public int getRank() {
        return this.sService.getRank();
    }

    public String getName() {
        return this.sService.getAttributeName();
    }

    public Iterator getAttributeIterator() {
        return this.sAttributes.iterator();
    }

    private void mergeLdapAttributes(Vector theAttributeSet) throws Exception {
        Iterator aIterator = theAttributeSet.iterator();
        commAttribute aNewAttribute = null;
        commAttribute aCurrentAttribute = null;
        while (aIterator.hasNext()) {
            aNewAttribute = (commAttribute)((Object)aIterator.next());
            aCurrentAttribute = this.findAttribute(aNewAttribute.getBaseName());
            if (aCurrentAttribute != null) {
                this.mergeAttributeValues(aCurrentAttribute, aNewAttribute, aCurrentAttribute.getType());
                continue;
            }
            this.sAttributes.add(aNewAttribute);
        }
    }

    private Vector siftExclusive(LDAPAttributeSet theLdapAttributeSet) throws Exception {
        Enumeration aEnumerator = theLdapAttributeSet.getAttributes();
        LDAPAttribute aNewAttribute = null;
        commAttribute aCurrentAttribute = null;
        Vector<commAttribute> aReturnVector = new Vector<commAttribute>();
        while (aEnumerator.hasMoreElements()) {
            aNewAttribute = (LDAPAttribute)aEnumerator.nextElement();
            aCurrentAttribute = this.findAttribute(aNewAttribute.getBaseName());
            if (aCurrentAttribute == null) continue;
            this.mergeAttributeValues(aCurrentAttribute, aNewAttribute, aCurrentAttribute.getType());
            aReturnVector.add(aCurrentAttribute);
        }
        return aReturnVector;
    }

    private void mergeAttributeValues(LDAPAttribute theTargetAttribute, LDAPAttribute theSourceAttribute, int theType) throws Exception {
        String[] aSourceValueArray = theSourceAttribute.getStringValueArray();
        String[] aTargetValueArray = theTargetAttribute.getStringValueArray();
        String aSourceValue = null;
        Object aTargeValue = null;
        int aSourceIdx = 0;
        int aSourceLength = aSourceValueArray.length;
        int aTargetIdx = 0;
        int aTargetLength = aTargetValueArray.length;
        boolean aFoundIt = false;
        if (theType == 1) {
            if (aTargetLength > 0) {
                theTargetAttribute.removeValue(aTargetValueArray[0]);
            }
            theTargetAttribute.addValue(aSourceValueArray[0]);
            return;
        }
        for (aSourceIdx = 0; aSourceIdx < aSourceLength; ++aSourceIdx) {
            aSourceValue = aSourceValueArray[aSourceIdx];
            aFoundIt = false;
            for (aTargetIdx = 0; !aFoundIt && aTargetIdx < aTargetLength; ++aTargetIdx) {
                if (!aSourceValue.equalsIgnoreCase(aTargetValueArray[aTargetIdx])) continue;
                aFoundIt = true;
            }
            if (aFoundIt) continue;
            theTargetAttribute.addValue(aSourceValue);
        }
    }
}

