/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.ber.stream.BERElement;
import sun.comm.dirmig.commAttrValuePair;
import sun.comm.dirmig.commConstants;
import sun.comm.dirmig.commDomainEntry;

public class commAttribute
extends LDAPAttribute {
    int sId = 0;
    int sType = 0;
    String sCase = "cis";
    int sOp = 0;
    int sClass = 0;
    int sOrder = 0;

    public commAttribute(LDAPAttribute theLdapAttribute) {
        super(theLdapAttribute);
        this.setDefaults();
    }

    public commAttribute(String theAttributeName) {
        super(theAttributeName);
        this.setDefaults();
    }

    public commAttribute(String theAttributeName, byte[] theAttributeValue) {
        super(theAttributeName, theAttributeValue);
        this.setDefaults();
    }

    public commAttribute(BERElement theBerElement) throws Exception {
        super(theBerElement);
        this.setDefaults();
    }

    public commAttribute(String theAttributeName, String theAttributeValue) {
        super(theAttributeName, theAttributeValue);
        this.setDefaults();
    }

    public commAttribute(String theAttributeName, String[] theAttributeValues) {
        super(theAttributeName, theAttributeValues);
        this.setDefaults();
    }

    public commAttribute(commAttrValuePair theAvPair) {
        super(theAvPair.getAttributeName(), theAvPair.getStringValue());
        this.sOp = theAvPair.getOp();
        this.sType = theAvPair.getType();
        this.sClass = theAvPair.getClassType();
        this.sOrder = theAvPair.getOrder();
    }

    public commAttribute(commAttribute theCommAttribute) {
        super(theCommAttribute.getName(), theCommAttribute.getStringValueArray());
        this.sOp = theCommAttribute.getOperation();
        this.sType = theCommAttribute.getType();
        this.sClass = theCommAttribute.getClassType();
        this.sOrder = theCommAttribute.getOrder();
    }

    public void substitute(commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        String[] aAttributeValues = this.getStringValueArray();
        String[] aNewValues = new String[aAttributeValues.length];
        int aIdx = 0;
        if (this.sClass != 4) {
            return;
        }
        for (aIdx = 0; aIdx < aAttributeValues.length; ++aIdx) {
            aNewValues[aIdx] = commConstants.substitute(aAttributeValues[aIdx], theDomain, theEntry, theValueMap);
        }
        this.setNewValues(aNewValues);
    }

    public String[] getSubstitutedValues(commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        String[] aAttributeValues = this.getStringValueArray();
        String[] aNewValues = new String[aAttributeValues.length];
        String[] aMultiMacroValues = null;
        Object aMacroString = null;
        String aAttributeString = null;
        Map aValueMap = null;
        Vector aVectorOfMaps = null;
        int aIdx = 0;
        int aVectorSize = 0;
        if (this.sClass != 4 && this.sClass != 5) {
            return aAttributeValues;
        }
        if (aAttributeValues.length == 0) {
            return aAttributeValues;
        }
        if (this.sClass == 5) {
            aAttributeString = aAttributeValues[0];
            aVectorOfMaps = this.getValuesForMacro(aAttributeString, theDomain, theEntry);
            if (aVectorOfMaps != null) {
                aVectorSize = aVectorOfMaps.size();
                aMultiMacroValues = new String[aVectorSize];
                for (aIdx = 0; aIdx < aVectorSize; ++aIdx) {
                    aValueMap = (Map)aVectorOfMaps.elementAt(aIdx);
                    aMultiMacroValues[aIdx] = commConstants.substitute(aAttributeString, null, null, aValueMap);
                }
                aAttributeValues = aMultiMacroValues;
                aNewValues = new String[aAttributeValues.length];
            } else {
                return null;
            }
        }
        for (aIdx = 0; aIdx < aAttributeValues.length; ++aIdx) {
            aNewValues[aIdx] = commConstants.substitute(aAttributeValues[aIdx], theDomain, theEntry, theValueMap);
        }
        return aNewValues;
    }

    public LDAPAttribute getLdapAttrWithSubstitution(commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        String[] aAttributeValues = this.getStringValueArray();
        String[] aNewValues = new String[aAttributeValues.length];
        Object aMultiMacroValues = null;
        Object aMacroString = null;
        String aAttributeString = null;
        LDAPAttribute aLdapAttribute = null;
        Map aValueMap = null;
        Vector aVectorOfMaps = null;
        int aIdx = 0;
        int aVectorSize = 0;
        if (this.sClass != 4 && this.sClass != 5) {
            return this.getLDAPAttribute();
        }
        if (aAttributeValues.length == 0) {
            return this.getLDAPAttribute();
        }
        if (this.sClass == 5) {
            aAttributeString = aAttributeValues[0];
            aVectorOfMaps = this.getValuesForMacro(aAttributeString, theDomain, theEntry);
            if (aVectorOfMaps != null) {
                aVectorSize = aVectorOfMaps.size();
                for (aIdx = 0; aIdx < aVectorSize; ++aIdx) {
                    aValueMap = (Map)aVectorOfMaps.elementAt(aIdx);
                    aMultiMacroValues[aIdx] = commConstants.substitute(aAttributeString, null, null, aValueMap);
                }
                aAttributeValues = aMultiMacroValues;
            } else {
                return null;
            }
        }
        for (aIdx = 0; aIdx < aAttributeValues.length; ++aIdx) {
            aNewValues[aIdx] = commConstants.substitute(aAttributeValues[aIdx], theDomain, theEntry, theValueMap);
        }
        aLdapAttribute = new LDAPAttribute(this.getName(), aNewValues);
        return aLdapAttribute;
    }

    public void mergeAttributeValues(LDAPAttribute theSourceAttribute) throws Exception {
        String[] aSourceValueArray = theSourceAttribute.getStringValueArray();
        String[] aTargetValueArray = this.getStringValueArray();
        String aSourceValue = null;
        Object aTargeValue = null;
        int aSourceIdx = 0;
        int aSourceLength = aSourceValueArray.length;
        int aTargetIdx = 0;
        int aTargetLength = aTargetValueArray.length;
        boolean aFoundIt = false;
        for (aSourceIdx = 0; aSourceIdx < aSourceLength; ++aSourceIdx) {
            aSourceValue = aSourceValueArray[aSourceIdx];
            aFoundIt = false;
            for (aTargetIdx = 0; !aFoundIt && aTargetIdx < aTargetLength; ++aTargetIdx) {
                if (!aSourceValue.equalsIgnoreCase(aTargetValueArray[aTargetIdx])) continue;
                aFoundIt = true;
            }
            if (aFoundIt) continue;
            this.addValue(aSourceValue);
        }
    }

    public int getType() {
        return this.sType;
    }

    public int getOperation() {
        return this.sOp;
    }

    public int getClassType() {
        return this.sClass;
    }

    public int getOrder() {
        return this.sOrder;
    }

    public LDAPAttribute getLDAPAttribute() {
        String[] myValues = super.getStringValueArray();
        LDAPAttribute temp = new LDAPAttribute(this.getName(), myValues);
        return temp;
    }

    public void setNewValues(String[] values) {
        super.setValues(values);
    }

    private void setDefaults() {
        this.sOp = 0;
        this.sType = 1;
    }

    private Vector getValuesForMacro(String theValueString, commDomainEntry theDomainEntry, LDAPEntry theEntry) {
        Vector aAssociatedValues = null;
        Vector aVectorOfMaps = null;
        String aMacroString = null;
        HashMap aValueMap = null;
        int aIdx = 0;
        int aSize = 0;
        if (theValueString.indexOf("%DOMAIN_ASSOCIATED_DOMAIN%") != -1) {
            aMacroString = "%DOMAIN_ASSOCIATED_DOMAIN%";
            aAssociatedValues = theDomainEntry.getAssociatedDomains();
            if (aAssociatedValues != null && (aSize = aAssociatedValues.size()) > 0) {
                aVectorOfMaps = new Vector();
                for (aIdx = 0; aIdx < aSize; ++aIdx) {
                    aValueMap = new HashMap();
                    aValueMap.put(aMacroString, aAssociatedValues.elementAt(aIdx));
                    aVectorOfMaps.add(aValueMap);
                }
            }
        }
        return aVectorOfMaps;
    }
}

