/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DABusinessOrganization;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DARole;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAServicePackageManager;
import com.sun.comm.jdapi.DAUtil;
import java.util.Iterator;
import java.util.Vector;

public class DAUser
extends DAObject {
    String _organizationDn;

    public DAUser() {
    }

    public DAUser(DAConnection c) {
        super(c);
    }

    public String getUId() {
        return this.getFirstValue(DAConstants.UID);
    }

    public String getLogin() {
        return this.getFirstValue(DAConstants.LOGIN_ID);
    }

    public String getFirstName() {
        return this.getFirstValue(DAConstants.FIRST_NAME);
    }

    public String getFirstName(String lang) {
        return this.getFirstValue(DAConstants.FIRST_NAME + ";lang-" + lang);
    }

    public String getLastName() {
        return this.getFirstValue(DAConstants.LAST_NAME);
    }

    public String getLastName(String lang) {
        return this.getFirstValue(DAConstants.LAST_NAME + ";lang-" + lang);
    }

    public String getStatus() {
        return this.getFirstValue("inetuserstatus");
    }

    public void setFirstName(String theFirstName) {
        this.setAttributeValues(DAConstants.FIRST_NAME, theFirstName);
    }

    public void setLastName(String theLastName) {
        this.setAttributeValues(DAConstants.LAST_NAME, theLastName);
    }

    public String[] getCurrentServicePackageNames() {
        DAAttribute cosAttr = this.getAttribute(DAConstants.COS_ATTR);
        if (cosAttr == null) {
            return null;
        }
        return cosAttr.getValues();
    }

    public DAServicePackage[] getServicePackages() throws Exception {
        DAServicePackage[] aSpArray = null;
        Vector aSpVector = null;
        String[] aSpNamesArray = null;
        DAServicePackageManager aSpManager = null;
        aSpNamesArray = this.getServicePackageNames();
        if (aSpNamesArray == null || aSpNamesArray.length == 0) {
            return null;
        }
        aSpManager = DAConnection.getServicePackageManager();
        aSpVector = aSpManager.getServicePackages(aSpNamesArray, null, this.getMyTask());
        aSpArray = new DAServicePackage[1];
        return aSpVector.toArray(aSpArray);
    }

    public String[] getServicePackageNames() {
        return this.getAttributeValues(DAConstants.COS_ATTR);
    }

    public void assignServicePackages(String[] services) throws Exception {
        String[] aServiceNames = null;
        if (DAConnection.getMode() == 102) {
            aServiceNames = this.getServicePackageNames();
            this.removeServicePackages(aServiceNames);
            this.setAttributeValues(DAConstants.COS_ATTR, services);
            aServiceNames = this.getServicePackageNames();
            this.addServicePackages(aServiceNames);
        } else {
            this.setAttributeValues(DAConstants.COS_ATTR, services);
        }
    }

    public void addServicePackages(String[] services) throws Exception {
        int aIdx = 0;
        boolean aIIdx = false;
        Vector aSpNamesVector = null;
        Vector aSpVector = null;
        Vector aCosAttributes = null;
        DAAttribute aAttribute = null;
        Object aStatusAttribute = null;
        DAServicePackage aServicePackage = null;
        Object aDefaultValue = null;
        Object aServiceTypes = null;
        Iterator aIterator = null;
        if (DAConnection.getMode() == 102) {
            this.addValuesToAttribute(DAConstants.COS_ATTR, services);
            aSpNamesVector = DAUtil.convertToVector(services);
            aSpVector = DAConnection.getServicePackages(aSpNamesVector);
            for (aIdx = 0; aIdx < services.length; ++aIdx) {
                aServicePackage = new DAServicePackage();
                aServicePackage.setName(services[aIdx]);
                aServicePackage = (DAServicePackage)DAUtil.getObjectInVector(aSpVector, aServicePackage);
                if (aServicePackage == null || (aCosAttributes = aServicePackage.getCOSAttributes()) == null) continue;
                aIterator = aCosAttributes.iterator();
                while (aIterator.hasNext()) {
                    aAttribute = (DAAttribute)aIterator.next();
                    this.addAttribute(aAttribute);
                }
            }
        } else {
            this.addValuesToAttribute(DAConstants.COS_ATTR, services);
        }
    }

    public void removeServicePackages(String[] services) throws Exception {
        int aIdx = 0;
        Vector aSpNamesVector = null;
        Vector aSpVector = null;
        Vector aCosAttributes = null;
        DAAttribute aAttribute = null;
        DAServicePackage aServicePackage = null;
        Iterator aIterator = null;
        if (DAConnection.getMode() == 102) {
            this.removeValuesFromAttribute(DAConstants.COS_ATTR, services);
            aSpNamesVector = DAUtil.convertToVector(services);
            aSpVector = DAConnection.getServicePackages(aSpNamesVector);
            for (aIdx = 0; aIdx < services.length; ++aIdx) {
                aServicePackage = new DAServicePackage();
                aServicePackage.setName(services[aIdx]);
                aServicePackage = (DAServicePackage)DAUtil.getObjectInVector(aSpVector, aServicePackage);
                if (aServicePackage == null || (aCosAttributes = aServicePackage.getCOSAttributes()) == null) continue;
                aIterator = aCosAttributes.iterator();
                while (aIterator.hasNext()) {
                    aAttribute = (DAAttribute)aIterator.next();
                    this.removeAttribute(aAttribute);
                }
            }
        } else {
            this.removeValuesFromAttribute(DAConstants.COS_ATTR, services);
        }
    }

    public void setServiceStatus(String theService, String theStatus) {
        String aStatusAttributeName = null;
        aStatusAttributeName = this.getStatusAttributeName(theService);
        if (aStatusAttributeName == null) {
            return;
        }
        this.setAttributeValues(aStatusAttributeName, theStatus);
    }

    public String getServiceStatus(String theServiceName) {
        String aStatusAttributeName = null;
        aStatusAttributeName = this.getStatusAttributeName(theServiceName);
        if (aStatusAttributeName == null) {
            return null;
        }
        return this.getFirstValue(aStatusAttributeName);
    }

    public void addRoles(DARole[] roles) throws DAException {
        for (int i = 0; i < roles.length; ++i) {
            this.addAttributeValue("nsroledn", roles[i].getRoleDN());
        }
        this.getMyTask().doTask("addrole", this, new DABusinessOrganization());
    }

    public void removeRoles(DARole[] roles) throws DAException {
        String[] roleValues = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            roleValues[i] = roles[i].getRoleDN();
        }
        this.removeValuesFromAttribute("nsroledn", roleValues);
        this.getMyTask().doTask("removerole", this, new DABusinessOrganization());
    }

    public DARole[] getRoles() {
        DARole[] toReturn = null;
        String[] roleDNs = this.getAttributeValues("nsroledn");
        if (roleDNs != null && roleDNs.length > 0) {
            toReturn = new DARole[roleDNs.length];
            for (int i = 0; i < roleDNs.length; ++i) {
                toReturn[i] = new DARole();
                toReturn[i].setRoleDN(roleDNs[i]);
            }
        }
        return toReturn;
    }

    public boolean equals(DAObject theObject) {
        String aTargetDn = theObject.getDN();
        String aThisDn = this.getDN();
        return aThisDn.equalsIgnoreCase(aTargetDn);
    }

    public void setDN(String theDn) {
        String aPartialDn = null;
        super.setDN(theDn);
        aPartialDn = theDn.substring(theDn.indexOf(",") + 1);
        this._organizationDn = aPartialDn.substring(aPartialDn.indexOf(",") + 1);
    }

    String getOrganizationDn() {
        return this._organizationDn;
    }

    String getStatusAttributeName(String theServiceName) {
        DAServicePackage[] aSpArray = null;
        DAServicePackage aServicePackage = null;
        String aServiceTypeStatusAttributeName = null;
        int aIdx = 0;
        try {
            aSpArray = this.getServicePackages();
            if (aSpArray == null) {
                return null;
            }
        }
        catch (Exception theException) {
            return null;
        }
        for (aIdx = 0; aIdx < aSpArray.length; ++aIdx) {
            aServicePackage = aSpArray[aIdx];
            try {
                aServiceTypeStatusAttributeName = aServicePackage.getServiceStatusAttributeName(theServiceName);
            }
            catch (Exception theException) {
                // empty catch block
            }
            if (aServiceTypeStatusAttributeName != null) break;
        }
        return aServiceTypeStatusAttributeName;
    }

    void fillReadServices() {
        String[] aCurrentServices = this.getAttributeValues("inetcos");
        if (aCurrentServices != null) {
            this._readServices = DAUtil.convertToVector(aCurrentServices);
        }
    }

    DAAttribute getCosAttribute() {
        String[] aServiceNames = null;
        return new DAAttribute("inetcos", aServiceNames);
    }

    public String getName() {
        String cn = this.getFirstValue(DAConstants.FULL_NAME);
        String aFirstName = this.getFirstName();
        String aLastName = this.getLastName();
        String uid = this.getFirstValue(DAConstants.UID);
        if (cn != null) {
            return cn;
        }
        if (aLastName != null) {
            return aLastName;
        }
        if (aFirstName != null) {
            return aFirstName;
        }
        if (uid != null) {
            return uid;
        }
        return null;
    }
}

