/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAProviderOrganization;
import com.sun.comm.jdapi.DAResourceBundle;
import com.sun.comm.jdapi.DAResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DATask;
import com.sun.comm.jdapi.DAUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

class DAServicePackageManager {
    private Map _servicePackageMap = new HashMap();
    private long _timeToLive = 0L;
    private long _refreshTime = 0L;

    DAServicePackageManager() {
        this.setRefreshTime();
    }

    public synchronized DAServicePackage getServicePackage(String theServicePackageName, DATask theTask) throws DAException {
        Vector<String> aRequestVector = new Vector<String>();
        Vector aReturnVector = null;
        DAServicePackage aReturnServicePackage = null;
        aRequestVector.add(theServicePackageName);
        aReturnVector = this.getServicePackages(aRequestVector, null, theTask);
        if (aReturnVector.size() > 0) {
            aReturnServicePackage = (DAServicePackage)aReturnVector.elementAt(0);
        }
        return aReturnServicePackage;
    }

    public synchronized Vector getServicePackages(String[] theIncludeServices, String[] theExcludeServices, DATask theTask) throws DAException {
        Vector aIncludeNames = null;
        Vector aExcludeNames = null;
        aIncludeNames = DAUtil.convertToVector(theIncludeServices);
        aExcludeNames = DAUtil.convertToVector(theExcludeServices);
        return this.getServicePackages(aIncludeNames, aExcludeNames, theTask);
    }

    public synchronized Vector getServicePackages(Vector theIncludeSpNames, Vector theExcludeSpNames, DATask theTask) throws DAException {
        long aCurrentTime = System.currentTimeMillis();
        Vector aReturnVector = null;
        if (DAConnection.getMode() == 103 && aCurrentTime >= this._refreshTime) {
            this.refresh(theTask);
        }
        aReturnVector = theIncludeSpNames != null && theIncludeSpNames.size() > 0 ? this.getIncludeServices(theIncludeSpNames) : (theExcludeSpNames != null && theExcludeSpNames.size() > 0 ? this.getExcludeServices(theExcludeSpNames) : DAUtil.convertToVector(this._servicePackageMap));
        return aReturnVector;
    }

    public synchronized Vector getServicePackageNames(String[] theIncludeServices, String[] theExcludeServices, DATask theTask) {
        Vector aServicePackages = null;
        Vector<String> aReturnVector = new Vector<String>();
        Iterator aIterator = null;
        DAServicePackage aSp = null;
        String aSpName = null;
        try {
            aServicePackages = this.getServicePackages(theIncludeServices, theExcludeServices, theTask);
        }
        catch (DAException theException) {
            // empty catch block
        }
        aIterator = aServicePackages.iterator();
        while (aIterator.hasNext()) {
            aSp = (DAServicePackage)aIterator.next();
            aSpName = aSp.getName();
            aReturnVector.add(aSpName);
        }
        return aReturnVector;
    }

    private synchronized void refresh(DATask theTask) throws DAException {
        DAProviderOrganization aProviderOrganization = new DAProviderOrganization();
        DAServicePackage aServicePackage = new DAServicePackage();
        DAAttribute aRefreshAttribute = null;
        DAAttribute aNamesAttribute = null;
        DAResults aResults = null;
        Vector aSpVector = null;
        Iterator aIterator = null;
        aProviderOrganization.setDN("cn=providerOrganization");
        aProviderOrganization.setName("providerOrganization");
        aRefreshAttribute = new DAAttribute("refresh", 2048, "*");
        aNamesAttribute = new DAAttribute("spnames", 2048, "*");
        aServicePackage.addAttribute(aRefreshAttribute);
        aServicePackage.addAttribute(aNamesAttribute);
        try {
            aResults = theTask.doTask("search", aServicePackage, aProviderOrganization);
            aSpVector = aResults.getSearchResult().getResultVector();
        }
        catch (Exception theException) {
            throw new DAException("Unable to retrieve service package information from server");
        }
        this._servicePackageMap.clear();
        aIterator = aSpVector.iterator();
        while (aIterator.hasNext()) {
            aServicePackage = (DAServicePackage)aIterator.next();
            this._servicePackageMap.put(aServicePackage.getName().toLowerCase(), aServicePackage);
        }
        this._refreshTime = System.currentTimeMillis() + this._timeToLive;
    }

    private synchronized Vector getIncludeServices(Vector theIncludeSpNames) {
        Iterator aIterator = theIncludeSpNames.iterator();
        Vector<DAServicePackage> aReturnVector = new Vector<DAServicePackage>();
        DAServicePackage aSp = null;
        String aSpName = null;
        while (aIterator.hasNext()) {
            aSpName = (String)aIterator.next();
            aSp = (DAServicePackage)this._servicePackageMap.get(aSpName.toLowerCase());
            if (aSp == null) continue;
            aReturnVector.add(aSp);
        }
        return aReturnVector;
    }

    private synchronized Vector getExcludeServices(Vector theExcludeSpNames) {
        Iterator aIterator = theExcludeSpNames.iterator();
        Iterator aKeySetIterator = null;
        String aSpName = null;
        HashMap aReturnMap = new HashMap(this._servicePackageMap);
        Vector<DAServicePackage> aReturnVector = new Vector<DAServicePackage>();
        DAServicePackage aServicePackage = null;
        while (aIterator.hasNext()) {
            aSpName = (String)aIterator.next();
            aReturnMap.remove(aSpName.toLowerCase());
        }
        aKeySetIterator = aReturnMap.keySet().iterator();
        while (aKeySetIterator.hasNext()) {
            aSpName = (String)aKeySetIterator.next();
            aServicePackage = (DAServicePackage)aReturnMap.get(aSpName);
            aReturnVector.add(aServicePackage);
        }
        return aReturnVector;
    }

    private void setRefreshTime() {
        DAResourceBundle _resourceSet = new DAResourceBundle("com.sun.comm.jdapi.resource", "en");
        String aHoursString = null;
        String aMinutesString = null;
        int aHours = 0;
        int aMinutes = 0;
        long aMilleMinute = 60000L;
        long aMilleHour = aMilleMinute * 60L;
        long aTotalMilles = 0L;
        aHoursString = _resourceSet.getString("ServicePackage", "ttlhours");
        aMinutesString = _resourceSet.getString("ServicePackage", "ttlminutes");
        if (aHoursString != null) {
            aHours = Integer.parseInt(aHoursString);
        }
        if (aMinutesString != null) {
            aMinutes = Integer.parseInt(aMinutesString);
        }
        if (aHours == 0 && aMinutes == 0) {
            aHours = 2;
        } else {
            this._timeToLive = aMilleHour * (long)aHours + aMilleMinute * (long)aMinutes;
        }
        this._refreshTime = System.currentTimeMillis();
    }

    DAServicePackage getServicePackage(String theServicePackageName) {
        DAServicePackage aServicePackage = (DAServicePackage)this._servicePackageMap.get(theServicePackageName);
        Object aObjectSp = null;
        Object aOrganization = null;
        Object aServicePackages = null;
        Object aResponse = null;
        boolean aResultSize = false;
        if (DAConnection.getMode() == 102) {
            return aServicePackage;
        }
        return aServicePackage;
    }

    public void initCannedData() throws Exception {
        DAServicePackage aServicePackage = new DAServicePackage();
        DAServicePackage aWorkingSp = null;
        aWorkingSp = aServicePackage.test("gold");
        if (aWorkingSp != null) {
            this._servicePackageMap.put("gold", aWorkingSp);
        }
        if ((aWorkingSp = aServicePackage.test("silver")) != null) {
            this._servicePackageMap.put("silver", aWorkingSp);
        }
        if ((aWorkingSp = aServicePackage.test("bronze")) != null) {
            this._servicePackageMap.put("bronze", aWorkingSp);
        }
    }
}

