/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DAServicePackage
extends DAObject {
    private Vector _statusAttributes = new Vector();
    private Vector _requiredAttributes = new Vector();
    private Vector _optionalAttributes = new Vector();
    private Vector _cosAttributes = new Vector();
    private Vector _writeableAttributes = new Vector();
    public static final String MAIL_SERVICE = "mail";
    public static final String CALENDAR_SERVICE = "calendar";
    private static Map sServiceMap = null;

    DAServicePackage() {
    }

    public String[] getServiceTypes() {
        String[] aServiceTypeArray = null;
        String[] aStatusSplit = null;
        String aStatusString = null;
        Vector<String> aServiceTypeVector = new Vector<String>();
        Iterator aIterator = null;
        if (this._statusAttributes.size() == 0) {
            return null;
        }
        aIterator = this._statusAttributes.iterator();
        while (aIterator.hasNext()) {
            aStatusString = (String)aIterator.next();
            aStatusSplit = aStatusString.split(":");
            aServiceTypeVector.add(aStatusSplit[1]);
        }
        aServiceTypeArray = new String[1];
        return aServiceTypeVector.toArray(aServiceTypeArray);
    }

    public String getServiceStatusAttributeName(String theServiceName) throws DAException {
        Iterator aIterator = null;
        String[] aStatusSplit = null;
        String aStatusAttributeName = null;
        String aStatusString = null;
        if (theServiceName == null) {
            throw new DAException("Invalid argument for method");
        }
        aIterator = this._statusAttributes.iterator();
        while (aIterator.hasNext()) {
            aStatusString = (String)aIterator.next();
            aStatusSplit = aStatusString.split(":");
            if (!aStatusSplit[1].equalsIgnoreCase(theServiceName)) continue;
            aStatusAttributeName = aStatusSplit[0];
            break;
        }
        if (aStatusAttributeName == null) {
            throw new DAException(":getServiceStatus - no such service : " + theServiceName);
        }
        return aStatusAttributeName;
    }

    DAAttribute getServiceStatusAttribute(String theServiceName) throws Exception {
        String aStatusAttrName = this.getServiceStatusAttributeName(theServiceName);
        return this.getAttribute(aStatusAttrName);
    }

    public String getObjectType() {
        return null;
    }

    public Vector getCOSAttributes() {
        return this._cosAttributes;
    }

    public Vector getOverwriteableCOSAttributes() {
        return this._writeableAttributes;
    }

    public Vector getRequiredAttributes() {
        return this._requiredAttributes;
    }

    public Vector getAllowedAttributes() {
        return this._optionalAttributes;
    }

    public Vector getAllAttributes() {
        return this.getAttributeVector();
    }

    public void collateAttributes() {
        Iterator aIterator = null;
        DAAttribute aAttribute = null;
        Vector aAttributes = this.getAttributes();
        String aAttributeName = null;
        String[] aAttributeValues = null;
        if (aAttributes == null || aAttributes.size() == 0) {
            return;
        }
        this._attributes = new Vector();
        aIterator = aAttributes.iterator();
        while (aIterator.hasNext()) {
            aAttribute = (DAAttribute)aIterator.next();
            aAttributeName = aAttribute.getName();
            aAttributeValues = aAttribute.getValues();
            if (aAttributeName.equalsIgnoreCase("dn")) {
                this.setDN(aAttributeValues[0]);
                this.setName(aAttributeValues[0]);
                continue;
            }
            this.addCosAttribute(aAttribute.getName(), aAttribute.getValues());
        }
    }

    public void addCosAttribute(String theAttributeName, String[] theValues) {
        int aIdx = 0;
        int aIntType = 16;
        String[] aTokens = null;
        String[] aValuesArray = null;
        String aValue = null;
        String aStringType = null;
        Vector<String> aValueList = new Vector<String>();
        DAAttribute aAttribute = null;
        if (theAttributeName == null || theValues == null) {
            return;
        }
        for (aIdx = 0; aIdx < theValues.length; ++aIdx) {
            aValue = theValues[aIdx];
            if (aValue.toLowerCase().indexOf("jdtype") >= 0) {
                aTokens = aValue.split("=");
                if (aTokens.length != 2) continue;
                aStringType = aTokens[1];
                aIntType = Integer.parseInt(aStringType.trim());
                continue;
            }
            aValueList.add(aValue);
        }
        if (aValueList.size() > 0) {
            aValuesArray = new String[1];
            aAttribute = new DAAttribute(theAttributeName, aValueList.toArray(aValuesArray));
        } else {
            aAttribute = new DAAttribute(theAttributeName);
        }
        aAttribute.setType(aIntType);
        this.addCosAttribute(aAttribute);
    }

    public void addCosAttribute(DAAttribute theAttribute) {
        if (theAttribute == null) {
            return;
        }
        if (theAttribute.isType(16)) {
            DAUtil.addObjectToVector(this._optionalAttributes, theAttribute, 1003);
        }
        if (theAttribute.isType(32)) {
            DAUtil.addObjectToVector(this._requiredAttributes, theAttribute, 1003);
        }
        if (theAttribute.isType(64)) {
            DAUtil.addObjectToVector(this._writeableAttributes, theAttribute, 1003);
        }
        if (theAttribute.isType(128)) {
            DAUtil.addObjectToVector(this._cosAttributes, theAttribute, 1003);
        }
        if (theAttribute.isType(256)) {
            if (theAttribute.isType(512)) {
                this._statusAttributes.add(theAttribute.getName() + ":" + MAIL_SERVICE);
            } else if (theAttribute.isType(1024)) {
                this._statusAttributes.add(theAttribute.getName() + ":" + CALENDAR_SERVICE);
            }
        }
        DAUtil.addObjectToVector(this.getAttributeVector(), theAttribute, 1003);
    }

    DAServicePackage test(String theSPName) throws Exception {
        DAServicePackage aGoldServicePackage = new DAServicePackage();
        DAServicePackage aSilverServicePackage = new DAServicePackage();
        DAServicePackage aBronzeServicePackage = new DAServicePackage();
        Object aSP = null;
        String[][] aGoldValues = new String[][]{{"jdtype=192", "mailbox"}, {"jdtype=128", "100"}, {"jdType=128", "200"}};
        String[][] aSilverValues = new String[][]{{"jdtype=192", "mailbox"}, {"jdtype=128", "500"}, {"jdtype=128", "1000"}};
        String[][] aBronzeValues = new String[][]{{"jdtype=192", "mailbox"}, {"jdtype=128", "700"}, {"jdtype=128", "1200"}};
        String[] aMailServiceAttrNames = new String[]{"mailuserstatus", MAIL_SERVICE, "mailalternateaddress", "mailallowedserviceaccess", "mailautoreplymode", "mailautoreplysubject", "mailautoreplytext", "mailforwardingaddress", "vacationenddate", "vacationstartdate"};
        String[][] aMailAttributes = new String[][]{{"jdtype=800", "active"}, {"jdtype=32"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16", "echo"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16"}};
        aGoldServicePackage.setName("gold");
        aGoldServicePackage.addCosAttribute("maildeliveryoption", aGoldValues[0]);
        aGoldServicePackage.addCosAttribute("maildeliveryoption", aGoldValues[0]);
        aGoldServicePackage.addCosAttribute("mailquota", aGoldValues[1]);
        aGoldServicePackage.addCosAttribute("mailmsgquota", aGoldValues[2]);
        this.addMailServiceAttributes(aGoldServicePackage, aMailServiceAttrNames, aMailAttributes);
        aSilverServicePackage.setName("silver");
        aSilverServicePackage.addCosAttribute("maildeliveryoption", aSilverValues[0]);
        aSilverServicePackage.addCosAttribute("mailquota", aSilverValues[1]);
        aSilverServicePackage.addCosAttribute("mailmsgquota", aSilverValues[2]);
        this.addMailServiceAttributes(aSilverServicePackage, aMailServiceAttrNames, aMailAttributes);
        aBronzeServicePackage.setName("bronze");
        aBronzeServicePackage.addCosAttribute("maildeliveryoption", aBronzeValues[0]);
        aBronzeServicePackage.addCosAttribute("mailquota", aBronzeValues[1]);
        aBronzeServicePackage.addCosAttribute("mailmsgquota", aBronzeValues[2]);
        this.addMailServiceAttributes(aBronzeServicePackage, aMailServiceAttrNames, aMailAttributes);
        DAServicePackage.getInformation(aGoldServicePackage);
        DAServicePackage.getInformation(aSilverServicePackage);
        DAServicePackage.getInformation(aBronzeServicePackage);
        if (theSPName.equalsIgnoreCase("gold")) {
            return aGoldServicePackage;
        }
        if (theSPName.equalsIgnoreCase("silver")) {
            return aSilverServicePackage;
        }
        if (theSPName.equalsIgnoreCase("bronze")) {
            return aBronzeServicePackage;
        }
        return null;
    }

    private void addMailServiceAttributes(DAServicePackage theServicePackage, String[] theAttributeNames, String[][] theAttributeValues) {
        int aIdx = 0;
        boolean aIdx2 = false;
        for (aIdx = 0; aIdx < theAttributeNames.length; ++aIdx) {
            theServicePackage.addCosAttribute(theAttributeNames[aIdx], theAttributeValues[aIdx]);
        }
    }

    public static void getInformation(DAServicePackage theServicePackage) throws Exception {
        String aString = null;
        String[] aStrings = null;
        DAAttribute aAttribute = null;
        Vector aVector = null;
        boolean aBoolean = true;
        aString = theServicePackage.getName();
        aStrings = theServicePackage.getServiceTypes();
        aAttribute = theServicePackage.getServiceStatusAttribute(aStrings[0]);
        aString = theServicePackage.getServiceStatusAttributeName(aStrings[0]);
        aStrings = theServicePackage.getServiceTypes();
        aVector = theServicePackage.getCOSAttributes();
        aVector = theServicePackage.getOverwriteableCOSAttributes();
        aVector = theServicePackage.getRequiredAttributes();
        aVector = theServicePackage.getAllowedAttributes();
        aVector = theServicePackage.getAllAttributes();
        aString = theServicePackage.getFirstValue("maildeliveryoption");
        aStrings = theServicePackage.getAttributeValues("maildeliveryoption");
        aAttribute = theServicePackage.getAttribute("mailautoreplymode");
        if (aAttribute != null) {
            aBoolean = aAttribute.isType(16);
        }
        if ((aAttribute = theServicePackage.getAttribute("mailuserstatus")) != null) {
            aBoolean = aAttribute.isType(16);
            aBoolean = aAttribute.isType(256);
            aBoolean = aAttribute.isType(32);
            aBoolean = aAttribute.isType(288);
        }
    }
}

