/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DABusinessOrganization;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAOrganization;
import com.sun.comm.jdapi.DARole;
import com.sun.comm.jdapi.DASearchConstraint;
import com.sun.comm.jdapi.DASearchResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAServicePackageManager;
import com.sun.comm.jdapi.DAUser;
import com.sun.comm.jdapi.DAUtil;
import java.util.HashMap;
import java.util.Vector;

public class DAProviderOrganization
extends DAOrganization {
    private Vector _providerAdminList = new Vector();
    private Vector _currentServicePackageNames = new Vector();

    public DAProviderOrganization() {
    }

    public DAProviderOrganization(DAConnection c) {
        super(c);
    }

    public DABusinessOrganization getOwnBusinessOrganization() throws DAException {
        String[] aSunProviderOrgDN = this.getAttributeValues("sunproviderorgdn");
        if (aSunProviderOrgDN == null || aSunProviderOrgDN.length == 0) {
            throw new DAException("DAProviderOrganization.getOwnBusinessOrganization():" + DAConnection._resourceSet.getString("error", "missingMandatoryAttrsunproviderorgdn"));
        }
        DASearchConstraint aConstraint = null;
        DASearchResults aResult = null;
        HashMap<String, String> avPairs = new HashMap<String, String>();
        avPairs.put("borgdn", aSunProviderOrgDN[0]);
        aConstraint = new DASearchConstraint(null, DASearchConstraint.SUBTREE_SCOPE, avPairs);
        aResult = this.searchOrganization(aConstraint);
        Vector returnedBOrgs = aResult.getResultVector();
        if (returnedBOrgs == null || returnedBOrgs.size() == 0) {
            throw new DAException("DAProviderOrganization.getOwnBusinessOrganization(): unable to locate object: sunproviderorgdn");
        }
        DABusinessOrganization[] pOrgArr = new DABusinessOrganization[returnedBOrgs.size()];
        pOrgArr = returnedBOrgs.toArray(pOrgArr);
        return pOrgArr[0];
    }

    public String[] getServicePackageNames() {
        DAServicePackageManager aSpManager = DAConnection.getServicePackageManager();
        Vector aSpNames = null;
        String[] aSpNamesArray = null;
        String[] aIncludeSpNames = null;
        String[] aExcludeSpNames = null;
        aIncludeSpNames = this.getAttributeValues("sunincludeservices");
        aSpNames = aSpManager.getServicePackageNames(aIncludeSpNames, aExcludeSpNames = this.getAttributeValues("sunexcludeservices"), this.getMyTask());
        if (aSpNames != null && aSpNames.size() > 0) {
            aSpNamesArray = new String[1];
            aSpNamesArray = aSpNames.toArray(aSpNamesArray);
        }
        return aSpNamesArray;
    }

    private DAServicePackage[] getParentServicePackages() {
        return null;
    }

    public DARole getAdminRole() {
        DARole role = new DARole();
        role.setRoleDN("cn=Provider Admin Role," + this.getDN());
        return role;
    }

    public DASearchResults getAdministrators() throws DAException {
        HashMap<String, String> avPair = new HashMap<String, String>();
        avPair.put("nsroledn", "cn=Provider Admin Role," + this.getDN());
        DASearchConstraint cons = new DASearchConstraint(null, DASearchConstraint.SUBTREE_SCOPE, avPair);
        return this.searchUsers(cons);
    }

    public void assignAdminRole(DAUser userObj) throws DAException {
        userObj.addAttribute(new DAAttribute("nsroledn", 2, "cn=Provider Admin Role," + this.getDN()));
        this.getMyTask().doTask("addrole", userObj, this);
    }

    public String constructBusinessOrgDn(DABusinessOrganization theOrganization) throws DAException {
        String aOValue = theOrganization.getName();
        String aDn = null;
        String aFullDn = null;
        String aBusinessOrgType = null;
        boolean aType = false;
        if (aOValue == null) {
            return null;
        }
        aBusinessOrgType = theOrganization.getFirstValue(DAConstants.BUSINESS_ORG_TYPE);
        if (aBusinessOrgType != null && aBusinessOrgType.equalsIgnoreCase("full")) {
            aType = true;
        }
        if (!aType) {
            aDn = "o=" + aOValue + "," + this.getDN();
        } else {
            aFullDn = this.getFirstValue("sunbusinessorgbase");
            if (aFullDn == null) {
                throw new DAException(DAConnection._resourceSet.getString("error", "missingFullBusinessOrgBase"));
            }
            aDn = "o=" + aOValue + "," + aFullDn;
        }
        aDn = DAUtil.normalizeDn(aDn);
        return aDn;
    }

    void setCurrentSpName(String[] theSpNames) {
        this._currentServicePackageNames = DAUtil.convertToVector(theSpNames);
    }
}

