/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DABusinessOrganization;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAGroup;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAProviderOrganization;
import com.sun.comm.jdapi.DAResource;
import com.sun.comm.jdapi.DAResults;
import com.sun.comm.jdapi.DARole;
import com.sun.comm.jdapi.DASearchConstraint;
import com.sun.comm.jdapi.DASearchResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAServicePackageManager;
import com.sun.comm.jdapi.DASpSearch;
import com.sun.comm.jdapi.DATask;
import com.sun.comm.jdapi.DAUser;
import com.sun.comm.jdapi.DAUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DAOrganization
extends DAObject {
    public DAOrganization(String orgName) {
        this.setName(orgName);
    }

    public DAOrganization() {
    }

    public DAOrganization(DAConnection c) {
        super(c);
    }

    public String getName() {
        String aName = super.getName();
        if (aName == null) {
            String[] domainAttr = this.getAttributeValues("sunPreferredDomain");
            if (domainAttr != null && domainAttr.length > 0) {
                return domainAttr[0];
            }
            return this.getFirstValue("dn");
        }
        return aName;
    }

    public String getStatus() {
        return this.getFirstValue("inetdomainstatus");
    }

    public void createGroup(DAGroup groupObj) throws DAException {
        Object aUid = null;
        String aDn = null;
        DATask aMyTask = this.getMyTask();
        if (groupObj == null) {
            throw new DAException(DAConnection._resourceSet.getString("error", "nullGroupObj"));
        }
        aDn = this.constructGroupDn(groupObj);
        if (aDn == null) {
            throw new DAException(DAConnection._resourceSet.getString("error", "missingUid"));
        }
        groupObj.setDN(aDn);
        if (DAConnection.getMode() != 102) {
            groupObj.hasRequiredAttributes(aMyTask);
            groupObj.addServiceChangeAttributes(aMyTask, "create");
            aMyTask.doTask("create", groupObj, this);
        }
    }

    public void modifyGroup(DAGroup groupObj) {
    }

    public void deleteGroup(DAGroup groupObj) {
    }

    private void createResource(DAResource resourceObj) {
    }

    private void modifyResource(DAResource resourceObj) {
    }

    private void deleteResource(DAResource resourceObj) {
    }

    public DASearchResults searchUsers(DASearchConstraint theConstraints) throws DAException {
        Object aSearchResults = null;
        Vector aOrganizationUsers = null;
        String aWildCard = null;
        if (DAConnection.getMode() == 102) {
            aOrganizationUsers = DAConnection.getCacheUsers(this.getDN());
            aWildCard = theConstraints.getFilter();
            if (aWildCard == null) {
                aWildCard = "*";
            }
            return DAUtil.searchObjects(aOrganizationUsers, aWildCard, theConstraints);
        }
        DAUser user = new DAUser();
        DAResults result = new DAResults();
        String searchBase = theConstraints.getSearchBase();
        DAOrganization locationObj = this;
        Map avPairs = null;
        Set attrNames = null;
        String attrName = null;
        if (searchBase != null && searchBase.length() != 0) {
            locationObj = new DAOrganization();
            locationObj.setDN(searchBase);
        }
        if ((avPairs = theConstraints.getFilterAVPairs()) != null) {
            attrNames = avPairs.keySet();
            Iterator itr = attrNames.iterator();
            while (itr.hasNext()) {
                attrName = (String)itr.next();
                user.setAttributeValues(attrName, (String)avPairs.get(attrName));
            }
        }
        user.addAttributeList(theConstraints.getConstraintsAsAttributes());
        result = this.getMyTask().doTask("search", user, locationObj);
        if (this instanceof DAProviderOrganization) {
            if (searchBase == null || searchBase != null && searchBase.length() != 0 && searchBase.equalsIgnoreCase(this.getDN())) {
                DAOrganization domainsRootObj = new DAOrganization();
                String domainsRoot = this.getFirstValue("sunbusinessorgbase");
                DAResults result2 = null;
                if (domainsRoot != null) {
                    domainsRootObj.setDN(domainsRoot);
                    result2 = this.getMyTask().doTask("search", user, domainsRootObj);
                }
                Vector res1 = result.getSearchResult().getResultVector();
                Vector res2 = result2.getSearchResult().getResultVector();
                if (res1 != null && res2 != null) {
                    res1.addAll(res2);
                }
                DASearchResults srchRes = new DASearchResults();
                srchRes.setResultVector(res1);
                result.setSearchResult(srchRes);
            }
        } else {
            System.out.println("location obj is not a provider org Object");
        }
        return result.getSearchResult();
    }

    public DASearchResults searchGroups(DASearchConstraint cons) {
        return null;
    }

    private DASearchResults searchResources(DASearchConstraint cons) {
        return null;
    }

    public DASearchResults searchRoles(DASearchConstraint cons) {
        return null;
    }

    public void purge() {
    }

    public void purge(String[] services) {
    }

    public DARole getAdminRole() {
        return null;
    }

    public DASearchResults getAdministrators() throws DAException {
        return null;
    }

    public void assignAdminRole(DAUser userObj) throws DAException {
    }

    public DAServicePackage[] getServicePackages() throws DAException {
        DAServicePackage[] aSpArray = null;
        Vector aSpVector = null;
        String[] aSpNamesArray = null;
        DAServicePackageManager aSpManager = null;
        aSpNamesArray = this.getServicePackageNames();
        if (aSpNamesArray == null || aSpNamesArray.length == 0) {
            return null;
        }
        aSpManager = DAConnection.getServicePackageManager();
        aSpVector = aSpManager.getServicePackages(aSpNamesArray, null, this.getMyTask());
        aSpArray = new DAServicePackage[1];
        return aSpVector.toArray(aSpArray);
    }

    public DAServicePackage[] getServicePackages(String theWildcard, Map theAvPairs) throws Exception, DAException {
        DASearchResults aSearchResults = null;
        Vector aSpVector = null;
        Object aSpNamesVector = null;
        Object aSpNamesArray = null;
        DAServicePackage[] aSpArray = null;
        if (theWildcard == null && theAvPairs == null) {
            return null;
        }
        aSpArray = this.getServicePackages();
        aSpVector = DAUtil.convertToVector(aSpArray);
        aSearchResults = DAUtil.searchObjects(aSpVector, theWildcard, theAvPairs);
        if ((aSpVector = aSearchResults.getResultVector()).size() > 0) {
            aSpArray = new DAServicePackage[1];
            aSpArray = aSpVector.toArray(aSpArray);
        }
        return aSpArray;
    }

    public DAServicePackage[] getServicePackages(DASpSearch theSearchInfo) throws Exception, DAException {
        DASearchResults aSearchResults = null;
        Vector aSpVector = null;
        Object aSpNamesVector = null;
        Object aSpNamesArray = null;
        DAServicePackage[] aSpArray = null;
        aSpArray = this.getServicePackages();
        aSpVector = DAUtil.convertToVector(aSpArray);
        aSearchResults = DAUtil.searchObjects(aSpVector, theSearchInfo);
        if ((aSpVector = aSearchResults.getResultVector()).size() > 0) {
            aSpArray = new DAServicePackage[1];
            aSpArray = aSpVector.toArray(aSpArray);
        } else {
            aSpArray = null;
        }
        return aSpArray;
    }

    public String[] getServicePackageNames() throws DAException {
        return null;
    }

    String constructUserDn(DAUser theUser) {
        String aUid = theUser.getFirstValue(DAConstants.UID);
        String aDn = null;
        if (aUid == null) {
            return null;
        }
        aDn = "uid=" + aUid + "," + "ou=people" + "," + this.getDN();
        return aDn;
    }

    String constructGroupDn(DAGroup theGroup) {
        String cn = theGroup.getFirstValue(DAConstants.FULL_NAME);
        String aDn = null;
        if (cn == null) {
            return null;
        }
        aDn = DAConstants.FULL_NAME + "=" + cn + "," + "ou=group" + "," + this.getDN();
        return aDn;
    }

    boolean equals(DAOrganization theOrganization) {
        String aThisDn = null;
        String aThatDn = null;
        aThisDn = DAUtil.normalizeDn(this.getDN());
        aThatDn = DAUtil.normalizeDn(theOrganization.getDN());
        if (aThisDn != null) {
            return aThisDn.equalsIgnoreCase(aThatDn);
        }
        return false;
    }

    public boolean equals(Object theObject) {
        DAOrganization aOrganization = (DAOrganization)theObject;
        String aThisDn = null;
        String aThatDn = null;
        aThisDn = DAUtil.normalizeDn(this.getDN());
        aThatDn = DAUtil.normalizeDn(aOrganization.getDN());
        if (aThisDn != null) {
            return aThisDn.equalsIgnoreCase(aThatDn);
        }
        return false;
    }

    public DASearchResults searchOrganization(DASearchConstraint theConstraints) throws DAException {
        DASearchResults aSearchResults = null;
        Vector aBusinessOrgs = null;
        if (DAConnection.getMode() == 102) {
            aBusinessOrgs = DAConnection.getCacheBusinessOrgs(this.getDN());
            aSearchResults = DAUtil.searchObjects(aBusinessOrgs, "*", theConstraints);
            return aSearchResults;
        }
        DABusinessOrganization aOrg = new DABusinessOrganization();
        DAResults result = new DAResults();
        String searchBase = theConstraints.getSearchBase();
        DAOrganization locationObj = this;
        Map avPairs = null;
        Set attrNames = null;
        String attrName = null;
        if (searchBase != null && searchBase.length() != 0) {
            locationObj = new DAOrganization();
            locationObj.setDN(searchBase);
        }
        if ((avPairs = theConstraints.getFilterAVPairs()) != null) {
            attrNames = avPairs.keySet();
            Iterator itr = attrNames.iterator();
            while (itr.hasNext()) {
                attrName = (String)itr.next();
                aOrg.addAttribute(new DAAttribute(attrName, 2048, (String)avPairs.get(attrName)));
            }
        }
        aOrg.addAttributeList(theConstraints.getConstraintsAsAttributes());
        result = this.getMyTask().doTask("search", aOrg, locationObj);
        return result.getSearchResult();
    }

    public void createBusinessOrganization(DABusinessOrganization theBusinessOrganization) throws DAException {
        String aDn = null;
        String domain = null;
        String orgtype = null;
        DATask aMyTask = this.getMyTask();
        aDn = this.constructBusinessOrgDn(theBusinessOrganization);
        theBusinessOrganization.setDN(aDn);
        if (DAConnection.getMode() == 102) {
            DAConnection.getBusinessOrgCache().add(theBusinessOrganization);
        } else {
            theBusinessOrganization.hasRequiredAttributes(aMyTask);
            aMyTask.doTask("create", theBusinessOrganization, this);
            DABusinessOrganization boCreated = null;
            DABusinessOrganization tmpBO = new DABusinessOrganization();
            tmpBO.addAttribute("borgdn", new String[]{theBusinessOrganization.getDN()});
            DAResults results = null;
            results = aMyTask.doTask("search", tmpBO, theBusinessOrganization);
            Vector BOrgs = results.getSearchResult().getResultVector();
            boCreated = (DABusinessOrganization)BOrgs.elementAt(0);
            theBusinessOrganization.setMyTask(aMyTask);
            orgtype = theBusinessOrganization.getFirstValue(DAConstants.BUSINESS_ORG_TYPE);
            domain = orgtype.equalsIgnoreCase("full") ? theBusinessOrganization.getFirstValue("sunpreferreddomain") : boCreated.getFirstValue(DAConstants.AVAILABLE_DOMAIN_NAMES);
            if (theBusinessOrganization.getCreateDefaultOUA()) {
                DAUser user = new DAUser();
                String[] aValues = new String[1];
                String uid = theBusinessOrganization.getDefaultOUAName();
                user.setAttributeValues(DAConstants.UID, "tryautogeneratingmyuid");
                aValues[0] = theBusinessOrganization.getDefaultOUANameForLoginAttr();
                user.addAttribute(DAConstants.LOGIN_ID, aValues);
                user.setAttributeValues(DAConstants.PASSWORD, theBusinessOrganization.getDefaultOUAPassword());
                user.setFirstName("Default");
                user.setLastName("Administrator");
                DAAttribute roleAttr = new DAAttribute("nsroledn", 2, "cn=Organization Admin Role," + theBusinessOrganization.getDN());
                user.addAttribute(roleAttr);
                if (theBusinessOrganization.getCreateDefaultOUA()) {
                    user.setAttributeValues("mail", uid + "@" + domain);
                    user.setAttributeValues("mailhost", boCreated.getFirstValue("preferredmailhost"));
                    user.addAttribute(new DAAttribute("services", 2, "mail"));
                }
                theBusinessOrganization.createUser(user);
            }
            if (orgtype.equalsIgnoreCase("full")) {
                DAGroup group = new DAGroup();
                group.setAttributeValues(DAConstants.FULL_NAME, "Postmaster");
                group.setAttributeValues("mail", "postmaster@" + domain);
                group.setAttributeValues("mailalternateaddress", "postmast@" + domain);
                String[] postmasterMember = theBusinessOrganization.getPostmasterMember();
                if (postmasterMember != null) {
                    group.addAttribute("mgrprfc822mailmember", postmasterMember);
                }
                group.addAttribute(new DAAttribute("services", 2, "mail"));
                theBusinessOrganization.createGroup(group);
            }
        }
    }

    public void modifyBusinessOrganization(DABusinessOrganization theBusinessOrganization) throws DAException {
        DATask aMyTask = this.getMyTask();
        if (DAConnection.getMode() == 102) {
            DAUtil.addObjectToVector(DAConnection.getBusinessOrgCache(), theBusinessOrganization, 1003);
        } else {
            theBusinessOrganization.hasRequiredAttributes(aMyTask);
            aMyTask.doTask("modify", theBusinessOrganization, theBusinessOrganization);
        }
    }

    public void deleteBusinessOrganization(String theBusinessOrganization) throws DAException {
        if (DAConnection.getMode() == 102) {
            DAUtil.removeObjectFromVector(DAConnection.getBusinessOrgCache(), theBusinessOrganization);
        } else {
            DABusinessOrganization aBusinessOrg = new DABusinessOrganization();
            aBusinessOrg.setDN(theBusinessOrganization);
            this.getMyTask().doTask("delete", aBusinessOrg, this);
        }
    }

    public String constructBusinessOrgDn(DABusinessOrganization theOrganization) throws DAException {
        String aOValue = theOrganization.getName();
        String aDn = null;
        if (aOValue == null) {
            return null;
        }
        aDn = "o=" + aOValue + "," + this.getDN();
        aDn = DAUtil.normalizeDn(aDn);
        return aDn;
    }
}

