/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAOrganization;
import com.sun.comm.jdapi.DAResults;
import com.sun.comm.jdapi.DARole;
import com.sun.comm.jdapi.DASearchConstraint;
import com.sun.comm.jdapi.DASearchResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DASpNameCount;
import com.sun.comm.jdapi.DATask;
import com.sun.comm.jdapi.DAUser;
import com.sun.comm.jdapi.DAUtil;
import com.sun.comm.jdapi.PasswordGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DABusinessOrganization
extends DAOrganization {
    private String type;
    private boolean _createDefaultOUA = false;
    private boolean _addOUAToPostmaster = false;
    private String _defaultOUAName = null;
    private String _defaultOUAPassword = null;
    private String[] _postmasterMember = null;

    public DABusinessOrganization() {
    }

    public DABusinessOrganization(DAConnection c) {
        super(c);
    }

    public void createUser(DAUser theUserObject) throws DAException {
        Object aUid = null;
        Object aDn = null;
        Vector aBusinessOrgUsers = null;
        DATask aMyTask = this.getMyTask();
        if (theUserObject == null) {
            throw new DAException(DAConnection._resourceSet.getString("error", "nullUserObj"));
        }
        if (DAConnection.getMode() == 102) {
            aBusinessOrgUsers = DAConnection.getUserCache();
            if (DAUtil.findObjectInVector(aBusinessOrgUsers, theUserObject) >= 0) {
                throw new DAException(DAConnection._resourceSet.getString("error", "userAlreadyExists"));
            }
            DAUtil.addObjectToVector(aBusinessOrgUsers, theUserObject, 1003);
        } else {
            theUserObject.hasRequiredAttributes(aMyTask);
            aMyTask.doTask("create", theUserObject, this);
        }
    }

    public void modifyUser(DAUser theUserObject) throws DAException {
        DATask aMyTask = this.getMyTask();
        Vector aIsServicesToAdd = new Vector();
        Vector aIsServicesToDelete = new Vector();
        Object aServiceValues = null;
        if (DAConnection.getMode() == 102) {
            if (DAUtil.findObjectInVector(DAConnection.getUserCache(), theUserObject) == -1) {
                throw new DAException(DAConnection._resourceSet.getString("error", "userNotFound"));
            }
            DAUtil.addObjectToVector(DAConnection.getUserCache(), theUserObject, 1003);
        } else {
            theUserObject.hasRequiredAttributes(aMyTask);
            aMyTask.doTask("modify", theUserObject, this);
        }
    }

    public void deleteUser(DAUser theUserObject) throws DAException {
        if (DAConnection.getMode() == 102) {
            DAUtil.removeObjectFromVector(DAConnection.getUserCache(), theUserObject);
        } else {
            this.getMyTask().doTask("delete", theUserObject, this);
        }
    }

    public DASpNameCount[] getCurrentServicePackages() {
        Vector aVector = new Vector();
        return this.collectServicePackages(aVector);
    }

    public String[] getServicePackageNames() {
        DASpNameCount[] aServices = null;
        String[] aServiceNames = null;
        int aIdx = 0;
        aServices = this.getCurrentServicePackages();
        if (aServices == null || aServices.length == 0) {
            return null;
        }
        aServiceNames = new String[aServices.length];
        for (aIdx = 0; aIdx < aServices.length; ++aIdx) {
            aServiceNames[aIdx] = aServices[aIdx].getName();
        }
        return aServiceNames;
    }

    public void assignServicePackages(Map theServices) {
        DAAttribute aAttribute = null;
        Iterator aIterator = null;
        String aServiceName = null;
        String aServiceStringCount = null;
        DASpNameCount aNewService = null;
        int aServiceCount = 0;
        int aIndex = 0;
        if (DAConnection.getMode() == 102 || DAConnection.getMode() == 103) {
            aAttribute = new DAAttribute(DAConstants.AVAILABLE_SERVICES);
            aIndex = DAUtil.findObjectInVector(this._attributes, aAttribute);
            if (aIndex > 0) {
                this._attributes.removeElementAt(aIndex);
            }
            aIterator = theServices.keySet().iterator();
            while (aIterator.hasNext()) {
                aServiceName = (String)aIterator.next();
                aServiceStringCount = ((Integer)theServices.get(aServiceName)).toString();
                aServiceCount = aServiceStringCount == null ? -1 : Integer.parseInt(aServiceStringCount);
                aNewService = new DASpNameCount(aServiceName, aServiceCount);
                this.addAttributeValue(DAConstants.AVAILABLE_SERVICES, aNewService.toString());
            }
        }
        if (DAConnection.getMode() == 103) {
            aAttribute = this.getChangeSpAttribute(theServices, 4);
            this._changedAttributes.add(aAttribute);
        }
    }

    public void addServicePackages(Map theServices) {
        Object aSpNameCount = null;
        DASpNameCount aNewService = null;
        DASpNameCount aExistingService = null;
        DAAttribute aChangeAttribute = null;
        Vector aServiceVector = new Vector();
        Vector aOrigChangedAttributes = null;
        Object aKeySet = null;
        String[] aValues = new String[1];
        String aServiceName = null;
        String aServiceStringCount = null;
        Iterator aIterator = null;
        int aServiceCount = 0;
        if (theServices == null) {
            return;
        }
        if (DAConnection.getMode() == 102 || DAConnection.getMode() == 103) {
            aOrigChangedAttributes = new Vector();
            aOrigChangedAttributes.addAll(this._changedAttributes);
            this.collectServicePackages(aServiceVector);
            aIterator = theServices.keySet().iterator();
            while (aIterator.hasNext()) {
                aServiceStringCount = ((Integer)theServices.get(aServiceName = (String)aIterator.next())).toString();
                aServiceCount = aServiceStringCount == null ? -1 : Integer.parseInt(aServiceStringCount);
                aNewService = new DASpNameCount(aServiceName, aServiceCount);
                aExistingService = (DASpNameCount)DAUtil.getObjectInVector(aServiceVector, aNewService);
                if (aExistingService == null) {
                    this.addAttributeValue(DAConstants.AVAILABLE_SERVICES, aNewService.toString());
                    continue;
                }
                aValues[0] = aExistingService.toString();
                this.removeValuesFromAttribute(DAConstants.AVAILABLE_SERVICES, aValues);
                aValues[0] = aNewService.toString();
                this.addValuesToAttribute(DAConstants.AVAILABLE_SERVICES, aValues);
            }
            this._changedAttributes = aOrigChangedAttributes;
        }
        if (DAConnection.getMode() == 103) {
            aChangeAttribute = this.getChangeSpAttribute(theServices, 2);
            this._changedAttributes.add(aChangeAttribute);
        }
    }

    public void removeServicePackages(Map theServices) throws DAException {
        Object aSpNameCount = null;
        DASpNameCount aNewService = null;
        DASpNameCount aExistingService = null;
        Vector aServiceVector = new Vector();
        Vector aOriginalChangedAttributes = null;
        DAAttribute aChangeAttribute = null;
        Object aKeySet = null;
        String[] aValues = new String[1];
        String aServiceStringCount = null;
        String aServiceName = null;
        Iterator aIterator = null;
        int aServiceCount = 0;
        int aNewServiceCount = 0;
        int aExistingServiceCount = 0;
        if (theServices == null || theServices.size() == 0) {
            throw new DAException(DAConnection._resourceSet.getString("error", "nullservicepackagemap"));
        }
        if (DAConnection.getMode() == 102 || DAConnection.getMode() == 103) {
            aOriginalChangedAttributes = new Vector();
            aOriginalChangedAttributes.addAll(this._changedAttributes);
            this.collectServicePackages(aServiceVector);
            aIterator = theServices.keySet().iterator();
            while (aIterator.hasNext()) {
                aServiceName = (String)aIterator.next();
                if (aServiceName == null) {
                    throw new DAException(DAConnection._resourceSet.getString("error", "nullservicepackagename"));
                }
                aServiceStringCount = ((Integer)theServices.get(aServiceName)).toString();
                aServiceCount = aServiceStringCount == null ? -1 : Integer.parseInt(aServiceStringCount);
                aNewService = new DASpNameCount(aServiceName, aServiceCount);
                aExistingService = (DASpNameCount)DAUtil.getObjectInVector(aServiceVector, aNewService);
                if (aExistingService == null) continue;
                aNewServiceCount = aNewService.getCount();
                aExistingServiceCount = aExistingService.getCount();
                if (aNewServiceCount == -1 || aExistingServiceCount - aNewServiceCount <= 0) {
                    aValues[0] = aExistingService.toString();
                    this.removeValuesFromAttribute(DAConstants.AVAILABLE_SERVICES, aValues);
                    continue;
                }
                aValues[0] = aExistingService.toString();
                this.removeValuesFromAttribute(DAConstants.AVAILABLE_SERVICES, aValues);
                aNewService = new DASpNameCount(aNewService.getName(), aExistingServiceCount - aNewServiceCount);
                this.addAttributeValue(DAConstants.AVAILABLE_SERVICES, aNewService.toString());
            }
            this._changedAttributes = aOriginalChangedAttributes;
        }
        if (DAConnection.getMode() == 103) {
            aChangeAttribute = this.getChangeSpAttribute(theServices, 8);
            this._changedAttributes.add(aChangeAttribute);
        }
    }

    public int serviceAlreadyUsed(String theService) throws DAException {
        DASearchResults aSearchResults = null;
        DAResults aResults = null;
        DASearchConstraint aSearchConstraints = null;
        DAServicePackage aSp = null;
        Vector aUserVector = null;
        Vector aBusinessOrgUsers = null;
        Vector aSpVector = null;
        DAAttribute aAttribute = null;
        String aCountString = null;
        int aReturnCount = 0;
        HashMap<String, String> aAvPairs = new HashMap<String, String>();
        if (DAConnection.getMode() == 102) {
            aAvPairs.put("inetcos", theService);
            aSearchConstraints = new DASearchConstraint("base", DASearchConstraint.SUBTREE_SCOPE, aAvPairs);
            aBusinessOrgUsers = DAConnection.getCacheUsers(this.getDN());
            aSearchResults = DAUtil.searchObjects(aBusinessOrgUsers, "*", aSearchConstraints);
            aUserVector = aSearchResults.getResultVector();
            return aUserVector.size();
        }
        aSp = new DAServicePackage();
        aSp.addAttribute(new DAAttribute("count", 2048, "*"));
        aSp.addAttribute(new DAAttribute("spnames", 2048, theService));
        aResults = this.getMyTask().doTask("search", aSp, this);
        aSearchResults = aResults.getSearchResult();
        aSpVector = aSearchResults.getResultVector();
        if (aSpVector != null && aSpVector.size() > 0 && (aAttribute = (aSp = (DAServicePackage)aSpVector.elementAt(0)).getAttribute(theService)) != null && (aCountString = aAttribute.getFirstValue()) != null) {
            aReturnCount = Integer.parseInt(aCountString);
        }
        return aReturnCount;
    }

    public void setCreateDefaultOUA(boolean createOUA, boolean addOUAToPostmaster) {
        this._createDefaultOUA = createOUA;
        this._addOUAToPostmaster = addOUAToPostmaster;
        if (addOUAToPostmaster) {
            String[] tmp = new String[]{this.getDefaultOUAName() + "@" + this.getFirstValue("sunpreferreddomain")};
            this.setPostmasterMember(tmp);
        }
    }

    public boolean getCreateDefaultOUA() {
        return this._createDefaultOUA;
    }

    public boolean getAddOUAToPostmaster() {
        return this._addOUAToPostmaster;
    }

    public void setPostmasterMember(String[] members) {
        this._postmasterMember = members;
    }

    public void setDefaultOUAPassword(String passwd) {
        this._defaultOUAPassword = passwd;
    }

    public String[] getPostmasterMember() {
        return this._postmasterMember;
    }

    public String getDefaultOUAName() {
        String orgtype = this.getFirstValue(DAConstants.BUSINESS_ORG_TYPE);
        Object user = null;
        this._defaultOUAName = "admin";
        String org = this.getFirstValue("o");
        org = org.toLowerCase().replace(' ', '_');
        this._defaultOUAName = this._defaultOUAName + "_" + org;
        return this._defaultOUAName;
    }

    String getDefaultOUANameForLoginAttr() {
        String aDefaultAdmin = null;
        String aOrgName = this.getFirstValue("o");
        Object user = null;
        aDefaultAdmin = "admin";
        if (aOrgName != null) {
            aOrgName = aOrgName.toLowerCase().replace(' ', '_');
            aDefaultAdmin = aDefaultAdmin + "_" + aOrgName;
        }
        return aDefaultAdmin;
    }

    public String getDefaultOUAPassword() {
        if (this._defaultOUAPassword == null) {
            PasswordGenerator pg = new PasswordGenerator();
            this._defaultOUAPassword = pg.generate();
        }
        return this._defaultOUAPassword;
    }

    public String getPostmasterGroupEmail() {
        String domain = this.getFirstValue("sunpreferreddomain");
        return "postmaster@" + domain;
    }

    private DAServicePackage[] getParentServicePackages() {
        return null;
    }

    public DARole getAdminRole() {
        DARole role = new DARole();
        role.setRoleDN("cn=Organization Admin Role," + this.getDN());
        return role;
    }

    public DASearchResults getAdministrators() throws DAException {
        HashMap<String, String> avPair = new HashMap<String, String>();
        avPair.put("nsroledn", "cn=Organization Admin Role," + this.getDN());
        DASearchConstraint cons = new DASearchConstraint(null, DASearchConstraint.SUBTREE_SCOPE, avPair);
        return this.searchUsers(cons);
    }

    public DASearchResults getTopLevelAdministrators() throws DAException {
        HashMap<String, String> avPair = new HashMap<String, String>();
        avPair.put("nsroledn", "cn=Top-level Admin Role," + this.getDN());
        DASearchConstraint cons = new DASearchConstraint(null, DASearchConstraint.SUBTREE_SCOPE, avPair);
        return this.searchUsers(cons);
    }

    public void assignAdminRole(DAUser userObj) throws DAException {
        userObj.addAttribute(new DAAttribute("nsroledn", 2, "cn=Organization Admin Role," + this.getDN()));
        this.getMyTask().doTask("addrole", userObj, this);
    }

    public void assignTopLevelAdminRole(DAUser userObj) throws DAException {
        userObj.addAttribute(new DAAttribute("nsroledn", 2, "cn=Top-level Admin Role," + this.getDN()));
        this.getMyTask().doTask("addrole", userObj, this);
    }

    DASpNameCount[] collectServicePackages(Vector theVector) {
        String[] aSpNames = null;
        DASpNameCount[] aReturnSp = null;
        DASpNameCount aSpNameCount = null;
        int aIdx = 0;
        aSpNames = this.getAttributeValues(DAConstants.AVAILABLE_SERVICES);
        if (aSpNames != null) {
            aReturnSp = new DASpNameCount[aSpNames.length];
            for (aIdx = 0; aIdx < aSpNames.length; ++aIdx) {
                aSpNameCount = new DASpNameCount(aSpNames[aIdx]);
                theVector.add(aSpNameCount);
            }
            aReturnSp = new DASpNameCount[1];
            aReturnSp = theVector.toArray(aReturnSp);
        }
        return aReturnSp;
    }

    DAAttribute getChangeSpAttribute(Map theServices, int theOperation) {
        Iterator aIterator = null;
        String aServiceName = null;
        String aServiceStringCount = null;
        int aServiceCount = 0;
        Vector<String> aChangeValues = new Vector<String>();
        DAAttribute aChangeAttribute = null;
        DASpNameCount aNewService = null;
        String[] aValues = new String[1];
        aIterator = theServices.keySet().iterator();
        while (aIterator.hasNext()) {
            aServiceName = (String)aIterator.next();
            aServiceStringCount = ((Integer)theServices.get(aServiceName)).toString();
            aServiceCount = aServiceStringCount == null ? -1 : Integer.parseInt(aServiceStringCount);
            aNewService = new DASpNameCount(aServiceName, aServiceCount);
            aChangeValues.add(aNewService.toString());
        }
        aValues = aChangeValues.toArray(aValues);
        aChangeAttribute = new DAAttribute(DAConstants.AVAILABLE_SERVICES, theOperation, aValues);
        return aChangeAttribute;
    }

    void fillReadServices() {
        String[] aCurrentServices = this.getAttributeValues(DAConstants.AVAILABLE_SERVICES);
        DASpNameCount aService = null;
        int aIdx = 0;
        this._readServices = new Vector();
        if (aCurrentServices == null || aCurrentServices.length == 0) {
            return;
        }
        for (aIdx = 0; aIdx < aCurrentServices.length; ++aIdx) {
            aService = new DASpNameCount(aCurrentServices[aIdx]);
            this._readServices.add(aService.getName());
        }
    }

    DAAttribute getCosAttribute() {
        String[] aServiceNames = null;
        return new DAAttribute(DAConstants.AVAILABLE_SERVICES, aServiceNames);
    }
}

